/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.singleline;

import com.mapinfo.mapmarker.CHE.parser.CHE_ThoroughFareTypes;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.StringTokenizer;

public class CHEAvoidTypeInPostRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasType1 = this.hasStreetTypeInPost(o1);
        boolean hasType2 = this.hasStreetTypeInPost(o2);
        if (hasType1 && !hasType2) {
            return 1;
        }
        if (!hasType1 && hasType2) {
            return -1;
        }
        return 0;
    }

    private boolean hasStreetTypeInPost(IAddressParsing ap) {
        String post = ap.getSplit().getAddress().getPostAddress();
        if (StringUtilities.isEmpty((String)post)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(post, "., ;-\t'");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if ("ST".equalsIgnoreCase(tok) || !CHE_ThoroughFareTypes.isThoroughfareType(tok)) continue;
            return true;
        }
        return false;
    }
}

