/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.singleline;

import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidGermanTypeEndingInPostRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidMultiNumericsInEitherLineRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidNumericInsideStreetLineRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidSoleNumericInMainSplitRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidSplittingArticleRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidSplittingProperNameRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidSplittingSaintAndNameRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidTypeAsMainRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEAvoidTypeInPostRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEPreferFourDigitPostcodeRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEPreferGermanTownEndingInPostRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEPreferHouseAtEndRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEPreferHouseToIncompletePostcodeRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEPreferPostcodeInLastlineRule;
import com.mapinfo.mapmarker.CHE.singleline.CHEPreferSaintSingleNameOverNoCityRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.filters.NoPostAddressFilter;
import com.mapinfo.mapmarker.core.singleline.parser.CoreSingleLineParser;
import com.mapinfo.mapmarker.core.singleline.parser.IAddressSplitFilter;
import com.mapinfo.mapmarker.core.singleline.parser.NoNumericInAN3Rule;
import com.mapinfo.mapmarker.core.singleline.parser.NumberOfFieldsParsedRule;
import com.mapinfo.mapmarker.core.singleline.parser.PreferTypeInMainRule;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CHESingleLineParser
extends CoreSingleLineParser {
    private static final int MAX_PARSINGS_RETURNED = 1;
    private static final List<Comparator<IAddressParsing>> m_rules;
    private static final List<IAddressSplitFilter> m_filters;
    private boolean bIsGeographicGeocode;

    public CHESingleLineParser() {
        super(m_rules, m_filters, 1);
    }

    public List<IAddressParsing> parse(Address input, IConstraints constraints) throws ParserException {
        this.bIsGeographicGeocode = constraints.getGeocodeType() == 4;
        return super.parse(input, constraints);
    }

    protected List<IAddressParsing> createFinalList(List<IAddressParsing> parsings) {
        IAddressParsing geoParse = null;
        if (this.bIsGeographicGeocode) {
            for (IAddressParsing parsing : parsings) {
                if (!StringUtilities.isEmpty((String)parsing.getSplit().getAddress().getMainAddress())) continue;
                geoParse = parsing;
                break;
            }
        }
        List result = super.createFinalList(parsings);
        if (geoParse != null && result.size() == 1 && !StringUtilities.isEmpty((String)((IAddressParsing)result.get(0)).getSplit().getAddress().getMainAddress())) {
            result.add(0, geoParse);
        }
        return result;
    }

    static {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(new NoNumericInAN3Rule());
        result.add(new CHEPreferFourDigitPostcodeRule());
        result.add(new CHEPreferHouseToIncompletePostcodeRule());
        result.add(new PreferTypeInMainRule());
        result.add(new CHEAvoidSplittingArticleRule());
        result.add(new CHEAvoidMultiNumericsInEitherLineRule());
        result.add(new CHEPreferPostcodeInLastlineRule());
        result.add(new CHEAvoidSplittingSaintAndNameRule());
        result.add(new CHEPreferSaintSingleNameOverNoCityRule());
        result.add(new CHEAvoidSplittingProperNameRule());
        result.add(new CHEAvoidTypeInPostRule());
        result.add(new CHEAvoidSoleNumericInMainSplitRule());
        result.add(new CHEAvoidTypeAsMainRule());
        result.add(new CHEAvoidNumericInsideStreetLineRule());
        result.add(new CHEAvoidGermanTypeEndingInPostRule());
        result.add(new CHEPreferHouseAtEndRule());
        result.add(new CHEPreferGermanTownEndingInPostRule());
        result.add(new NumberOfFieldsParsedRule());
        m_rules = Collections.unmodifiableList(result);
        ArrayList<NoPostAddressFilter> filters = new ArrayList<NoPostAddressFilter>();
        filters.add(new NoPostAddressFilter());
        m_filters = Collections.unmodifiableList(filters);
    }
}

