/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.singleline;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class CHESpecialCaseUtils {
    private static final String FILE = "com/mapinfo/mapmarker/CHE/singleline/CHESpecialCaseUtils.properties";
    private static final Set<String> ARTICLES;
    private static final Set<String> LEADING_ARTICLES;
    private static final Set<String> PROPER_NAMES;
    private static final Set<String> SAINTS;
    private static final Set<String> GERMAN_STREET_SUFFIXES;
    private static final Set<String> GERMAN_TOWN_SUFFIXES;
    private static final String ARTICLE = "A";
    private static final String LEADING_ARTICLE = "LA";
    private static final String PROPER_NAME = "PN";
    private static final String SAINT = "ST";
    private static final String GERMAN_STREET_SUFFIX = "DEUS";
    private static final String GERMAN_TOWN_SUFFIX = "DEUT";

    public static String getFirstWord(String str) {
        int idx;
        if (str != null && (idx = str.indexOf(32)) > 0) {
            return str.substring(0, idx);
        }
        return str;
    }

    public static String getLastWord(String str) {
        int idx;
        if (str != null && (idx = str.lastIndexOf(32)) >= 0 && idx < str.length() - 1) {
            return str.substring(idx + 1);
        }
        return str;
    }

    public static boolean isArticle(String str) {
        return CHESpecialCaseUtils.check(str, ARTICLES);
    }

    public static boolean isLeadingArticle(String str) {
        return CHESpecialCaseUtils.check(str, LEADING_ARTICLES);
    }

    public static boolean isName(String str) {
        return CHESpecialCaseUtils.check(str, PROPER_NAMES);
    }

    public static boolean isSaint(String str) {
        return CHESpecialCaseUtils.check(str, SAINTS);
    }

    public static boolean endsInStreetSuffix(String str) {
        return CHESpecialCaseUtils.endsWith(str, GERMAN_STREET_SUFFIXES);
    }

    public static boolean endsInTownSuffix(String str) {
        return CHESpecialCaseUtils.endsWith(str, GERMAN_TOWN_SUFFIXES);
    }

    private static boolean check(String str, Set set) {
        if (str == null) {
            return false;
        }
        if (set.contains(str)) {
            return true;
        }
        return set.contains(str.toUpperCase().trim());
    }

    private static boolean endsWith(String str, Set<String> set) {
        if (str != null) {
            String check = str.toUpperCase().trim();
            for (String s : set) {
                if (!check.endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Properties elements;
        try {
            elements = FileUtilities.loadProperties((String)FILE);
        }
        catch (IOException IOEx) {
            throw new RuntimeException("Unable to load: " + FILE.substring(FILE.lastIndexOf(92) + 1));
        }
        HashSet<String> tmpArticles = new HashSet<String>();
        HashSet<String> tmpLeadingArticles = new HashSet<String>();
        HashSet<String> tmpNames = new HashSet<String>();
        HashSet<String> tmpSaints = new HashSet<String>();
        HashSet<String> tmpDeus = new HashSet<String>();
        HashSet<String> tmpDeut = new HashSet<String>();
        for (String string : elements.keySet()) {
            String type = elements.getProperty(string);
            if (ARTICLE.equals(type)) {
                tmpArticles.add(string);
                continue;
            }
            if (LEADING_ARTICLE.equals(type)) {
                tmpArticles.add(string);
                tmpLeadingArticles.add(string);
                continue;
            }
            if (PROPER_NAME.equals(type)) {
                tmpNames.add(string);
                continue;
            }
            if (SAINT.equals(type)) {
                tmpSaints.add(string);
                continue;
            }
            if (GERMAN_TOWN_SUFFIX.equals(type)) {
                tmpDeut.add(string);
                continue;
            }
            if (!GERMAN_STREET_SUFFIX.equals(type)) continue;
            tmpDeus.add(string);
        }
        ARTICLES = Collections.unmodifiableSet(tmpArticles);
        LEADING_ARTICLES = Collections.unmodifiableSet(tmpLeadingArticles);
        PROPER_NAMES = Collections.unmodifiableSet(tmpNames);
        SAINTS = Collections.unmodifiableSet(tmpSaints);
        GERMAN_TOWN_SUFFIXES = Collections.unmodifiableSet(tmpDeut);
        GERMAN_STREET_SUFFIXES = Collections.unmodifiableSet(tmpDeus);
    }
}

