/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DictionaryOrderSort;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DEU_AddressFilter {
    private static double ADDITIONAL_FIELD_THRESHOLD = 0.75;
    private static double ADDRESS_THRESHOLD = 0.83;
    private static double PERFECT_ADDITIONAL_FIELD_THRESHOLD = 0.928;
    private static double PERFECT_ADDRESS_THRESHOLD = 0.935;
    private static double PERFECT_GEOGRAPHIC_THRESHOLD = 0.92;
    private static double GEOGRAPHIC_THRESHOLD = 0.8;

    private DEU_AddressFilter() {
    }

    public static void filterAddresses(IConstraints constraints, GeocodeResult geocodeResult) {
        boolean removed;
        List candidates = constraints.getHandler().getMatchResults();
        if (candidates != null && candidates.size() != 0 && (removed = DEU_AddressFilter.maybeFilterStreetCandidates(constraints, candidates) | DEU_AddressFilter.maybeFilterPostalCandidates(candidates) | DEU_AddressFilter.maybeFilterGeographicCandidates(candidates))) {
            DEU_AddressFilter.countCandidates(candidates, geocodeResult);
            DEU_AddressFilter.countCloseMatches(candidates, geocodeResult);
        }
    }

    private static boolean maybeFilterStreetCandidates(IConstraints constraints, List candidates) {
        boolean removed = false;
        if (candidates.get(0) instanceof InternalCandidateAddress) {
            double combined;
            double highest = 0.0;
            Iterator i = candidates.iterator();
            InternalCandidateAddress addr = null;
            while (i.hasNext() && highest != 1.0) {
                addr = (InternalCandidateAddress)i.next();
                double temp = addr.getCombinedAdditionalFieldScore();
                if (!(temp > highest)) continue;
                highest = temp;
            }
            double threshold = highest == 1.0 ? highest * PERFECT_ADDITIONAL_FIELD_THRESHOLD : highest * ADDITIONAL_FIELD_THRESHOLD;
            i = candidates.iterator();
            while (i.hasNext()) {
                addr = (InternalCandidateAddress)i.next();
                combined = addr.getCombinedAdditionalFieldScore();
                if (!(combined > 0.0) || !(threshold > combined)) continue;
                if (addr.getCombinedAddressScore() > 0.8) {
                    if (combined > 0.7) continue;
                    i.remove();
                    removed = true;
                    continue;
                }
                i.remove();
                removed = true;
            }
            highest = 0.0;
            i = candidates.iterator();
            while (i.hasNext() && highest != 1.0) {
                addr = (InternalCandidateAddress)i.next();
                double temp = addr.getCombinedAddressScore();
                if (!(temp > highest)) continue;
                highest = temp;
            }
            threshold = highest >= 0.9 ? highest * PERFECT_ADDRESS_THRESHOLD : highest * ADDRESS_THRESHOLD;
            i = candidates.iterator();
            while (i.hasNext()) {
                addr = (InternalCandidateAddress)i.next();
                combined = addr.getCombinedAddressScore();
                if (!(combined > 0.0) || !(threshold > combined)) continue;
                if (addr.getCombinedAdditionalFieldScore() > 0.705 && addr.isCloseMatch()) {
                    if (combined > 0.81) continue;
                    i.remove();
                    removed = true;
                    continue;
                }
                i.remove();
                removed = true;
            }
            if (candidates.size() > 1) {
                InternalCandidateAddress firstCand = (InternalCandidateAddress)candidates.get(0);
                for (int counter = 1; counter < candidates.size(); ++counter) {
                    InternalCandidateAddress otherCand = (InternalCandidateAddress)candidates.get(counter);
                    if (!firstCand.fromUserDictionary() || !otherCand.fromUserDictionary() || !firstCand.equals((Object)otherCand)) continue;
                    candidates.remove(counter);
                    removed = true;
                }
            }
        }
        if (constraints.getDictionaryUsage() == DictionaryUsagePreference.PREFER_UD) {
            Collections.sort(candidates, new DictionaryOrderSort());
        }
        return removed;
    }

    private static boolean maybeFilterGeographicCandidates(List candidates) {
        boolean removed = false;
        if (candidates.get(0) instanceof InternalGeographicCandidate) {
            double bestGeographicCandidateScore = 0.0;
            double tempBestGeographicCandidateScore = 0.0;
            for (InternalGeographicCandidate geographicCandidate : candidates) {
                tempBestGeographicCandidateScore = geographicCandidate.getCombinedScore();
                if (!(tempBestGeographicCandidateScore > bestGeographicCandidateScore)) continue;
                bestGeographicCandidateScore = tempBestGeographicCandidateScore;
            }
            double threshold = bestGeographicCandidateScore == 1.0 ? bestGeographicCandidateScore * PERFECT_GEOGRAPHIC_THRESHOLD : bestGeographicCandidateScore * GEOGRAPHIC_THRESHOLD;
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                InternalGeographicCandidate geographicCandidate = (InternalGeographicCandidate)iter.next();
                double candScore = geographicCandidate.getCombinedScore();
                if (!(candScore > 0.0) || !(candScore < threshold)) continue;
                iter.remove();
                removed = true;
            }
        }
        return removed;
    }

    private static boolean maybeFilterPostalCandidates(List candidates) {
        return false;
    }

    private static void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private static void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }
}

