/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class DEU_AddressUtils {
    public static final String POST_SEPARATOR_CHAR = new String("POST_SEP");
    public static final String PRE_SEPARATOR_CHAR = new String("PRE_SEP");
    private static final char[] DEU_EXTENDED_CHARS = new char[]{'\u00fc'};

    private DEU_AddressUtils() {
    }

    public static String getFormattedStreetAddress(Address addr, boolean bAppendAddressNumber) {
        String postDir;
        String postAddr;
        String postAddrCommon;
        String preSep;
        String preMainCommon;
        String preAddrCommon;
        String postSep;
        HashMap fields = addr.getAdditionalFields();
        String postTTSeparator = (String)fields.get("POST_TT_SEPARATOR");
        postTTSeparator = postTTSeparator == null ? " " : postTTSeparator;
        String postMainSeparator = (String)fields.get("POST_MAIN_SEPARATOR");
        postMainSeparator = postMainSeparator == null ? "" : postMainSeparator;
        StringBuffer buf = new StringBuffer(100);
        String preDir = addr.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if (fields != null && !fields.isEmpty() && (postSep = (String)fields.get(POST_SEPARATOR_CHAR)) != null && postSep.length() > 0) {
            buf.append(postSep);
        }
        if ((preAddrCommon = (String)fields.get("pre_addr_common")) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get("pre_main_address_common")) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        String newMainAddress = addr.getMainAddress();
        if (postMainSeparator != null) {
            newMainAddress = newMainAddress + postMainSeparator;
        }
        buf.append(newMainAddress);
        if (buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if (fields != null && !fields.isEmpty() && (preSep = (String)fields.get(PRE_SEPARATOR_CHAR)) != null && preSep.length() > 0) {
            buf.append(preSep);
        }
        if ((postAddrCommon = (String)fields.get("post_addr_common")) != null && postAddrCommon.length() != 0) {
            if (postAddrCommon.charAt(0) != '-') {
                buf.append(' ');
            }
            buf.append(postAddrCommon);
        }
        if ((postAddr = addr.getPostAddress()) != null && postAddr.length() != 0) {
            if (!postTTSeparator.equals("-") && postAddr.charAt(0) != '-' && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postAddr);
        }
        if ((postDir = addr.getPostDirectional()) != null) {
            if (!postTTSeparator.equals("-") && postDir.charAt(0) != '-' && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postDir);
        }
        if (bAppendAddressNumber && addr.getAddressNumber() != null) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != ' ') {
                buf.append(' ');
            }
            buf.append(addr.getAddressNumber());
        }
        return buf.toString().trim();
    }

    public static String getFormattedPreAddress(Address addr) {
        String preMainCommon;
        String preAddrCommon;
        String preTT;
        HashMap fields = addr.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String preDir = addr.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((preTT = addr.getPreThoroughfareType()) != null) {
            buf.append(preTT);
            buf.append(' ');
        }
        if ((preAddrCommon = (String)fields.get("pre_addr_common")) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get("pre_main_address_common")) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        return buf.toString().trim();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static long computeOffsetDifference(ParsedNumber inputHouseNumber, Range range) {
        long offset = 0L;
        if (range.getParsedFrom() != null && inputHouseNumber != null) {
            long parsedFromNumber = range.getParsedFrom().getAddressNumber();
            String hnr = inputHouseNumber.getCombinedAddressNumber();
            long inputNumber = 0L;
            inputNumber = hnr != null && (hnr.indexOf("-") > -1 || hnr.indexOf("/") > -1) ? range.getMatchedRangeNumber().getAddressNumber() : inputHouseNumber.getAddressNumber();
            offset = parsedFromNumber - inputNumber;
            if (offset < 0L) {
                offset *= -1L;
            }
        }
        return offset;
    }

    public static ParsedNumber prepareParsedHnrfromString(String inputString) {
        ParsedNumber parsedNumber = null;
        boolean isSlashTrailorSepretor = true;
        if (!(StringUtilities.isEmpty((String)inputString) || inputString.indexOf("/") <= -1 && inputString.indexOf("-") <= -1 || DEU_AddressUtils.isAlphaNumeric(inputString))) {
            String[] strArray = inputString.split("/");
            if (strArray.length <= 1) {
                strArray = inputString.split("-");
                isSlashTrailorSepretor = false;
            }
            if (strArray.length > 1) {
                parsedNumber = new ParsedNumber(strArray[0]);
                parsedNumber.setTrailerSeparator(isSlashTrailorSepretor ? "/" : "-");
                parsedNumber.setAddressTrailer(strArray[1]);
            }
        }
        return parsedNumber;
    }

    public static boolean isAlphaNumeric(String inputString) {
        boolean isAlpha = false;
        if (inputString != null) {
            char[] characters = inputString.toCharArray();
            for (int i = 0; i < characters.length; ++i) {
                if (!Character.isLetter(characters[i])) continue;
                isAlpha = true;
                break;
            }
        }
        return isAlpha;
    }

    public static boolean doesAccentedStringMatched(String string1, String string2) {
        char[] characterArray1 = string1.toCharArray();
        char[] characterArray2 = string2.toCharArray();
        int lengthDiff = Math.min(characterArray1.length, characterArray2.length);
        boolean isMatch = true;
        for (int i = 0; i < lengthDiff; ++i) {
            if (characterArray1[i] == characterArray2[i] || DEU_EXTENDED_CHARS[0] != characterArray1[i] && DEU_EXTENDED_CHARS[0] != characterArray2[i]) continue;
            isMatch = false;
        }
        return isMatch;
    }
}

