/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.geographic.CoreGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.LinkedList;
import java.util.StringTokenizer;

public final class DEU_GeographicGeocoder
implements IGeographicGeocoder {
    private IGeographicGeocoder m_GeographicGeocoder = new CoreGeographicGeocoder();
    private int m_currentCase = 0;

    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        AddressImpl originalAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
        return this.geocodeGeographic(constraints, (Address)originalAddress, true);
    }

    public GeocodeResult geocodeGeographic(IConstraints constraints, Address originalAddress, boolean tryagain) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult geoResult = new GeocodeResult();
        if (tryagain) {
            geoResult = this.m_GeographicGeocoder.geocodeGeographic(constraints);
            tryagain = geoResult.getNumberCloseCandidates() == 0 && ((DEU_Constraints)constraints).isSingleLineInput() ? this.generateNewCase(constraints, originalAddress) : false;
        }
        if (tryagain) {
            return this.geocodeGeographic(constraints, originalAddress, tryagain);
        }
        return geoResult;
    }

    public boolean generateNewCase(IConstraints constraints, Address originalAddress) {
        boolean tryAgain = false;
        Address searchParsedAddress = constraints.getHandler().getParsedAddress();
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                String probableAn3 = originalAddress.getAreaName1();
                if (!StringUtilities.isEmpty((String)probableAn3)) {
                    searchParsedAddress.setAreaName3(probableAn3);
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this.m_currentCase;
                String areaName3 = originalAddress.getAreaName3();
                if (!StringUtilities.isEmpty((String)areaName3) && !DEU_AddressTerm.isMultiWordAreaName(areaName3)) {
                    String[] token = areaName3.split(" ");
                    searchParsedAddress.setAreaName3(token[0]);
                    if (StringUtilities.isEmpty((String)searchParsedAddress.getAreaName1())) {
                        StringBuffer buff = new StringBuffer();
                        for (int i = 1; i < token.length; ++i) {
                            buff.append(token[i]);
                            buff.append(' ');
                        }
                        searchParsedAddress.setAreaName1(buff.toString().trim());
                    }
                    tryAgain = true;
                    break;
                }
            }
            case 2: {
                ++this.m_currentCase;
                String areaName3 = originalAddress.getAreaName3();
                if (!StringUtilities.isEmpty((String)areaName3) && !DEU_AddressTerm.isMultiWordAreaName(areaName3)) {
                    StringTokenizer token = new StringTokenizer(areaName3, " ", true);
                    LinkedList list = StringUtilities.tokensToList((StringTokenizer)token);
                    searchParsedAddress.setAreaName3((String)list.getLast());
                    tryAgain = true;
                    break;
                }
            }
            default: {
                tryAgain = false;
            }
        }
        return tryAgain;
    }
}

