/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.DEU_Range;
import com.mapinfo.mapmarker.DEU.DEU_ScoringAddress;
import com.mapinfo.mapmarker.DEU.DEU_StreetCandidateAddress;
import com.mapinfo.mapmarker.DEU.parser.DEU_Abbreviations;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalCandidateAddress;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.ICandidateRangeIterator;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DEU_InternalCandidateAddress
extends EMEA_InternalCandidateAddress {
    public static final String POSITION_PRECISON = "KEY_POSITION_ACCURACY";
    public static final String AP_POINT_ID = "KEY_STREET_POINT_ID";
    private int m_numAddrNumberFields = 0;
    private int m_numAddrNumberFieldsMatched = 0;
    private String m_addressNumber = null;
    public static int MATCH_NONE = 0;
    public static int MATCH_FIRST = 1;
    public static int MATCH_SECOND = 2;
    public static int MATCH_BOTH_DIFFERENT = 3;
    public static int MATCH_BOTH = 4;
    private int m_matchType = MATCH_NONE;
    protected static StringScorer plainScorer;
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    public static final String POST_ADDR_COMMON = "post_addr_common";
    public static final String POST_MAIN_SEPARATOR = "POST_MAIN_SEPARATOR";
    public static final String PRE_MAIN_ADDRESS_COMMON = "pre_main_address_common";
    public static final String POST_STREET_TYPE_COMMON = "post_st_type_common";
    public static final String POST_TT_SEPARATOR = "POST_TT_SEPARATOR";
    public static final String PRE_TT_SEPARATOR = "PRE_TT_SEPARATOR";
    public static final String PRE_SEPARATOR_CHAR = "PRE_SEP";
    public static final String POST_SEPARATOR_CHAR = "POST_SEP";
    public static final String PRE_THOROUGHFARE_PREFERRED_NAME;
    public static final String POST_THOROUGHFARE_PREFERRED_NAME;
    protected boolean postcode1Matched = true;
    private boolean m_iscommonWord = false;
    private long bestOffset = Long.MAX_VALUE;
    private byte chkInputAddressSuffix = 0;

    public DEU_InternalCandidateAddress() {
    }

    public DEU_InternalCandidateAddress(Address addr) {
        super(addr);
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress output = this.localCandidateAddress(input, constraints);
        CandidateRange range = output.getRangeAt(0);
        output.setPreThoroughfareType(StringUtilities.toProperCase((String)output.getPreThoroughfareType()));
        output.setPostThoroughfareType(StringUtilities.toProperCase((String)output.getPostThoroughfareType()));
        HashMap internalCdAdditionalFields = this.getAdditionalFields();
        HashMap outputCdAdditionalFields = output.getAdditionalFields();
        if (internalCdAdditionalFields == null) {
            internalCdAdditionalFields = new HashMap();
        }
        if (internalCdAdditionalFields != null) {
            String commonTerm;
            String preSep;
            String postSep = (String)internalCdAdditionalFields.get(POST_SEPARATOR_CHAR);
            if (!StringUtilities.isEmpty((String)postSep)) {
                outputCdAdditionalFields.remove(POST_SEPARATOR_CHAR);
            }
            if (!StringUtilities.isEmpty((String)(preSep = (String)internalCdAdditionalFields.get(PRE_SEPARATOR_CHAR)))) {
                outputCdAdditionalFields.remove(PRE_SEPARATOR_CHAR);
            }
            if (!StringUtilities.isEmpty((String)(commonTerm = (String)internalCdAdditionalFields.get("input_street_commonterm")))) {
                outputCdAdditionalFields.remove("input_street_commonterm");
            }
        }
        if (range != null && this.isAPCandidate()) {
            outputCdAdditionalFields.put(POSITION_PRECISON, (String)range.getAdditionalField(POSITION_PRECISON));
            Segment segment = this.getSegment();
            DEU_Range deurange = (DEU_Range)segment.getRangeAt(0, 0);
            segment.setSegmentId(Long.toString(deurange.getPointID()));
            outputCdAdditionalFields.put("SEGMENT_ID", Long.toString(deurange.getPointID()));
        }
        StringBuffer buf = new StringBuffer();
        String foramttedMainAddressString = output.getFormattedStreetAddress();
        buf.append(foramttedMainAddressString);
        if (output.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)output.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            buf.append(" " + this.getInputNumber().getCombinedAddressNumber());
            output.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        } else if (output.getAddressNumber() != null && output.getAddressNumber().length() != 0) {
            buf.append(" " + output.getAddressNumber());
        }
        output.setFormattedStreetAddress(buf.toString());
        output.setPreAddress(null);
        output.setPostAddress(null);
        output.setGenericField1(null);
        output.setGenericField4(null);
        output.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        output.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(this.inputMatchScore));
        return output;
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        if (this.isAPCandidate()) {
            Segment segment = this.getSegment();
            DEU_Range range = (DEU_Range)segment.getRangeAt(0, 0);
            segment.setSegmentId(Long.toString(range.getPointID()));
        }
        ReverseGeocodeCandidateAddress originalRGOutput = super.toCandidateAddress(location, constraints);
        DEU_Constraints constr = new DEU_Constraints();
        constr.setMaxRanges(0);
        CandidateAddress geocodeOutput = this.toCandidateAddress((Address)new AddressImpl(), (IConstraints)constr);
        ReverseGeocodeCandidateAddress newRGOutput = new ReverseGeocodeCandidateAddress((Address)geocodeOutput, this.getDictionaryPriority() + 1, new Length(this.getDistance(), LinearUnit.METER));
        newRGOutput.setFormattedStreetAddress(geocodeOutput.getFormattedStreetAddress());
        newRGOutput.setFormattedLocationAddress(geocodeOutput.getFormattedLocationAddress());
        if (this.fromUserDictionary()) {
            newRGOutput.setFromUserDictionary();
        }
        newRGOutput.setPrecisionCode(originalRGOutput.getPrecisionCode());
        newRGOutput.setLocation(originalRGOutput.getLocation());
        newRGOutput.setLocationPrecision(originalRGOutput.getLocationPrecision());
        newRGOutput.setCoordSysString(originalRGOutput.getCoordSysString());
        ICandidateRangeIterator rngItr = originalRGOutput.rangeIterator();
        if (rngItr.hasNext()) {
            newRGOutput.addCandidateRange(rngItr.next());
            newRGOutput.setNumberOfReturnableRanges(1);
        }
        return newRGOutput;
    }

    private String getProperMainAddress() {
        String tabMainAddress = this.getGenericField4();
        return tabMainAddress;
    }

    public CandidateAddress localCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        Segment segment;
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        ResourceBundle errorBundle = this.loadResourceBundleForLocale(constraints.getClientLocale());
        CandidateAddress candidate = new CandidateAddress((Address)this);
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        candidate.setSourceStreetID(this.getStreetOffset());
        String properStreet = candidate.getFormattedStreetAddress();
        if (properStreet != null && properStreet.length() != 0) {
            if (!StringUtilities.isEmpty((String)candidate.getPostThoroughfareType())) {
                candidate.setMainAddress(StringUtilities.toProperCase((String)properStreet.toUpperCase().replaceAll(candidate.getPostThoroughfareType().toUpperCase(), "")).trim());
            } else {
                candidate.setMainAddress(properStreet);
            }
        }
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getPostAddressScore() == 1.0 && this.getPreAddressScore() == 1.0) {
            candidate.setStreetPrefixAndSuffixMatched();
        }
        if (this.fieldExists(input.getMainAddress()) && this.getMainAddressScore() == 1.0) {
            candidate.setStreetNameMatched();
        }
        if (this.getPreDirectionalScore() == 1.0) {
            candidate.setPreDirectionalMatched();
        }
        if (this.getPostDirectionalScore() == 1.0) {
            candidate.setPostDirectionalMatched();
        }
        if (this.getPreThoroughfareTypeScore() == 1.0 && this.getPostThoroughfareTypeScore() == 1.0) {
            candidate.setThoroughfareTypeMatched();
        }
        if (this.fieldExists(input.getPostCode1()) && this.getPostCode1Score() == 1.0) {
            candidate.setPostalCode1Matched();
        }
        if (this.fieldExists(input.getPostCode2()) && this.getPostCode2Score() == 1.0) {
            candidate.setPostalCode2Matched();
        }
        if (this.fieldExists(input.getAreaName1()) && this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (this.fieldExists(input.getAreaName2()) && this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (this.fieldExists(input.getAreaName3()) && this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.fieldExists(input.getAreaName4()) && this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.fieldExists(input.getPlaceName()) && this.getPlaceNameScore() == 1.0) {
            candidate.setPlaceNameMatched();
        }
        int maxRanges = constraints.getMaxRanges();
        candidate.setNumberOfReturnableRanges(maxRanges);
        ParsedNumber num = new ParsedNumber(input.getAddressNumber());
        ParsedNumber unitNum = new ParsedNumber(input.getUnitValue());
        if (!num.isEmpty() && this.getAddressNumberScore() == 1.0) {
            candidate.setAddressNumberMatched();
            if (!this.isAPCandidate()) {
                candidate.setAddressNumber(num);
            }
        }
        if (maxRanges != 0) {
            CandidateRange candidateRange;
            CandidateRange candRange;
            DEU_Range range;
            int i;
            segment = this.getSegment();
            int numLeftRanges = segment.getRangeCount(0);
            int numRightRanges = segment.getRangeCount(1);
            for (i = 0; i < numLeftRanges; ++i) {
                range = (DEU_Range)segment.getRangeAt(i, 0);
                candRange = range.toCandidateRange(num, 1, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
            for (i = 0; i < numRightRanges; ++i) {
                range = (DEU_Range)segment.getRangeAt(i, 1);
                candRange = range.toCandidateRange(num, 2, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
            if (!num.isEmpty() && (candidateRange = candidate.getRangeAt(0)) != null && this.isAPCandidate()) {
                candidate.setAddressNumber(candidateRange.getLowAddress());
            }
        } else if (this.isAPCandidate()) {
            segment = this.getSegment();
            ArrayList rangeList = new ArrayList(segment.getRanges(0));
            Collections.sort(rangeList, new DEU_RangeComparator(num));
            if (rangeList.size() > 1) {
                candidate.setAddressNumber(((Range)rangeList.get(0)).getParsedFrom());
            }
        }
        if (input.getAddressNumber() == null) {
            if (!this.isAPCandidate()) {
                if (this.fieldExists(input.getPlaceName())) {
                    if (this.getPlaceNameScore() == 1.0) {
                        candidate.setAddressNumberMatched();
                    }
                } else if (candidate.getAddressNumber() == null || this.getAddressNumberScore() == 1.0) {
                    candidate.setAddressNumberMatched();
                }
            } else {
                CandidateRange range = candidate.getRangeAt(0);
                if (range != null) {
                    candidate.setAddressNumber(range.getLowAddress());
                    candidate.setPlaceName(range.getPlaceName());
                    if (this.getAddressNumberScore() == 1.0) {
                        candidate.setAddressNumberMatched();
                    } else if (this.fieldExists(input.getPlaceName()) && this.getPlaceNameScore() == 1.0) {
                        candidate.setAddressNumberMatched();
                    }
                }
            }
        }
        this.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        this.populateSegmentId((Address)candidate);
        return candidate;
    }

    public double getAddressNumberScore() {
        if (this.getInputNumber() == null || this.m_numAddrNumberFields == 0) {
            return 0.0;
        }
        double hnrScore = (double)this.m_numAddrNumberFieldsMatched / (double)this.m_numAddrNumberFields;
        if (hnrScore >= 0.5 && this.isAPCandidate()) {
            return 1.0;
        }
        return hnrScore;
    }

    @Override
    public String getAddressNumber() {
        String addressNumber = null;
        addressNumber = this.m_addressNumber != null ? this.m_addressNumber : super.getAddressNumber();
        return addressNumber;
    }

    @Override
    public String getFormattedStreetAddress() {
        String preSep;
        String tempStr;
        String postSep;
        String type;
        StringBuffer str = new StringBuffer();
        String properStreet = this.getProperMainAddress();
        if (properStreet != null && properStreet.length() != 0) {
            str.append(properStreet);
            return str.toString();
        }
        HashMap adFields = this.getAdditionalFields();
        if (this.getPreThoroughfareType() != null && (type = DEU_ThoroughfareTypes.lookupProperName(this.getPreThoroughfareType())) != null) {
            type = StringUtilities.toProperCase((String)type);
            str.append(type);
        }
        if (adFields != null && !adFields.isEmpty() && (postSep = (String)adFields.get(POST_SEPARATOR_CHAR)) != null && postSep.length() > 0) {
            str.append(postSep);
        }
        if ((tempStr = this.getPreAddress()) != null) {
            str.append(tempStr);
            int len = tempStr.length();
            if (len > 0 && tempStr.charAt(len - 1) != '-') {
                str.append(' ');
            }
        }
        if (this.getMainAddress() != null) {
            str.append(this.getMainAddress());
        }
        boolean upperCasePostType = false;
        if (adFields != null && !adFields.isEmpty() && (preSep = (String)adFields.get(PRE_SEPARATOR_CHAR)) != null && preSep.length() > 0) {
            upperCasePostType = true;
            str.append(preSep);
        }
        if (this.getPostThoroughfareType() != null) {
            String postType = DEU_ThoroughfareTypes.lookupProperName(this.getPostThoroughfareType());
            if (upperCasePostType) {
                str.append(postType.substring(0, 1).toUpperCase());
                str.append(postType.substring(1));
            } else {
                str.append(postType);
            }
        }
        tempStr = this.getPostAddress();
        if (this.getPostAddress() != null && tempStr.length() > 0) {
            if (str.length() > 0 && (tempStr.charAt(0) != ' ' || tempStr.charAt(0) != '-')) {
                str.append(' ');
            }
            str.append(tempStr);
        }
        return str.toString();
    }

    public void scoreAdditionalParserFields(ScoringAddress parsedAddress) {
        if (!parsedAddress.hasAdditionalFields()) {
            if (!this.hasAdditionalFields()) {
                this.setAdditionalParserFieldsScore(1.0);
                return;
            }
            this.setAdditionalParserFieldsScore(0.0);
            return;
        }
        this.setAdditionalParserFieldsScore(0.0);
        if (this.hasAdditionalFields()) {
            String parsedPreSep = (String)parsedAddress.getAdditionalFields().get(PRE_SEPARATOR_CHAR);
            String parsedPostSep = (String)parsedAddress.getAdditionalFields().get(POST_SEPARATOR_CHAR);
            String candidatePreSep = (String)this.getAdditionalFields().get(PRE_SEPARATOR_CHAR);
            String candidatePostSep = (String)this.getAdditionalFields().get(POST_SEPARATOR_CHAR);
            String candiateCommanWord = (String)this.getAdditionalFields().get("input_street_commonterm");
            String parsedCommanWord = (String)parsedAddress.getAdditionalFields().get("input_street_commonterm");
            double highscore = 0.0;
            if (candiateCommanWord != null || parsedCommanWord != null) {
                this.setCountCommonWord(true);
                EMEA_ScoringAddress scorer = (EMEA_ScoringAddress)parsedAddress;
                highscore = scorer.scoreItems(parsedCommanWord, candiateCommanWord);
                this.setAdditionalParserFieldsScore(highscore);
                if (highscore == 1.0) {
                    this.setCountCommonWord(true);
                }
                if (StringUtilities.isEmpty((String)parsedCommanWord) && this.getPreAddressScore() != 1.0 && !StringUtilities.isEmpty((String)parsedAddress.getPreAddress()) && parsedAddress.getPreAddress().toUpperCase().indexOf(candiateCommanWord.toUpperCase()) > -1) {
                    this.setCountCommonWord(true);
                    this.setAdditionalParserFieldsScore(1.0);
                    highscore = 1.0;
                }
                if (!StringUtilities.isEmpty((String)parsedAddress.getPreAddress()) && DEU_Abbreviations.hasAbbreviation(candiateCommanWord) && this.getPreAddressScore() == 1.0) {
                    this.setCountCommonWord(false);
                    return;
                }
                if (highscore == 0.0 && this.getAddressNumberScore() == 1.0) {
                    this.setAdditionalParserFieldsScore(0.01);
                }
                return;
            }
            if (parsedPreSep != null && candidatePreSep != null) {
                if (parsedPreSep.equals(candidatePreSep)) {
                    this.setAdditionalParserFieldsScore(1.0);
                } else {
                    this.setAdditionalParserFieldsScore(0.5);
                }
                return;
            }
            if (parsedPostSep != null && candidatePostSep != null) {
                if (parsedPostSep.equals(candidatePostSep)) {
                    this.setAdditionalParserFieldsScore(1.0);
                } else {
                    this.setAdditionalParserFieldsScore(0.5);
                }
                return;
            }
            if (candiateCommanWord != null && parsedCommanWord != null) {
                if (candiateCommanWord.equalsIgnoreCase(parsedCommanWord)) {
                    this.setAdditionalParserFieldsScore(this.getAdditionalParserFieldsScore() + 0.5);
                } else {
                    this.setAdditionalParserFieldsScore(this.getAdditionalParserFieldsScore());
                }
                return;
            }
            if (candidatePreSep != null && candidatePreSep.equals(" ")) {
                this.setAdditionalParserFieldsScore(0.01);
            }
        } else {
            double tempPCScore = 0.0;
            tempPCScore = this.fieldExists(parsedAddress.getPostCode1()) ? this.getPostCode1Score() : 1.0;
            double tempAN3Score = 0.0;
            tempAN3Score = this.fieldExists(parsedAddress.getAreaName3()) ? this.getAreaName3Score() : 1.0;
            if (this.getAddressNumberScore() == 1.0 && this.getMainAddressScore() == 1.0 && tempAN3Score == 1.0 && tempPCScore == 1.0) {
                this.setAdditionalParserFieldsScore(1.0);
            } else {
                this.setAdditionalParserFieldsScore(0.01);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Object o1, Object o2) {
        double score2;
        double score1;
        DEU_InternalCandidateAddress cand1 = (DEU_InternalCandidateAddress)((Object)o1);
        DEU_InternalCandidateAddress cand2 = (DEU_InternalCandidateAddress)((Object)o2);
        if (cand1.equals((Object)cand2)) {
            if (!cand1.doesCountCommonWord() && cand2.doesCountCommonWord()) {
                return -1;
            }
            if (cand1.doesCountCommonWord() && !cand2.doesCountCommonWord()) {
                return 1;
            }
            if (cand1.getAddressNumberScore() != cand2.getAddressNumberScore()) return 0;
            int retValue = this.chkAlphaNumericAPAddrNumber(cand1, cand2);
            if (retValue != 0) return retValue;
            if (cand1.hasDictionaryBonus() != cand2.hasDictionaryBonus()) return retValue;
            if (cand1.fromUserDictionary() && !cand2.fromUserDictionary()) {
                return -1;
            }
            if (cand1.fromUserDictionary()) return retValue;
            if (!cand2.fromUserDictionary()) return retValue;
            return 1;
        }
        boolean bCand1Match = cand1.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        bCand1Match = cand1.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        if (cand1.getMainAddressScore() == 0.0 && cand2.getMainAddressScore() == 0.0) {
            score1 = cand1.getPlaceNameScore();
            score2 = cand2.getPlaceNameScore();
        } else {
            score1 = cand1.getCombinedAddressScore();
            score2 = cand2.getCombinedAddressScore();
        }
        if (score1 == score2) {
            score1 = cand1.getCombinedAdditionalFieldScore();
            if (score1 < (score2 = cand2.getCombinedAdditionalFieldScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getPostCode1Score();
            if (score1 < (score2 = cand2.getPostCode1Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getPlaceNameScore();
            if (score1 < (score2 = cand2.getPlaceNameScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getMainAddressScore();
            if (score1 < (score2 = cand2.getMainAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getAdditionalParserFieldsScore();
            if (score1 < (score2 = cand2.getAdditionalParserFieldsScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getAddressNumberScore();
            if (score1 == (score2 = cand2.getAddressNumberScore())) {
                if (!cand1.doesCountCommonWord() && cand2.doesCountCommonWord()) {
                    return -1;
                }
                if (cand1.doesCountCommonWord() && !cand2.doesCountCommonWord()) {
                    return 1;
                }
                if (cand1.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
                    if (!cand1.hasDictionaryBonus()) return -1;
                    return 1;
                }
                if (cand1.isHackedCandidate() != cand2.isHackedCandidate()) {
                    if (!cand1.isHackedCandidate()) return -1;
                    return 1;
                }
            }
            if (score1 < score2) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (score1 == 1.0) return 0;
            if (score2 == 1.0) return 0;
            if (cand1.hasClosestRange() && cand2.hasClosestRange()) {
                long cand2Offset;
                Range cand1Closest = cand1.getSegment().getRangeAt(cand1.getClosestRangeNumber(), cand1.getClosestSegmentSide());
                Range cand2Closest = cand2.getSegment().getRangeAt(cand2.getClosestRangeNumber(), cand2.getClosestSegmentSide());
                long cand1Offset = cand1Closest.getRangeOffset();
                if (cand1Offset < (cand2Offset = cand2Closest.getRangeOffset())) {
                    return 1;
                }
                if (cand1Offset <= cand2Offset) return 0;
                return -1;
            }
            if (cand1.hasClosestRange()) {
                return 1;
            }
            if (!cand2.hasClosestRange()) return 0;
            return -1;
        }
        if (!(score1 < score2)) return 1;
        return -1;
    }

    private boolean isHackedCandidate() {
        return ((DEU_StreetCandidateAddress)this.getStreetCandidateAddress()).isCandidateHacked();
    }

    public boolean equals(Object obj) {
        DEU_InternalCandidateAddress cand = (DEU_InternalCandidateAddress)((Object)obj);
        if (super.equals(obj)) {
            return this.getPreThoroughfareTypeScore() == 0.0 && cand.getPreThoroughfareTypeScore() == 0.0 && this.getPreThoroughfareType() != null && cand.getPreThoroughfareType() != null ? this.getPreThoroughfareType().equalsIgnoreCase(cand.getPreThoroughfareType()) : this.isAPCandidate() == cand.isAPCandidate();
        }
        return false;
    }

    public void scoreAreaNames(ScoringAddress parsedAddress) {
        double score;
        DEU_ScoringAddress scorer = (DEU_ScoringAddress)parsedAddress;
        EMEA_GeoInfoRecord emeaGeoRecord = (EMEA_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        String pAreaName3 = DEU_InternalCandidateAddress.removeHyphens(parsedAddress.getAreaName3());
        String cAreaName3 = DEU_InternalCandidateAddress.removeHyphens(this.getAreaName3());
        String pAreaName4 = DEU_InternalCandidateAddress.removeHyphens(parsedAddress.getAreaName4());
        String cAreaName4 = DEU_InternalCandidateAddress.removeHyphens(this.getAreaName4());
        double highScore = 0.0;
        if (pAreaName3 != null) {
            String numberSeperatedAN3;
            String altAreaName;
            highScore = scorer.scoreItems(pAreaName3, cAreaName3);
            if (highScore != 1.0 && pAreaName4 == null) {
                score = scorer.scoreItems(pAreaName3, cAreaName4);
                double d = highScore = score > highScore ? score : highScore;
            }
            if (highScore != 1.0 && emeaGeoRecord != null && (altAreaName = emeaGeoRecord.getAltLanguageNames()) != null) {
                String altArea;
                StringTokenizer st = new StringTokenizer(altAreaName, "/");
                while (st.hasMoreTokens() && (highScore = (score = scorer.scoreItems(pAreaName3, altArea = st.nextToken())) > highScore ? score : highScore) != 1.0) {
                }
            }
            if (highScore != 1.0) {
                highScore = this.scoreAreaNamesTokens(scorer, pAreaName3, cAreaName3, highScore);
            }
            if (highScore != 1.0 && pAreaName3 != null && pAreaName3.length() > 0 && !pAreaName3.equalsIgnoreCase(numberSeperatedAN3 = pAreaName3.replaceAll("\\d", ""))) {
                score = scorer.scoreItems(numberSeperatedAN3, cAreaName3);
                highScore = score > highScore ? score : highScore;
                highScore -= 0.01;
            }
            if (highScore != 1.0) {
                String candidateAn3 = DEU_ParsePostAddressRule.removeCommonWords(cAreaName3);
                String ParsedAn3 = DEU_ParsePostAddressRule.removeCommonWords(pAreaName3);
                score = scorer.scoreStrings(ParsedAn3, candidateAn3);
                if (highScore < score) {
                    highScore = score;
                    highScore -= 0.01;
                }
            }
            if (highScore != 1.0 && parsedAddress.getGenericField2() != null) {
                String[] caSplit;
                String[] paSplit;
                String paAN3 = DEU_InternalCandidateAddress.removeHyphens(parsedAddress.getAreaName3());
                String caAN3 = DEU_InternalCandidateAddress.removeHyphens(this.getAreaName3());
                if (paAN3.indexOf(" ") > -1 && caAN3.indexOf(" ") == -1 && highScore < (score = scorer.scoreStrings((paSplit = paAN3.split(" "))[0], (caSplit = caAN3.split(" "))[0]))) {
                    highScore = score;
                }
                parsedAddress.setGenericField3(null);
            }
            this.setAreaName3Score(highScore);
        }
        highScore = 0.0;
        if (pAreaName4 != null && (highScore = scorer.scoreStrings(pAreaName4, cAreaName4)) != 1.0) {
            score = scorer.scoreItems(pAreaName4, cAreaName3);
            highScore = score > highScore ? score : highScore;
        }
        this.setAreaName4Score(highScore);
        highScore = 0.0;
        highScore = scorer.scoreItems(DEU_InternalCandidateAddress.removeHyphens(parsedAddress.getAreaName1()), DEU_InternalCandidateAddress.removeHyphens(this.getAreaName1()));
        this.setAreaName1Score(highScore);
        highScore = 0.0;
        highScore = scorer.scoreItems(DEU_InternalCandidateAddress.removeHyphens(parsedAddress.getAreaName2()), DEU_InternalCandidateAddress.removeHyphens(this.getAreaName2()));
        this.setAreaName2Score(highScore);
    }

    private double scoreAreaNamesTokens(DEU_ScoringAddress scorer, String pAreaName3, String cAreaName3, double highScore) {
        StringTokenizer st1;
        LinkedList listOfCandTokens;
        double localHighScore = highScore;
        LinkedList listOfTokens = null;
        if (pAreaName3 != null) {
            StringTokenizer st = new StringTokenizer(pAreaName3, " -/\\().");
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)st);
        }
        String lastToken = null;
        String firstToken = null;
        if (listOfTokens != null && listOfTokens.size() > 1) {
            lastToken = (String)listOfTokens.getLast();
            firstToken = (String)listOfTokens.getFirst();
            double score = scorer.scoreItems(lastToken, cAreaName3);
            if (localHighScore < score) {
                localHighScore = score - 0.01 * (double)listOfTokens.size();
            } else {
                score = scorer.scoreItems(firstToken, cAreaName3);
                if (localHighScore < score) {
                    localHighScore = score - 0.01 * (double)listOfTokens.size();
                }
            }
        } else if (cAreaName3 != null && (listOfCandTokens = StringUtilities.tokensToList((StringTokenizer)(st1 = new StringTokenizer(cAreaName3, " -/\\().")))).size() > 1) {
            lastToken = (String)listOfCandTokens.getLast();
            firstToken = (String)listOfCandTokens.getFirst();
            double score = scorer.scoreItems(firstToken, pAreaName3);
            if (localHighScore < score) {
                localHighScore = score - 0.04 * (double)listOfCandTokens.size();
            } else {
                score = scorer.scoreItems(lastToken, pAreaName3);
                if (localHighScore < score) {
                    localHighScore = score - 0.04 * (double)listOfCandTokens.size();
                }
            }
        }
        return localHighScore;
    }

    public void scorePostalInformation(ScoringAddress parsedAddress) {
        double score;
        String parsedpc = parsedAddress.getPostCode1();
        String candpc = this.getPostCode1();
        if (parsedpc != null && parsedpc.length() < 5) {
            for (int i = parsedpc.length(); i < 5; ++i) {
                parsedpc = "0" + parsedpc;
            }
        }
        if ((score = plainScorer.scoreString(parsedpc, candpc)) != 1.0 && parsedpc != null && parsedpc.length() > 2 && candpc != null) {
            if (!candpc.startsWith(parsedpc.substring(0, 3))) {
                score *= 0.65;
            } else if (candpc.startsWith(parsedpc.substring(0, 4))) {
                score *= 0.921;
            } else if (candpc.startsWith(parsedpc.substring(0, 3))) {
                score *= 0.95;
            }
        }
        this.setPostCode1Score(score);
        this.setPostCode2Score(plainScorer.scoreString(parsedAddress.getPostCode2(), this.getPostCode2()));
    }

    public void computeScores(ScoringAddress parsedAddress, String charsToIgnore) {
        super.computeScores(parsedAddress, charsToIgnore);
        this.scoreAdditionalParserFields(parsedAddress);
    }

    @Override
    public String getAreaName4() {
        String areaName;
        String string = areaName = this.getSegment() == null ? null : this.getSegment().getLeftAreaName4();
        if (areaName == null) {
            areaName = this.getStreetCandidateAddress().getAreaName4();
        }
        return areaName;
    }

    @Override
    public String getAreaName3() {
        String areaName3 = this.getStreetCandidateAddress().getAreaName3();
        if (areaName3 == null) {
            areaName3 = this.getSegment() == null ? null : this.getSegment().getLeftAreaName3();
        }
        return areaName3;
    }

    public void setAreaName4(String segmentLocality) {
        Segment privateSegment = this.getSegment();
        privateSegment.setLeftAreaName4(segmentLocality);
        privateSegment.setRightAreaName4(segmentLocality);
    }

    public double getForeignLanguageAreaNameScores(String areaName, EMEA_ScoringAddress input) {
        double highscore = 0.0;
        if (areaName != null && this.getAltAreaName3() != null) {
            StringTokenizer tokens = new StringTokenizer(this.getAltAreaName3(), "/", false);
            while (tokens.hasMoreTokens()) {
                String s = tokens.nextToken();
                double score = input.scoreItems(s, areaName);
                if (!(score > highscore)) continue;
                highscore = score;
                if (score != 1.0) continue;
                return 1.0;
            }
            return highscore;
        }
        return 0.0;
    }

    public void scoreMainAddress(ScoringAddress parsedAddress) {
        EMEA_ScoringAddress scorer = (EMEA_ScoringAddress)parsedAddress;
        String strParsed = parsedAddress.getMainAddress();
        String strCandidate = this.getMainAddress();
        double score = scorer.scoreItems(strParsed, strCandidate);
        this.setMainAddressScore(score);
    }

    public static String reconstructAddress(InternalCandidateAddress cand) {
        String original_address = cand.getGenericField4();
        if (original_address != null) {
            return original_address;
        }
        StringBuffer buff = new StringBuffer();
        String tmp = DEU_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get("address.start"));
        if (tmp.length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = DEU_InternalCandidateAddress.noNulls(cand.getPreThoroughfareType())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = DEU_InternalCandidateAddress.noNulls(DEU_InternalCandidateAddress.getFormattedPreAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(' ');
            }
        }
        if ((tmp = DEU_InternalCandidateAddress.noNulls(DEU_InternalCandidateAddress.reconstructMainAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = DEU_InternalCandidateAddress.noNulls(cand.getAddressNumber())).length() > 0) {
            buff.append(' ');
            buff.append(tmp);
        }
        return buff.toString();
    }

    public int getCntAddressNumberFieldsMatched() {
        int fieldsMatched = super.getCntAddressNumberFieldsMatched();
        ParsedNumber inputNumber = this.getInputNumber();
        if (inputNumber != null) {
            char c;
            String addrSuffix;
            if (fieldsMatched == inputNumber.getNumFields() || fieldsMatched == 0) {
                return fieldsMatched;
            }
            if (!this.isAPCandidate() && (addrSuffix = this.getInputNumber().getAddressSuffix().trim()) != null && addrSuffix.length() == 1 && (c = addrSuffix.toUpperCase().charAt(0)) >= 'A' && c <= 'Z') {
                ++fieldsMatched;
            }
        }
        return fieldsMatched;
    }

    private static char toUpper(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch - 32);
        }
        return ch;
    }

    private static String removeHyphens(String word) {
        if (word != null) {
            return word.replace('-', ' ').toUpperCase();
        }
        return null;
    }

    @Override
    public String getAreaName2() {
        Segment segment;
        String areaName2 = super.getAreaName2();
        if (areaName2 == null && (segment = this.getSegment()) != null) {
            String right;
            String left = segment.getLeftAreaName2();
            areaName2 = left != null ? left : (right = segment.getRightAreaName2());
        }
        return areaName2;
    }

    public int compareTo(Object o1) {
        return this.compare((Object)this, o1);
    }

    public void scoreAddressNumber(ScoringAddress parsedAddress) {
        String originalHNR = parsedAddress.getAddressNumber();
        String unformattedStreetAddress = (String)parsedAddress.getAdditionalFields().get("unparsed_input_street");
        String inputHouseNumber = (String)parsedAddress.getAdditionalFields().get("input_house_number");
        String originalAddress = this.getFormattedStreetAddress();
        String tempHouseNumber = this.getAddressString(unformattedStreetAddress, originalAddress);
        String string = tempHouseNumber = tempHouseNumber == null ? "" : tempHouseNumber.trim();
        if (StringUtilities.isNumeric((String)tempHouseNumber.trim()) || tempHouseNumber.equalsIgnoreCase(" ")) {
            if (inputHouseNumber != null) {
                parsedAddress.setAddressNumber(inputHouseNumber);
            } else {
                parsedAddress.setAddressNumber(tempHouseNumber);
            }
        }
        this.localscoreAddressNumber(parsedAddress);
        if (this.getAddressNumberScore() != 1.0) {
            parsedAddress.setAddressNumber(originalHNR);
        }
        if (DEU_AddressUtils.isAlphaNumeric(parsedAddress.getAddressNumber())) {
            this.chkInputAddressSuffix = 1;
        }
    }

    public String getAddressString(String unformattedStreetAddress, String originalAddress) {
        if (unformattedStreetAddress != null && originalAddress != null) {
            unformattedStreetAddress = unformattedStreetAddress.replaceAll(",", " ");
            unformattedStreetAddress = unformattedStreetAddress.replaceAll("/", " ");
            unformattedStreetAddress = unformattedStreetAddress.replaceAll(";", " ");
            int unformattedStreetAddressLen = (unformattedStreetAddress = this.removeSpaces(unformattedStreetAddress)).toLowerCase().indexOf(originalAddress.toLowerCase());
            if (unformattedStreetAddressLen != -1) {
                unformattedStreetAddress = unformattedStreetAddress.toLowerCase().replaceAll(originalAddress.toLowerCase(), " ");
            }
        }
        return unformattedStreetAddress;
    }

    public String removeSpaces(String str) {
        StringBuffer strbuf = new StringBuffer();
        String[] strarr = str.split(" ");
        for (int i = 0; i < strarr.length; ++i) {
            if (strarr[i].toString().equals("")) continue;
            strbuf.append(" " + strarr[i]);
        }
        return strbuf.toString().trim();
    }

    public boolean isAPCandidate() {
        return ((DEU_StreetCandidateAddress)this.getStreetCandidateAddress()).isAPCandidate();
    }

    public void localscoreAddressNumber(ScoringAddress address) {
        int secondMatchedRange = -1;
        int secondClosestMatchedRange = -1;
        int secondClosestSegmentSide = -1;
        int secondSegmentSide = -1;
        boolean hasSecondClosestRange = false;
        ParsedNumber secondNumber = null;
        String addressNumber = address.getAddressNumber();
        if (addressNumber == null) {
            addressNumber = " ";
        }
        String firstAddressNumber = addressNumber;
        String secondAddressNumber = null;
        if (addressNumber != null) {
            StringTokenizer st = new StringTokenizer(addressNumber, " -/");
            if (st.countTokens() > 1) {
                firstAddressNumber = st.nextToken();
                ParsedNumber parsedNumber = new ParsedNumber(firstAddressNumber);
                if (parsedNumber.getAddressNumberExists()) {
                    firstAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                }
                while (st.hasMoreTokens() && (secondAddressNumber = st.nextToken()) != null) {
                    parsedNumber = new ParsedNumber(secondAddressNumber.toLowerCase());
                    if (parsedNumber.getAddressNumberExists()) {
                        secondAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                        break;
                    }
                    secondAddressNumber = null;
                }
            }
            if (secondAddressNumber != null) {
                address.setAddressNumber(secondAddressNumber);
                super.scoreAddressNumber(address);
                this.m_numAddrNumberFields = super.getInputNumber().getNumFields();
                this.m_numAddrNumberFieldsMatched = this.getCntAddressNumberFieldsMatched();
                if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                    this.m_matchType = MATCH_SECOND;
                    secondMatchedRange = this.getMatchedRangeNumber();
                    secondSegmentSide = this.getSegmentSide();
                    secondNumber = this.getInputNumber();
                    this.setCntAddressNumberFieldsMatched(0);
                } else if (this.getClosestSegmentSide() >= 0 && this.getClosestRangeNumber() >= 0) {
                    hasSecondClosestRange = true;
                    secondClosestMatchedRange = this.getClosestRangeNumber();
                    secondClosestSegmentSide = this.getClosestSegmentSide();
                    secondNumber = this.getInputNumber();
                }
                this.setInputNumber(null);
                this.setMatchedRangeNumber(-1);
                this.setSegmentSide(-1);
                this.setClosestRange(-1);
                super.setClosestSegmentSide(-1);
                this.setMatchingFlag(0);
            }
        }
        ParsedNumber tempAddressNumber = DEU_AddressUtils.prepareParsedHnrfromString(addressNumber);
        if (this.isAPCandidate() && tempAddressNumber != null) {
            address.setAddressNumber(tempAddressNumber);
        } else {
            address.setAddressNumber(firstAddressNumber.toLowerCase());
        }
        super.scoreAddressNumber(address);
        if (this.getInputNumber() != null) {
            this.m_numAddrNumberFields += super.getInputNumber().getNumFields();
            this.m_numAddrNumberFieldsMatched += this.getCntAddressNumberFieldsMatched();
            if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                if (this.m_matchType == MATCH_SECOND) {
                    if (secondMatchedRange == this.getMatchedRangeNumber() && secondSegmentSide == this.getSegmentSide()) {
                        this.m_matchType = MATCH_BOTH;
                    } else {
                        this.m_matchType = MATCH_BOTH_DIFFERENT;
                        ++this.m_numAddrNumberFields;
                    }
                } else {
                    this.m_matchType = MATCH_FIRST;
                }
            }
            if (this.m_matchType == MATCH_SECOND) {
                this.setInputNumber(secondNumber);
                this.setMatchedRangeNumber(secondMatchedRange);
                this.setSegmentSide(secondSegmentSide);
                Range matchingRange = this.getMatchingOrClosestRange();
                if (matchingRange != null) {
                    matchingRange.setMatchedRangeNumber(secondNumber);
                }
            } else if (this.m_matchType == MATCH_FIRST) {
                if (this.hasMatchingRange() && hasSecondClosestRange) {
                    this.setClosestRange(secondClosestMatchedRange);
                    this.setClosestSegmentSide(secondClosestSegmentSide);
                }
            } else if (this.m_matchType == MATCH_NONE && !this.hasClosestRange() && hasSecondClosestRange) {
                this.setInputNumber(secondNumber);
                this.setClosestRange(secondClosestMatchedRange);
                this.setClosestSegmentSide(secondClosestSegmentSide);
            }
            if (addressNumber.equalsIgnoreCase(" ")) {
                this.setInputNumber(null);
            } else {
                address.setAddressNumber(addressNumber);
            }
        }
    }

    @Override
    public void findClosestRange() {
        this.calculateSegmentOffset(0);
        this.calculateSegmentOffset(1);
    }

    private void calculateSegmentOffset(int side) {
        ParsedNumber parsedNumber = this.getInputNumber();
        if (parsedNumber == null || !parsedNumber.getAddressNumberExists()) {
            return;
        }
        Segment segment = this.getSegment();
        int numRanges = segment.getRangeCount(side);
        List theseRanges = segment.getRanges(side);
        int inputOddEven = parsedNumber.isRangeOddEvenBoth();
        for (int i = 0; i < numRanges; ++i) {
            Range range = (Range)theseRanges.get(i);
            int oddEven = range.getOddEven();
            if (oddEven != 0 && inputOddEven != oddEven && (oddEven != 5 || range.getIntermediateRecordArray() == null || this.getInputNumber() == null || !this.getInputNumber().getAddressNumberExists())) continue;
            long offset = range.computeOffsetFromRange(parsedNumber);
            if (!range.getParsedFrom().equals((Object)range.getParsedTo())) {
                offset *= 2L;
            }
            if (offset >= this.bestOffset) continue;
            this.setClosestRange(i);
            this.setClosestSegmentSide(side);
            this.bestOffset = offset;
        }
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getPostCode1();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getAreaName3()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        boolean isAPCandidate = this.isAPCandidate();
        StringBuffer tempGeoResult = new StringBuffer();
        if (cand.getLocationPrecision() == 16) {
            tempGeoResult.append("S8");
        } else if (cand.getLocationPrecision() == 17) {
            tempGeoResult.append("S7");
        }
        if (!isAPCandidate) {
            if (cand.getLocationPrecision() == 1) {
                tempGeoResult.append("S5");
            } else if (cand.getLocationPrecision() == 2) {
                tempGeoResult.append("S4");
            }
        } else {
            if (cand.getLocationPrecision() == 6) {
                return "SX";
            }
            if (cand.getLocationPrecision() == 3) {
                return "Z1";
            }
            if (cand.getLocationPrecision() == 4) {
                return "Z2";
            }
            if (cand.getLocationPrecision() == 5) {
                return "Z3";
            }
            if (cand.getLocationPrecision() == 8) {
                return "G1";
            }
            if (cand.getLocationPrecision() == 9) {
                return "G2";
            }
            if (cand.getLocationPrecision() == 10) {
                return "G3";
            }
            if (cand.getLocationPrecision() == 11) {
                return "G4";
            }
        }
        if (cand.doesAddressNumberMatch() && (cand.getLocationPrecision() == 1 || cand.getLocationPrecision() == 16)) {
            tempGeoResult.append('H');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPreDirectionalMatch()) {
            tempGeoResult.append('P');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesStreetNameMatch() && cand.doStreetPrefixAndSuffixMatch()) {
            tempGeoResult.append('N');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesThoroughfareTypeMatch()) {
            tempGeoResult.append('T');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPostDirectionalMatch()) {
            tempGeoResult.append('S');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesAreaName3Match()) {
            tempGeoResult.append("C");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPostalCode1Match()) {
            tempGeoResult.append("Z");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.fromUserDictionary()) {
            tempGeoResult.append("U");
        } else {
            tempGeoResult.append("A");
        }
        return tempGeoResult.toString();
    }

    protected DirectPosition getAddressNumberHousePoint() {
        DirectPosition addresNumberPoint = super.getAddressNumberHousePoint();
        if (addresNumberPoint == null && this.isAPCandidate()) {
            Segment segment = this.getSegment();
            addresNumberPoint = segment.getHousePoint(segment.getRangeAt(0, 0).getRangeNumber());
        }
        return addresNumberPoint;
    }

    @Override
    public void setGeocodedPoint(CandidateAddress candidate, int debugLevel, IConstraints constraints, ResourceBundle errorBundle) {
        Segment segment = this.getSegment();
        int segmentPointCount = segment.getSegmentPointCount();
        if (segment.isHouseSegment()) {
            DirectPosition housePoint = this.getAddressNumberHousePoint();
            if (housePoint != null) {
                candidate.setLocation(housePoint);
                candidate.setLocationPrecision(16);
            }
        } else if (this.isPointHouseCandidate(constraints)) {
            candidate.setLocation(segment.getSegmentPointAt(0));
            if (this.hasMatchingRange() || this.hasClosestRange()) {
                candidate.setLocationPrecision(16);
            } else {
                candidate.setLocationPrecision(2);
            }
        } else if (segmentPointCount == 1) {
            candidate.setLocation(segment.getSegmentPointAt(0));
            candidate.setLocationPrecision(1);
        } else if (segmentPointCount != 0) {
            int rangeNumber;
            int segmentSide = this.getSegmentSide();
            if (segmentSide < 0) {
                segmentSide = this.getClosestSegmentSide();
            }
            if ((rangeNumber = this.getMatchedRangeNumber()) < 0) {
                rangeNumber = this.getClosestRangeNumber();
            }
            if (segmentSide < 0 || rangeNumber < 0) {
                candidate.setLocation(Interpolator.interpolateShapePath((List)segment.getSegmentPoints()));
                if (candidate.getLocation() != null) {
                    candidate.setLocationPrecision(2);
                }
            } else {
                List pointHouseCandidates = this.findAllPointHouseCandidates(constraints);
                if (pointHouseCandidates == null) {
                    double percentage = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getParsedAddressNumber());
                    if (this.getSecondHNRangedAddress() != null) {
                        double percentage2 = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getSecondHNRangedAddress());
                        percentage = (percentage + percentage2) / 2.0;
                    }
                    candidate.setLocation(Interpolator.interpolate((List)segment.getSegmentPoints(), (segmentSide == 0 ? 1 : 0) != 0, (double)percentage, (Length)constraints.getCornerOffsetAsLength(), (Length)constraints.getStreetOffsetAsLength()));
                    if (candidate.getLocation() != null) {
                        candidate.setLocationPrecision(1);
                    }
                } else {
                    DirectPosition exactPointHouse = this.findExactPointHouse(pointHouseCandidates);
                    if (exactPointHouse != null) {
                        candidate.setLocation(exactPointHouse);
                        candidate.setLocationPrecision(16);
                    } else {
                        this.filterPointCandidates(pointHouseCandidates, segmentSide);
                        this.interpolateUsingPointHouses(candidate, pointHouseCandidates, constraints, segmentSide, rangeNumber);
                    }
                }
            }
        } else {
            DirectPosition exactPointHouse;
            List pointCandidates = this.findAllPointHouseCandidates(constraints);
            if (pointCandidates != null && (exactPointHouse = this.findExactPointHouse(pointCandidates)) != null) {
                candidate.setLocation(exactPointHouse);
                candidate.setLocationPrecision(16);
            }
        }
        if (candidate.getLocationPrecision() != 0) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)candidate.getLocationPoint()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        }
    }

    private Range getMatchingOrClosestRange() {
        if (this.hasMatchingRange()) {
            return this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
        }
        if (this.hasClosestRange()) {
            return this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
        }
        return null;
    }

    private Range getOnlyMatchingRange() {
        if (this.hasMatchingRange()) {
            return this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
        }
        return null;
    }

    private void setCountCommonWord(boolean flag) {
        this.m_iscommonWord = flag;
    }

    protected boolean doesCountCommonWord() {
        return this.m_iscommonWord;
    }

    private int chkAlphaNumericAPAddrNumber(DEU_InternalCandidateAddress cand1, DEU_InternalCandidateAddress cand2) {
        int retValue = 0;
        if (cand1.isAPCandidate() && cand2.isAPCandidate()) {
            Range candidateRange1 = cand1.getOnlyMatchingRange();
            Range candidateRange2 = cand2.getOnlyMatchingRange();
            if (candidateRange1 != null && candidateRange2 != null) {
                if (DEU_AddressUtils.isAlphaNumeric(candidateRange1.getParsedFrom().getCombinedAddressNumber()) && !DEU_AddressUtils.isAlphaNumeric(candidateRange2.getParsedFrom().getCombinedAddressNumber())) {
                    retValue = cand1.chkInputAddressSuffix == 1 ? 1 : -1;
                } else if (!DEU_AddressUtils.isAlphaNumeric(candidateRange1.getParsedFrom().getCombinedAddressNumber()) && DEU_AddressUtils.isAlphaNumeric(candidateRange2.getParsedFrom().getCombinedAddressNumber())) {
                    retValue = cand1.chkInputAddressSuffix == 1 ? -1 : 1;
                }
            }
        }
        return retValue;
    }

    @Override
    public long getAdjustedOffset() {
        Range range = this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
        long offset = range.getRangeOffset();
        if (!range.getParsedFrom().equals((Object)range.getParsedTo()) && range.getOddEven() != 0) {
            offset *= 2L;
        }
        return offset;
    }

    static {
        PRE_THOROUGHFARE_PREFERRED_NAME = new String("PRE_NAME");
        POST_THOROUGHFARE_PREFERRED_NAME = new String("POST_NAME");
        plainScorer = new StringScorer(false, new Locale("de", "DE"));
    }

    private class DEU_RangeComparator
    implements Comparator<Range> {
        private ParsedNumber m_InputNumber;

        public DEU_RangeComparator(ParsedNumber inputnumber) {
            this.m_InputNumber = inputnumber;
        }

        @Override
        public int compare(Range range1, Range range2) {
            int value = 0;
            if (DEU_AddressUtils.computeOffsetDifference(this.m_InputNumber, range1) < DEU_AddressUtils.computeOffsetDifference(this.m_InputNumber, range2)) {
                value = -1;
            } else if (DEU_AddressUtils.computeOffsetDifference(this.m_InputNumber, range2) < DEU_AddressUtils.computeOffsetDifference(this.m_InputNumber, range1)) {
                value = 1;
            } else if (DEU_AddressUtils.computeOffsetDifference(this.m_InputNumber, range2) == DEU_AddressUtils.computeOffsetDifference(this.m_InputNumber, range1)) {
                String inputNumber = this.m_InputNumber.getCombinedAddressNumber();
                String range1number = range1.getParsedFrom().getCombinedAddressNumber();
                String range2number = range2.getParsedFrom().getCombinedAddressNumber();
                if (inputNumber != null) {
                    if (inputNumber.compareTo(range1number) < inputNumber.compareTo(range2number)) {
                        value = 1;
                    } else if (inputNumber.compareTo(range1number) > inputNumber.compareTo(range2number)) {
                        value = -1;
                    }
                }
            }
            return value;
        }
    }
}

