/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.StringTokenizer;

public class DEU_InternalGeographicCandidate
extends EMEA_InternalGeographicCandidate {
    private int m_code;
    private boolean m_isAccentedAdavantagetoCandidate;
    private boolean m_isAPCandidate;

    public DEU_InternalGeographicCandidate() {
        StringBuffer buf = new StringBuffer();
        buf.append("& a ; \u00e4 , ae ");
        buf.append("& e ; \u00eb ");
        buf.append("& o ; \u00f6 , oe ");
        buf.append("& u ; \u00fc , ue ");
        this.setStringScorer(new StringScorer(true, new Locale("de", "DE"), buf.toString().toUpperCase()));
    }

    public DEU_InternalGeographicCandidate(boolean isAPCandidate) {
        this();
        this.m_isAPCandidate = isAPCandidate;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public int getCode() {
        return this.m_code;
    }

    public boolean isAccentedAdvantage() {
        return this.m_isAccentedAdavantagetoCandidate;
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(inputAddress, constraints);
        int intCode = this.getCode();
        if (intCode > 0) {
            StringBuffer temp = new StringBuffer(8);
            temp.append(intCode);
            if (temp.length() < 8) {
                temp.insert(0, '0');
            }
            candidate.setGenericField4(temp.toString());
        }
        String areaName3 = this.getAreaName3();
        String areaName4 = this.getAreaName4();
        if (areaName4 != null && this.getPrecision() == 11) {
            candidate.setAreaName3(areaName3);
            candidate.setAreaName4(areaName4);
        } else {
            candidate.setAreaName3(areaName3);
            candidate.setAreaName4(null);
        }
        return candidate;
    }

    public boolean isAPCandidate() {
        return this.m_isAPCandidate;
    }

    public String toString() {
        return "\nDEU_InternalGeographicCandidate:" + super.toString();
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        String areaname3;
        double score;
        String altArea;
        StringTokenizer st;
        String altAreaName;
        StringScorer scorer = this.getStringScorer();
        String pAreaName3 = inputAddress.getAreaName3();
        String cAreaName3 = this.getAreaName3();
        String pAreaName4 = inputAddress.getAreaName4() == null ? null : inputAddress.getAreaName4().toUpperCase();
        String cAreaName4 = this.getAreaName4() == null ? null : this.getAreaName4().toUpperCase();
        double highScore = 0.0;
        if (cAreaName3 != null) {
            cAreaName3 = cAreaName3.toUpperCase();
        }
        if (pAreaName3 != null) {
            highScore = scorer.scoreString(pAreaName3.toUpperCase(), cAreaName3, charsToIgnore);
            if (highScore != 1.0 && (altAreaName = this.getGeoInfoRecord().getAltAreaName3()) != null) {
                st = new StringTokenizer(altAreaName, "/");
                while (st.hasMoreTokens()) {
                    altArea = st.nextToken();
                    score = scorer.scoreString(pAreaName3, altArea, charsToIgnore);
                    highScore = score > highScore ? score : highScore;
                    if (highScore != 1.0) continue;
                    if (DEU_AddressUtils.doesAccentedStringMatched(pAreaName3, altArea)) break;
                    highScore = 0.999;
                    break;
                }
            }
            this.setAreaName3Score(highScore);
        }
        if (this.getAreaName3Score() != 1.0) {
            String pTestAgainst;
            double newHighScore = 0.0;
            String string = pAreaName3 != null ? pAreaName3 : (pTestAgainst = pAreaName4 != null ? pAreaName4 : null);
            if (pTestAgainst != null && StringUtilities.hasNumeric((String)pTestAgainst)) {
                StringBuffer newTestAgainst = new StringBuffer(pTestAgainst.length());
                for (int i = 0; i < pTestAgainst.length(); ++i) {
                    if (StringUtilities.isNumeric((String)pTestAgainst.substring(i, i + 1))) {
                        newTestAgainst.append(" ");
                        continue;
                    }
                    newTestAgainst.append(pAreaName3.charAt(i));
                }
                newHighScore = scorer.scoreString(cAreaName3, newTestAgainst.toString(), charsToIgnore);
            }
            if (newHighScore > this.getAreaName3Score()) {
                if (pAreaName3 != null) {
                    this.setAreaName3Score(newHighScore);
                } else if (pAreaName4 != null) {
                    this.setAreaName4Score(newHighScore);
                }
            }
        }
        highScore = 0.0;
        if (pAreaName4 != null) {
            highScore = scorer.scoreString(pAreaName4, cAreaName4, charsToIgnore);
            if (highScore != 1.0 && (altAreaName = this.getGeoInfoRecord().getAltAreaName4()) != null) {
                st = new StringTokenizer(altAreaName, "/");
                while (st.hasMoreTokens() && (highScore = (score = scorer.scoreString(pAreaName4, altArea = st.nextToken(), charsToIgnore)) > highScore ? score : highScore) != 1.0) {
                }
            }
        } else if (this.getAreaName3Score() != 1.0) {
            highScore = scorer.scoreString(pAreaName3.toUpperCase(), cAreaName4.toUpperCase(), charsToIgnore);
            if (highScore != 1.0 && (altAreaName = this.getGeoInfoRecord().getAltAreaName4()) != null) {
                st = new StringTokenizer(altAreaName, "/");
                while (st.hasMoreTokens() && (highScore = (score = scorer.scoreString(pAreaName3, altArea = st.nextToken(), charsToIgnore)) > highScore ? score : highScore) != 1.0) {
                }
            }
            if (this.getAreaName3Score() <= highScore) {
                if (highScore < 1.0) {
                    this.setAreaName3Score(highScore * 0.9);
                } else {
                    this.setAreaName3Score(highScore);
                }
                highScore = 0.0;
            }
        }
        this.setAreaName4Score(highScore);
        if (this.getAreaName3Score() < 0.81) {
            if (DEU_AddressTerm.areOnlyVowelsDifferent(pAreaName3, cAreaName3)) {
                this.setAreaName3Score(0.81);
            } else if (DEU_AddressTerm.areOnlyVowelsDifferent(pAreaName3, cAreaName4)) {
                this.setAreaName3Score(0.81);
            }
        }
        if (this.getAreaName3Score() == 1.0 && !(areaname3 = pAreaName3.toUpperCase()).equals(cAreaName3) && !areaname3.equals(cAreaName4)) {
            this.m_isAccentedAdavantagetoCandidate = true;
        }
        highScore = 0.0;
        highScore = scorer.scoreString(inputAddress.getAreaName1(), this.getAreaName1(), charsToIgnore);
        this.setAreaName1Score(highScore);
        highScore = 0.0;
        highScore = scorer.scoreString(inputAddress.getAreaName2(), this.getAreaName2(), charsToIgnore);
        this.setAreaName2Score(highScore);
        this.setCountryScore(1.0);
    }

    public int compare(Object o1, Object o2) {
        DEU_InternalGeographicCandidate candidate1 = (DEU_InternalGeographicCandidate)((Object)o1);
        DEU_InternalGeographicCandidate candidate2 = (DEU_InternalGeographicCandidate)((Object)o2);
        if (candidate1.isCloseMatch() ^ candidate2.isCloseMatch()) {
            if (candidate1.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (candidate1.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (candidate1.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (candidate1.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (candidate1.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (candidate1.getAreaName2Score() > candidate2.getAreaName2Score()) {
            return 1;
        }
        if (candidate1.getAreaName2Score() < candidate2.getAreaName2Score()) {
            return -1;
        }
        if (candidate1.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (candidate1.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (candidate1.getAreaName4Score() > candidate2.getAreaName4Score()) {
            return 1;
        }
        if (candidate1.getAreaName4Score() < candidate2.getAreaName4Score()) {
            return -1;
        }
        if (candidate1.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (candidate2.getCountryScore() > candidate1.getCountryScore()) {
            return -1;
        }
        if (candidate1.getPrecision() == 10 && candidate2.getPrecision() != 10) {
            return 1;
        }
        if (candidate1.getPrecision() != 10 && candidate2.getPrecision() == 10) {
            return -1;
        }
        if (candidate1.getPrecision() > candidate2.getPrecision()) {
            if (candidate1.getPrecision() != 11 || candidate1.getAreaName4Score() != 0.0) {
                return 1;
            }
            return -1;
        }
        if (candidate1.getPrecision() < candidate2.getPrecision()) {
            if (candidate2.getPrecision() != 11 || candidate2.getAreaName4Score() != 0.0) {
                return -1;
            }
            return 1;
        }
        if (!candidate1.isAccentedAdvantage() && candidate2.isAccentedAdvantage()) {
            return 1;
        }
        if (candidate1.isAccentedAdvantage() && !candidate2.isAccentedAdvantage()) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object o1) {
        return this.compare((Object)this, o1);
    }
}

