/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_StreetCandidateAddress;
import com.mapinfo.mapmarker.DEU.parser.DEU_Abbreviations;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DEU_ScoringAddress
extends EMEA_ScoringAddress {
    public DEU_ScoringAddress(Address addr) {
        super(addr);
    }

    public double scorePostAddress(StreetCandidateAddress parsedAddress) {
        String candPostAddr;
        String parsedPostAddr = this.getPostAddress();
        double score = this.scoreItems(parsedPostAddr, candPostAddr = parsedAddress.getPostAddress());
        if (score != 1.0 && (DEU_AddressTerm.isDirectional(parsedPostAddr) || DEU_AddressTerm.isDirectional(candPostAddr))) {
            parsedAddress.setPostDirectionalScore(score);
            return 0.5;
        }
        if (parsedPostAddr != null && this.getPostThoroughfareType() == null && parsedAddress.getPostThoroughfareType() != null) {
            score = this.scoreItems(parsedPostAddr, parsedAddress.getPostThoroughfareType());
            if (score > 0.75) {
                return score;
            }
        } else {
            if (DEU_AddressTerm.isIgnoreWord(parsedAddress.getPostAddress()) && this.getPostAddress() == null) {
                score = 0.75;
            }
            if (StringUtilities.isNumeric((String)parsedPostAddr) && candPostAddr == null) {
                parsedPostAddr = null;
                score = this.scoreItems(parsedPostAddr, candPostAddr);
            } else {
                score = this.scoreItems(parsedPostAddr, candPostAddr);
            }
        }
        return score;
    }

    public double scorePreAddress(Address candiate) {
        double score;
        String parsedPreAddr = this.getPreAddress() == null ? null : this.getPreAddress().toUpperCase();
        String candPreAddr = candiate.getPreAddress() == null ? null : candiate.getPreAddress().toUpperCase();
        double highScore = this.scoreItems(candPreAddr, parsedPreAddr);
        DEU_AddressTerm.isromanWord(this.getPreAddress() == null ? null : this.getPreAddress());
        if (highScore != 1.0 && parsedPreAddr != null && candPreAddr != null) {
            String candAbbrPreAddr;
            String parsedAbbrPreAddr = DEU_Abbreviations.abbreviateWords(parsedPreAddr);
            score = this.scoreItems(parsedAbbrPreAddr, candAbbrPreAddr = DEU_Abbreviations.abbreviateWords(candPreAddr));
            if (score != 1.0) {
                String[] p = DEU_ScoringAddress.splitWordsIntoArray(parsedPreAddr);
                String[] c = DEU_ScoringAddress.splitWordsIntoArray(candPreAddr);
                if (p != null && c != null) {
                    int count = p.length < c.length ? p.length : c.length;
                    boolean abbrivated = false;
                    for (int i = 0; i < count; ++i) {
                        if (p[i].length() >= c[i].length()) continue;
                        if (c[i].startsWith(p[i])) {
                            abbrivated = true;
                            continue;
                        }
                        if (!p[i].startsWith(c[i])) continue;
                        abbrivated = true;
                        p[i] = c[i];
                    }
                    if (abbrivated) {
                        int i;
                        StringBuffer parsedBuf = new StringBuffer();
                        StringBuffer candBuf = new StringBuffer();
                        for (i = 0; i < p.length; ++i) {
                            parsedBuf.append(p[i]);
                            parsedBuf.append(' ');
                        }
                        for (i = 0; i < c.length; ++i) {
                            candBuf.append(c[i]);
                            candBuf.append(' ');
                        }
                        score = this.scoreItems(parsedBuf.toString().trim(), candBuf.toString().trim());
                        if (score > highScore) {
                            highScore = score;
                        }
                    }
                }
            } else if (score > highScore) {
                highScore = score;
            }
            parsedPreAddr = parsedAbbrPreAddr;
            candPreAddr = candAbbrPreAddr;
        }
        if (highScore != 1.0) {
            String str1 = candiate.getPreAddress() == null ? null : candiate.getPreAddress().toUpperCase();
            String str2 = this.getPreAddress();
            if (str1 != null && str1.trim().length() > 0 && str2 != null && str2.trim().length() > 0) {
                boolean romanTermExistInStr1 = false;
                boolean romanTermExistInStr2 = false;
                StringTokenizer st1 = new StringTokenizer(str1, this.getCharsToIgnore(), false);
                String temp = null;
                String inputNumber = null;
                String candidateNumber = null;
                while (!romanTermExistInStr1 && st1.hasMoreTokens()) {
                    temp = st1.nextToken();
                    if (StringUtilities.isNumeric((String)temp)) {
                        romanTermExistInStr1 = true;
                        inputNumber = temp.toString();
                        continue;
                    }
                    if (!DEU_AddressTerm.isRomanNumber(temp)) continue;
                    romanTermExistInStr1 = true;
                    inputNumber = String.valueOf(DEU_AddressTerm.convertRomanToLong(temp));
                }
                temp = null;
                StringTokenizer st2 = new StringTokenizer(str2, this.getCharsToIgnore(), false);
                while (!romanTermExistInStr2 && st2.hasMoreTokens()) {
                    temp = st2.nextToken();
                    if (StringUtilities.isNumeric((String)temp)) {
                        romanTermExistInStr2 = true;
                        candidateNumber = temp.toString();
                    }
                    if (!DEU_AddressTerm.isRomanNumber(temp)) continue;
                    romanTermExistInStr2 = true;
                    candidateNumber = String.valueOf(DEU_AddressTerm.convertRomanToLong(temp));
                }
                if (romanTermExistInStr2 && romanTermExistInStr1) {
                    score = this.scoreItems(inputNumber, candidateNumber);
                    if (score > highScore) {
                        highScore = score;
                    }
                    if (highScore > 1.0) {
                        highScore = 1.0;
                    }
                }
            }
        }
        if (highScore != 1.0) {
            String[] parsedRetValue = DEU_AddressTerm.removeCommonWords(parsedPreAddr);
            String[] candRetValue = DEU_AddressTerm.removeCommonWords(candPreAddr);
            if (parsedRetValue != null && candRetValue != null) {
                double otherWordsScore;
                if (!(parsedRetValue[0] == null && candRetValue[0] == null || parsedRetValue[1] == null && candRetValue[1] == null)) {
                    double otherWordsScore2 = this.scoreItems(parsedRetValue[0], candRetValue[0]);
                    double commonWordsScore = this.scoreItems(parsedRetValue[1], candRetValue[1]);
                    if (otherWordsScore2 != 0.0 && commonWordsScore != 0.0) {
                        highScore = otherWordsScore2 * 0.75 + commonWordsScore * 0.25;
                    }
                }
                if (parsedRetValue[0] != null && candRetValue[0] != null) {
                    double otherWordsScore3 = this.scoreItems(parsedRetValue[0], candRetValue[0]);
                    if (highScore < otherWordsScore3) {
                        highScore = otherWordsScore3;
                    }
                } else if (highScore != 1.0 && parsedRetValue[1] != null && candRetValue[1] != null && highScore < (otherWordsScore = this.scoreItems(parsedRetValue[1], candRetValue[1]))) {
                    highScore = otherWordsScore;
                    highScore -= 0.01;
                }
            } else if (parsedRetValue != null && parsedRetValue[0] == null) {
                String candidateCommonWord = (String)candiate.getAdditionalFields().get("input_street_commonterm");
                if (!StringUtilities.isEmpty((String)candidateCommonWord) && parsedRetValue[1] != null) {
                    boolean isPAAbbr = DEU_Abbreviations.isAbbreviation(parsedRetValue[1]);
                    boolean isCAAbbr = DEU_Abbreviations.hasAbbreviation(candidateCommonWord);
                    if (isCAAbbr && isPAAbbr) {
                        String CAAbbreviation = DEU_Abbreviations.getAbbreviation(candidateCommonWord);
                        double otherWordsScore = this.scoreItems(parsedRetValue[1], CAAbbreviation);
                        if (otherWordsScore == 1.0) {
                            // empty if block
                        }
                        if (highScore < otherWordsScore) {
                            highScore = otherWordsScore;
                            return highScore;
                        }
                    }
                }
                highScore = 0.73;
            } else if (parsedRetValue != null) {
                String parsedCommanWord;
                if (candiate.hasAdditionalFields() && (parsedCommanWord = (String)candiate.getAdditionalFields().get("input_street_commonterm")) != null && parsedPreAddr != null) {
                    if (DEU_AddressTerm.doesRomanWordExist(this.getPreAddress() == null ? null : this.getPreAddress())) {
                        return 0.8;
                    }
                    score = this.scoreItems(parsedPreAddr, parsedCommanWord);
                    if (score > 0.5) {
                        return score -= 0.2;
                    }
                }
                highScore = 0.267;
            }
        }
        return highScore;
    }

    public double scorePostThoroughfareType(String str) {
        return this.DEUScoreThoroughfareType(this.getPostThoroughfareType(), str);
    }

    public double scorePreThoroughfareType(String str) {
        return this.DEUScoreThoroughfareType(this.getPreThoroughfareType(), str);
    }

    private double DEUScoreThoroughfareType(String s1, String s2) {
        double score = this.scoreStrings(s1, s2);
        if (score != 1.0) {
            double tempscore;
            String prefferedParsedTypeName = DEU_ThoroughfareTypes.getPreferredTypeName(s1);
            String prefferedCandTypeName = DEU_ThoroughfareTypes.getPreferredTypeName(s2);
            if (!(s1 == null || s2 == null || s1.equalsIgnoreCase(prefferedParsedTypeName) && s2.equalsIgnoreCase(prefferedCandTypeName) || !((tempscore = this.scoreStrings(prefferedParsedTypeName = prefferedParsedTypeName != null ? prefferedParsedTypeName : s1, prefferedCandTypeName = prefferedCandTypeName != null ? prefferedCandTypeName : s2)) > score))) {
                score = tempscore;
            }
        }
        if (score != 1.0 && score > 0.0 && s1.charAt(0) != s2.charAt(0)) {
            score = 0.75 * score;
        }
        return score;
    }

    private static String[] splitWordsIntoArray(String words) {
        if (words == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(words, " .-,");
        int n = st.countTokens();
        if (n > 0) {
            String[] strArray = new String[n];
            for (int i = 0; i < n; ++i) {
                strArray[i] = st.nextToken();
            }
            return strArray;
        }
        return null;
    }

    public double scoreMainAddress(String parsedAddress, Address candiate) {
        double highScore;
        String parsedMainAddr = this.getMainAddress();
        String candMainAddr = parsedAddress;
        double score = 0.0;
        if (StringUtilities.isEmpty((String)parsedMainAddr) || StringUtilities.isEmpty((String)candMainAddr)) {
            return score;
        }
        if (parsedMainAddr != null && parsedMainAddr.length() != 0) {
            parsedMainAddr = parsedMainAddr.toUpperCase();
        }
        if (candMainAddr != null && candMainAddr.length() != 0) {
            candMainAddr = candMainAddr.toUpperCase();
        }
        if ((highScore = this.scoreItems(candMainAddr, parsedMainAddr)) != 1.0 && parsedMainAddr != null && candMainAddr != null) {
            if (parsedMainAddr.length() == 1) {
                if (DEU_Abbreviations.isAbbreviation(parsedMainAddr)) {
                    double tempScore = 0.0;
                    ArrayList words = new ArrayList();
                    words = DEU_Abbreviations.getWordsForAbbreviation(parsedMainAddr);
                    for (int i = 0; i < words.size(); ++i) {
                        tempScore = this.scoreItems((String)words.get(i), candMainAddr);
                        if (!(tempScore > score)) continue;
                        score = tempScore;
                    }
                }
            } else {
                String parsedAbbrMainAddr = DEU_Abbreviations.abbreviateWords(parsedMainAddr);
                String candAbbrMainAddr = DEU_Abbreviations.abbreviateWords(candMainAddr);
                if (parsedAbbrMainAddr.length() > 1 && candAbbrMainAddr.length() > 1) {
                    score = this.scoreItems(parsedAbbrMainAddr, candAbbrMainAddr);
                }
            }
            if (score > highScore) {
                highScore = score;
            }
        }
        if (highScore != 1.0 && this.isMainAddressEndingNumeric(parsedMainAddr)) {
            parsedMainAddr = parsedMainAddr.substring(0, parsedMainAddr.length() - 1);
            highScore = this.scoreItems(candMainAddr, parsedMainAddr);
            ((DEU_StreetCandidateAddress)candiate).setCandidateHacked();
        }
        if (highScore != 1.0 && highScore > 0.72 && highScore < 0.85) {
            highScore = 0.85;
        }
        return highScore;
    }

    private boolean isMainAddressEndingNumeric(String mainaddress) {
        boolean isEnding = false;
        String[] strArray = mainaddress.split(" ");
        if (strArray.length > 1 && StringUtilities.isNumeric((String)strArray[1]) && strArray[1].length() == 1) {
            isEnding = true;
        }
        return isEnding;
    }
}

