/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_InternalCandidateAddress;
import com.mapinfo.mapmarker.DEU.DEU_ScoringAddress;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;

public class DEU_StreetCandidateAddress
extends StreetCandidateAddress {
    public static final String ADDRESS_START = "address.start";
    public static final String ADDRESS_END = "address.end";
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String IS_MAJOR_ROAD = "is.major.road";
    public static final double THOROUGHFARE_TYPE_THRESHOLD = 0.9;
    private boolean m_APCandidate;
    private boolean m_isCandidateHacked;

    public DEU_StreetCandidateAddress(boolean isAPCandidate) {
        this.m_APCandidate = isAPCandidate;
    }

    public DEU_StreetCandidateAddress(Address addr) {
        super(addr);
    }

    public void score(ScoringAddress input) {
        DEU_ScoringAddress scoringAddress = (DEU_ScoringAddress)input;
        this.setCountryScore(scoringAddress.scoreCountry(this.getCountry()));
        this.setGenericField1Score(scoringAddress.scoreGenericField1(this.getGenericField1()));
        this.setGenericField2Score(scoringAddress.scoreGenericField2(this.getGenericField2()));
        this.setGenericField3Score(scoringAddress.scoreGenericField3(this.getGenericField3()));
        this.setGenericField4Score(scoringAddress.scoreGenericField4(this.getGenericField4()));
        this.setPreDirectionalScore(scoringAddress.scorePreDirectional(this.getPreDirectional()));
        this.setPostDirectionalScore(scoringAddress.scorePostDirectional(this.getPostDirectional()));
        this.setPreThoroughfareTypeScore(scoringAddress.scorePreThoroughfareType(this.getPreThoroughfareType()));
        this.setPostThoroughfareTypeScore(scoringAddress.scorePostThoroughfareType(this.getPostThoroughfareType()));
        this.setPreAddressScore(scoringAddress.scorePreAddress((Address)this));
        this.setMainAddressScore(scoringAddress.scoreMainAddress(this.getMainAddress(), (Address)this));
        this.setPostAddressScore(scoringAddress.scorePostAddress(this));
        this.setIsScored(true);
    }

    public void scorePreAddress(EMEA_ScoringAddress input) {
        double preAddressScore = 0.0;
        String parsedPreAddress = input.getPreAddress();
        String candPreAddress = this.getPreAddress();
        if (parsedPreAddress != null && parsedPreAddress.length() == 0 || candPreAddress != null && candPreAddress.length() == 0) {
            preAddressScore = 0.8;
        } else if (DEU_AddressTerm.isDirectional(parsedPreAddress) || DEU_AddressTerm.isDirectional(candPreAddress)) {
            preAddressScore = input.scoreItems(parsedPreAddress, candPreAddress);
            this.setPreDirectionalScore(preAddressScore);
            preAddressScore = parsedPreAddress == null || candPreAddress == null ? 0.0 : 1.0;
        } else {
            String candidatePreAddressFull;
            String parsedPreAddressFull;
            double score;
            preAddressScore = input.scorePreAddress(candPreAddress);
            if (preAddressScore != 1.0 && (score = input.scoreStrings(parsedPreAddressFull = DEU_InternalCandidateAddress.getFormattedPreAddress((Address)input), candidatePreAddressFull = DEU_InternalCandidateAddress.getFormattedPreAddress((Address)this))) > preAddressScore && score > 0.9) {
                preAddressScore = score;
            }
        }
        this.setPreAddressScore(preAddressScore);
    }

    public boolean isAPCandidate() {
        return this.m_APCandidate;
    }

    public boolean isCandidateHacked() {
        return this.m_isCandidateHacked;
    }

    public void setCandidateHacked() {
        this.m_isCandidateHacked = true;
    }
}

