/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_DataDictionary;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_DataManager;
import com.mapinfo.mapmarker.EMEA.EMEA_StreetGeocoder;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.DictionarySearchOrder;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;

public class DEU_StreetGeocoder
extends EMEA_StreetGeocoder {
    public DEU_StreetGeocoder(IHandler handler) {
        super(handler);
        ((ICoreStreetGeocoder)handler).setStreetSingleAddressGeocoder((IStreetSingleAddressGeocoder)new DEU_StreetSingleAddressGeocoder(handler));
    }

    @Override
    public IRetrievedCandidates getStreetCandidates(Address inputAddress, ScoringAddress scoringAddress, IConstraints constraints, int debugLevel) throws MapMarkerInternalException, MMInternalFatalException {
        return this.getStreetGeocoder().getStreetCandidates(inputAddress, scoringAddress, constraints, debugLevel);
    }

    @Override
    public void geocodeIntersection(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        DEU_DataManager dataManager = (DEU_DataManager)constraints.getHandler().getDataManager();
        IDictionarySearchOrder originalOrder = constraints.getDictionarySearchOrder();
        boolean bSearchOrderModified = false;
        if (dataManager.hasAPDictionary()) {
            IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
            if (order == null) {
                bSearchOrderModified = true;
                int count = dataManager.getDictionaryCount();
                DictionarySearchOrder newSearchOrder = new DictionarySearchOrder(count);
                for (int index = 0; index < count; ++index) {
                    DEU_DataDictionary dataDict = (DEU_DataDictionary)dataManager.getDictionary(index);
                    newSearchOrder.addDictionary(index + 1, !dataDict.isAPDictionary(), null, index + 1, dataDict.isUserDictionary());
                }
                constraints.setDictionarySearchOrder((IDictionarySearchOrder)newSearchOrder);
            } else {
                DictionarySearchOrder newSearchOrder = new DictionarySearchOrder(order);
                for (int index = 0; index < newSearchOrder.getDictionaryCount(); ++index) {
                    DEU_DataDictionary dataDict = (DEU_DataDictionary)dataManager.getDictionary(index);
                    if (!dataDict.isAPDictionary()) continue;
                    newSearchOrder.setDictionaryAvailableForSearch(index + 1, false);
                }
                constraints.setDictionarySearchOrder((IDictionarySearchOrder)newSearchOrder);
            }
        }
        boolean bContinue = false;
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        if (order == null) {
            bContinue = true;
        } else {
            for (int index = 0; index < order.getDictionaryCount(); ++index) {
                if (!order.isDictionaryAvailableForSearch(index + 1)) continue;
                bContinue = true;
                break;
            }
        }
        if (!bContinue) {
            geocodeResult.setIntersectionStatus(true);
            geocodeResult.setDataLicensed(true);
            IHandler handler = constraints.getHandler();
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(null);
            if (bSearchOrderModified) {
                constraints.setDictionarySearchOrder(originalOrder);
            }
            return;
        }
        String firstAddressNumber = this.stripInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getFirstParsedAddress());
        String secondAddressNumber = this.stripInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getSecondParsedAddress());
        this.getStreetGeocoder().geocodeIntersection(constraints, debugLevel, geocodeResult);
        this.replaceInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getFirstParsedAddress(), firstAddressNumber);
        this.replaceInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getSecondParsedAddress(), secondAddressNumber);
        if (bSearchOrderModified) {
            constraints.setDictionarySearchOrder(originalOrder);
        }
    }

    private void replaceInputHouseNumbers(Address address, String addressNumber) {
        address.setAddressNumber(addressNumber);
    }

    private String stripInputHouseNumbers(Address input) {
        String result = input.getAddressNumber();
        input.setAddressNumber("");
        return result;
    }
}

