/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseHelper;
import com.mapinfo.mapmarker.utils.ISO3166;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class GeocoderFactory {
    private static Map m_store = null;
    private static final String GEOCODERPROPERTIES_SUFFIX = "_Geocoder.properties";
    private static final String KEY_PRPERTIES = "_KEYS_LIST";
    private static final String HANDLERKEY = "_HANDLER_KEY";
    private static final String GEOCODERKEY = "_GEOCODER_KEY";
    private static Properties m_prop;
    private static Map m_keyMap;

    private GeocoderFactory() {
    }

    public static IGeocoder getGeocoder(Address address) {
        return (IGeocoder)m_store.get(address.getCountry());
    }

    private static IGeocoder createGeocoder(String countryCode) {
        IHandler handler = GeocoderFactory.createHandler(countryCode);
        IGeocoder geocoder = GeocoderFactory.setHandlerToGeocoder((String)m_prop.get(GEOCODERKEY), handler);
        return geocoder;
    }

    private static IHandler createHandler(String countryCode) {
        IHandler genricHandler = null;
        m_prop = GeocoderFactory.readPropFile(countryCode + GEOCODERPROPERTIES_SUFFIX);
        if (m_keyMap == null) {
            GeocoderFactory.fillMap(m_prop.get(KEY_PRPERTIES).toString());
        }
        genricHandler = (IHandler)GeocoderFactory.instantiateClass((String)m_prop.get(HANDLERKEY));
        Enumeration<Object> enumeration = m_prop.keys();
        String key = null;
        block4: while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            switch (GeocoderFactory.getKeyType(key)) {
                case 0: {
                    genricHandler.setBrowseHelper((IBrowseHelper)GeocoderFactory.instantiateClass(m_prop.get(key).toString()));
                    continue block4;
                }
                case 1: {
                    genricHandler.setDataManager((IDataManager)GeocoderFactory.instantiateClass(m_prop.getProperty(key).toString()));
                    continue block4;
                }
            }
        }
        return genricHandler;
    }

    private static Properties readPropFile(String propFileName) {
        Properties prop = null;
        try {
            prop = new Properties();
            prop.load(GeocoderFactory.class.getResourceAsStream(propFileName));
        }
        catch (IOException IOEx) {
            System.err.println("Unable to load properties from properties file: " + propFileName);
            System.err.println(IOEx.getMessage());
        }
        return prop;
    }

    private static Object instantiateClass(String classname) {
        Object object = null;
        try {
            Class<?> handlerClass = Class.forName(classname);
            object = handlerClass.newInstance();
        }
        catch (IllegalAccessException ile) {
            System.err.println(ile.getMessage());
        }
        catch (InstantiationException ine) {
            System.err.println(ine.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            System.err.println(cnfe.getMessage());
        }
        return object;
    }

    private static void fillMap(String key) {
        StringTokenizer tokens = new StringTokenizer(key, ",");
        m_keyMap = new HashMap();
        int ctr = 0;
        while (tokens.hasMoreElements()) {
            m_keyMap.put(tokens.nextElement().toString(), new Integer(ctr));
            ++ctr;
        }
    }

    private static IGeocoder setHandlerToGeocoder(String classname, IHandler handler) {
        IGeocoder geocoder = null;
        try {
            Class<?> geocoderClass = Class.forName(classname);
            Class[] classarray = new Class[]{IHandler.class};
            Constructor<?> geoConstructor = geocoderClass.getConstructor(classarray);
            Object[] parameterArray = new Object[]{handler};
            geocoder = (IGeocoder)geoConstructor.newInstance(parameterArray);
        }
        catch (IllegalAccessException ile) {
            System.err.println(ile.getMessage());
        }
        catch (InvocationTargetException ile) {
            System.err.println(ile.getMessage());
        }
        catch (NoSuchMethodException ile) {
            System.err.println(ile.getMessage());
        }
        catch (InstantiationException ine) {
            System.err.println(ine.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            System.err.println(cnfe.getMessage());
        }
        return geocoder;
    }

    private static int getKeyType(String key) {
        int pos = -1;
        if (m_keyMap.containsKey(key)) {
            pos = (Integer)m_keyMap.get(key);
        }
        return pos;
    }

    public static void main(String[] args) {
    }

    static {
        ISO3166[] countries = ISO3166.getISOCountries();
        m_store = new HashMap();
        IGeocoder geocoder = GeocoderFactory.createGeocoder("DEU");
        if (geocoder != null) {
            m_store.put("DEU", geocoder);
        }
    }
}

