/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.browse;

import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.DEU_InternalBrowseAddress;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_DataManager;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.browse.EMEA_BrowseFilter;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class DEU_BrowseFilter
extends EMEA_BrowseFilter
implements IBrowseFilter {
    @Override
    public List filterAddresses(IConstraints constraints, Address pa, List candidates) throws MatcherException {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        this.removeDuplicateAddresses(candidates);
        return this.filterCandidates(constraints, pa, candidates);
    }

    private void removeDuplicateAddresses(List candidates) {
        HashSet<DEU_InternalBrowseAddress.StreetBasedIdentifier> set = new HashSet<DEU_InternalBrowseAddress.StreetBasedIdentifier>(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            DEU_InternalBrowseAddress DEUBrowseAddress = (DEU_InternalBrowseAddress)((Object)iter.next());
            DEU_InternalBrowseAddress.StreetBasedIdentifier identifier = DEUBrowseAddress.getStreetBasedIdentifier();
            if (set.contains(identifier)) {
                iter.remove();
                continue;
            }
            set.add(identifier);
        }
    }

    private List filterCandidates(IConstraints constraints, Address pa, List candidates) {
        FieldScores thresholds = constraints.getHandler().getMatcherConstants().getFieldScores();
        StringScorer scorer = ((CoreHandler)constraints.getHandler()).getScoringHelper().makeStringScorer();
        ArrayList<DEU_InternalBrowseAddress> filteredCandidates = new ArrayList<DEU_InternalBrowseAddress>(candidates.size());
        for (DEU_InternalBrowseAddress address : candidates) {
            DEU_InternalBrowseAddress filteredAddress = this.filterAddress(address, pa, thresholds, constraints, scorer);
            if (filteredAddress == null) continue;
            filteredCandidates.add(filteredAddress);
        }
        return filteredCandidates;
    }

    private DEU_InternalBrowseAddress filterAddress(InternalBrowseAddress address, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        DEU_InternalBrowseAddress filteredAddress = (DEU_InternalBrowseAddress)constraints.getHandler().getBrowseHelper().makeBrowseAddress((Address)address);
        filteredAddress.setVendorCode(address.getVendorCode());
        int segmentCount = address.getSegmentCount();
        for (int index = 0; index < segmentCount; ++index) {
            int dictNum;
            Segment segment = address.getSegmentAt(index);
            Segment filteredSegment = this.filterSegment(segment, dictNum = filteredAddress.getDictionaryNumber(), inputAddress, thresholds, constraints, scorer);
            if (filteredSegment == null) continue;
            filteredAddress.addSegment(filteredSegment);
        }
        if (filteredAddress.getSegmentCount() > 0) {
            return filteredAddress;
        }
        return null;
    }

    private Segment filterSegment(Segment segment, int dictNum, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        double postcode1Score;
        double score;
        double an3Score;
        IMatchPreferences constants = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, inputAddress);
        EMEA_GeoInfoRecord geoinfo = (EMEA_GeoInfoRecord)segment.getGeoInfoRecord();
        String an3 = inputAddress.getAreaName3();
        String an4 = inputAddress.getAreaName4();
        if (DEU_AddressUtils.isEmpty(an3) && DEU_AddressUtils.isEmpty(an4)) {
            an3Score = 1.0;
            double an4Score = 1.0;
        } else if (geoinfo != null) {
            String an4FromGeoInfo;
            double an4Score;
            String shortNameFromGeoInfo = geoinfo.getAreaName3Short();
            if (DEU_AddressUtils.isEmpty(shortNameFromGeoInfo)) {
                an3Score = scorer.scoreString(an3, geoinfo.getAreaName3(), ",./");
                an4Score = scorer.scoreString(an4, geoinfo.getAreaName3(), ",./");
                if (DEU_AddressUtils.isEmpty(an4)) {
                    if (an3Score == 1.0) {
                        an4Score = 1.0;
                    }
                } else if (an4Score == 1.0) {
                    an3Score = 1.0;
                }
            } else {
                an3Score = scorer.scoreString(an3, shortNameFromGeoInfo);
                if (an3Score < thresholds.getAreaName3()) {
                    an3Score = scorer.scoreString(DEU_AddressTerm.removePunctuationChars(an3, true), shortNameFromGeoInfo);
                }
                if (an3Score < thresholds.getAreaName3()) {
                    an3Score = scorer.scoreString(an3, geoinfo.getAreaName3(), ",./");
                }
                an4Score = scorer.scoreString(an4, geoinfo.getAreaName3(), ",./");
            }
            if (geoinfo.getAltAreaName3() != null && (an3Score != 1.0 || an4Score != 1.0)) {
                int index;
                String[] tokens = geoinfo.getAltAreaName3().split("/");
                boolean shortIsSameAsFull = true;
                if (!DEU_AddressUtils.isEmpty(an3) && an3Score != 1.0) {
                    for (index = 0; index < tokens.length; ++index) {
                        String fullAlias = tokens[index].trim();
                        String shortAlias = DEU_ParsePostAddressRule.removeCommonWords(fullAlias);
                        if (shortAlias == null) {
                            shortAlias = fullAlias;
                        }
                        if (!(an3Score < (score = scorer.scoreString(an3, shortAlias)))) continue;
                        shortIsSameAsFull = shortAlias.length() == fullAlias.length();
                        an3Score = score;
                        if (an3Score == 1.0) break;
                    }
                }
                if (!DEU_AddressUtils.isEmpty(an4) && an4Score != 1.0) {
                    for (index = 0; index < tokens.length; ++index) {
                        score = scorer.scoreString(an4, tokens[index]);
                        double d = an4Score = an4Score < score ? score : an4Score;
                        if (an4Score == 1.0) break;
                    }
                }
                if (DEU_AddressUtils.isEmpty(an4)) {
                    if (an3Score > an4Score) {
                        if (constants.getExactMatchAreaName3()) {
                            if (shortIsSameAsFull) {
                                an4Score = an3Score;
                            }
                        } else {
                            an4Score = an3Score;
                        }
                    }
                } else if (an4Score > an3Score) {
                    an3Score = an4Score;
                }
            }
            ArrayList geoRecords = null;
            if (an3Score != 1.0) {
                double[] scores;
                String locality = geoinfo.getAliasedLocality();
                if (!DEU_AddressUtils.isEmpty(locality) && an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0]) {
                    an3Score = scores[0];
                    an4Score = scores[1];
                }
                if (an3Score != 1.0) {
                    String leftPostCode1 = segment.getLeftPostCode1();
                    String rightPostCode1 = segment.getRightPostCode1();
                    boolean isLeftRightPostCode1Same = true;
                    if (!DEU_AddressUtils.isEmpty(leftPostCode1)) {
                        geoRecords = DEU_DataManager.getGeoInfoAlias(geoinfo.getAreaName3(), leftPostCode1, dictNum);
                        isLeftRightPostCode1Same = leftPostCode1.equalsIgnoreCase(rightPostCode1);
                    }
                    if (!isLeftRightPostCode1Same && !DEU_AddressUtils.isEmpty(rightPostCode1)) {
                        ArrayList rightList = DEU_DataManager.getGeoInfoAlias(geoinfo.getAreaName3(), rightPostCode1, dictNum);
                        if (geoRecords != null && rightList != null) {
                            geoRecords.addAll(rightList);
                        } else {
                            geoRecords = rightList;
                        }
                    }
                    if (geoRecords != null) {
                        for (int index = 0; index < geoRecords.size(); ++index) {
                            double[] scores2;
                            locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                            if (DEU_AddressUtils.isEmpty(locality) || !(an3Score < (scores2 = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0])) continue;
                            an3Score = scores2[0];
                            an4Score = scores2[1];
                        }
                    }
                }
            }
            if (an3Score != 1.0 && !DEU_AddressUtils.isEmpty(an4FromGeoInfo = geoinfo.getAreaName4()) && !an4FromGeoInfo.equals(geoinfo.getAreaName3())) {
                String fullTownName;
                String string = fullTownName = DEU_AddressUtils.isEmpty(an4) ? an3 : an4;
                if (!DEU_AddressUtils.isEmpty(fullTownName)) {
                    double tempScore = scorer.scoreString(fullTownName, an4FromGeoInfo);
                    if (an3Score < tempScore) {
                        an3Score = tempScore;
                    }
                    if (an4Score < tempScore) {
                        an4Score = tempScore;
                    }
                }
            }
            if (an3Score != 1.0) {
                String locality = null;
                geoRecords = DEU_DataManager.getGeoInfoAlias(geoinfo.getAreaName3(), segment.getLeftPostCode1(), dictNum);
                if (geoRecords != null) {
                    for (int index = 0; index < geoRecords.size(); ++index) {
                        double[] scores;
                        locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                        if (locality == null) {
                            locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAreaName3();
                        }
                        if (DEU_AddressUtils.isEmpty(locality) || !(an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0])) continue;
                        an3Score = scores[0];
                        an4Score = scores[1];
                    }
                }
            }
            if (an3Score != 1.0) {
                double highScore = 0.0;
                StringTokenizer st = new StringTokenizer(an3, " ,-/\\().");
                LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)st);
                String lastToken = listOfTokens.getLast().toString();
                score = scorer.scoreString(geoinfo.getAreaName3(), lastToken);
                an3Score = highScore = score > an3Score ? score : an3Score;
            }
        } else if (DEU_AddressUtils.isEmpty(an3)) {
            an3Score = 1.0;
            double an4Score = 1.0;
        } else {
            double[] scores = this.calculateAn3An4Scores(scorer, an3, an4, segment.getLeftAreaName3());
            an3Score = scores[0];
            double an4Score = scores[1];
            if (an3Score != 1.0 && an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, segment.getRightAreaName3()))[0]) {
                an3Score = scores[0];
                an4Score = scores[1];
            }
            if (an3Score != 1.0) {
                String leftPostCode1 = segment.getLeftPostCode1();
                String rightPostCode1 = segment.getRightPostCode1();
                ArrayList geoRecords = null;
                boolean isLeftRightPostCode1Same = true;
                if (!DEU_AddressUtils.isEmpty(leftPostCode1)) {
                    geoRecords = DEU_DataManager.getGeoInfoAlias(segment.getLeftAreaName3(), leftPostCode1, dictNum);
                    isLeftRightPostCode1Same = leftPostCode1.equalsIgnoreCase(rightPostCode1);
                }
                if (!isLeftRightPostCode1Same && !DEU_AddressUtils.isEmpty(rightPostCode1)) {
                    ArrayList rightList = DEU_DataManager.getGeoInfoAlias(segment.getRightAreaName3(), rightPostCode1, dictNum);
                    if (geoRecords != null && rightList != null) {
                        geoRecords.addAll(rightList);
                    } else {
                        geoRecords = rightList;
                    }
                }
                if (geoRecords != null) {
                    for (int index = 0; index < geoRecords.size(); ++index) {
                        String locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                        if (DEU_AddressUtils.isEmpty(locality) || !(an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0])) continue;
                        an3Score = scores[0];
                        an4Score = scores[1];
                    }
                }
            }
        }
        if (constants.getExactMatchAreaName3() ? an3Score != 1.0 : an3Score < thresholds.getAreaName3()) {
            return null;
        }
        String postcode1 = inputAddress.getPostCode1();
        if (DEU_AddressUtils.isEmpty(postcode1)) {
            postcode1Score = 1.0;
        } else {
            score = scorer.scoreString(postcode1, segment.getLeftPostCode1());
            postcode1Score = score;
            if (postcode1Score != 1.0) {
                score = scorer.scoreString(postcode1, segment.getRightPostCode1());
                double d = postcode1Score = postcode1Score < score ? score : postcode1Score;
            }
        }
        if (constants.getExactMatchPostalCode1() ? postcode1Score != 1.0 : postcode1Score < thresholds.getPostalCode1()) {
            return null;
        }
        return segment;
    }

    private double[] calculateAn3An4Scores(StringScorer scorer, String an3, String an4, String town) {
        double an3Score = 0.0;
        double an4Score = 0.0;
        if (!DEU_AddressUtils.isEmpty(town)) {
            String shortTown = DEU_ParsePostAddressRule.removeCommonWords(town);
            if (DEU_AddressUtils.isEmpty(shortTown)) {
                shortTown = town;
            }
            an3Score = scorer.scoreString(an3, shortTown);
            an4Score = shortTown.length() != town.length() ? scorer.scoreString(an4, town) : (DEU_AddressUtils.isEmpty(an4) ? 1.0 : 0.0);
        }
        return new double[]{an3Score, an4Score};
    }
}

