/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp;

import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.dp.EMEA_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class DEU_GeoInfoDataSourceRecordConvertorImpl
extends EMEA_GeoInfoDataSourceRecordConvertorImpl {
    private boolean createMultiWords = false;
    private boolean bFileOpened;
    private PrintWriter multiWordFile = null;
    private HashSet multiWordSet = null;

    public DEU_GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        EMEA_GeoInfoRecord baseRecord;
        String fullAreaName3;
        String areaName3Short;
        MMJGeoInfoRecord record = this.convert(inputData, new EMEA_GeoInfoRecord());
        if (record != null && (areaName3Short = DEU_ParsePostAddressRule.removeCommonWords(fullAreaName3 = (baseRecord = (EMEA_GeoInfoRecord)record.getRecord()).getAreaName3())) != null && !areaName3Short.equals(fullAreaName3)) {
            baseRecord.setAreaName3Short(areaName3Short);
        }
        return record;
    }

    @Override
    public MMJGeoInfoRecord convert(IDataSourceRecord inputData, EMEA_GeoInfoRecord baseRecord) throws DataCreationException {
        String region = null;
        String province = null;
        String areaName3 = null;
        String languageAlias = null;
        String additionalLocality = null;
        String postCode = null;
        String locality = null;
        int flag = -1;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return (MMJGeoInfoRecord)this.getNextDataRecord();
            }
            return null;
        }
        IGeoInfoDataSourceRecord input = (IGeoInfoDataSourceRecord)inputData;
        try {
            if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
                areaName3 = input.getAreaName3();
            }
            if (input.hasAlternateAreaName3() && this.stringExists(input.getAlternateAreaName3())) {
                languageAlias = input.getAlternateAreaName3();
            }
            if (input.hasAreaName4() && this.stringExists(input.getAreaName4())) {
                locality = input.getAreaName4();
            }
            if (input.hasAlternateAreaName4() && this.stringExists(input.getAlternateAreaName4())) {
                additionalLocality = input.getAlternateAreaName4();
            }
            if (input.hasAlternateAreaName2() && this.stringExists(input.getAlternateAreaName2())) {
                postCode = input.getAlternateAreaName2();
            }
            if (areaName3 != null && additionalLocality != null && areaName3.equalsIgnoreCase(additionalLocality)) {
                additionalLocality = null;
            }
            if (input.hasAreaName2() && this.stringExists(input.getAreaName2())) {
                province = input.getAreaName2();
            }
            if (input.hasAreaName1() && this.stringExists(input.getAreaName1())) {
                region = input.getAreaName1();
            }
            if (input.hasPrecision()) {
                flag = input.getPrecision();
            }
            if (areaName3 != null) {
                if (province != null && province.trim().length() > 0) {
                    baseRecord.setAreaName2(province.trim());
                }
                if (region != null && region.trim().length() > 0) {
                    baseRecord.setAreaName1(region.trim());
                }
                baseRecord.setAreaName3(areaName3.trim());
                if (languageAlias != null) {
                    baseRecord.setAltLanguageNames(languageAlias);
                }
                if (locality != null && locality.trim().length() > 0) {
                    baseRecord.setAreaName4(locality.trim());
                }
                if (additionalLocality != null && additionalLocality.trim().length() > 0) {
                    baseRecord.setAliasedLocality(additionalLocality);
                }
                if (input.hasCentroid()) {
                    baseRecord.setPoint(input.getCentroid());
                }
                MiStringIndexKey key = null;
                if (this.createMultiWords && !this.bFileOpened) {
                    this.bFileOpened = this.openMultiWordFile();
                }
                if (this.createMultiWords) {
                    String areaName3Short = areaName3;
                    if (areaName3Short != null && (areaName3Short.indexOf(32) > 1 || areaName3Short.indexOf(45) > 1 || areaName3Short.indexOf(39) > 1)) {
                        this.writeMultiWord(areaName3Short);
                    }
                    if (languageAlias != null) {
                        StringTokenizer st = new StringTokenizer(languageAlias, "/\\");
                        while (st.hasMoreTokens()) {
                            String an3Alt = st.nextToken();
                            String an3AltShort = DEU_AddressTerm.removeCommonWords(an3Alt)[0];
                            if (an3AltShort == null) {
                                an3AltShort = an3Alt;
                            }
                            if (an3AltShort.indexOf(32) <= 0 && an3AltShort.indexOf(45) <= 0 && an3AltShort.indexOf(39) <= 0) continue;
                            this.writeMultiWord(an3AltShort);
                        }
                    }
                    if (additionalLocality != null) {
                        String addLocShort = DEU_AddressTerm.removeCommonWords(additionalLocality)[0];
                        if (addLocShort == null) {
                            addLocShort = additionalLocality;
                        }
                        if (addLocShort.indexOf(32) > 0 || addLocShort.indexOf(45) > 0 || addLocShort.indexOf(39) > 0) {
                            this.writeMultiWord(addLocShort);
                        }
                    }
                }
                switch (flag) {
                    case 0: {
                        baseRecord.setPrecision((byte)0);
                        String combinedKey = baseRecord.getAreaName4() == null ? "" : baseRecord.getAreaName4();
                        combinedKey = combinedKey + (baseRecord.getAreaName3() == null ? "" : baseRecord.getAreaName3());
                        combinedKey = combinedKey + (baseRecord.getAreaName2() == null ? "" : baseRecord.getAreaName2());
                        combinedKey = combinedKey + (baseRecord.getAreaName1() == null ? "" : baseRecord.getAreaName1());
                        key = new MiStringIndexKey(combinedKey.toUpperCase());
                        break;
                    }
                    case 3: {
                        baseRecord.setAreaName3(areaName3);
                        baseRecord.setAreaName4(locality);
                        baseRecord.setPostCode(postCode);
                        baseRecord.setPrecision((byte)0);
                        key = new MiStringIndexKey(EMEA_GeoInfoAliasKeyCreator.createKey(areaName3.toUpperCase(), postCode));
                        break;
                    }
                    case 1: {
                        baseRecord.setPrecision((byte)10);
                        key = new MiStringIndexKey(areaName3.toUpperCase());
                        break;
                    }
                    case 2: {
                        baseRecord.setAreaName3(locality);
                        baseRecord.setAreaName4(areaName3);
                        baseRecord.setPrecision((byte)11);
                        key = new MiStringIndexKey(areaName3.toUpperCase());
                    }
                }
                return new MMJGeoInfoRecord((GeoInfoRecord)baseRecord, key);
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(301, (Throwable)DSEx);
        }
        return null;
    }

    @Override
    public GeoInfoRecord makeGeoInfoRecordType() {
        return new EMEA_GeoInfoRecord();
    }

    private boolean openMultiWordFile() {
        this.multiWordSet = new HashSet(1000, 500.0f);
        this.multiWordFile = null;
        try {
            this.multiWordFile = new PrintWriter(new FileWriter("_DEU_MultiWordAreaNames.properties"));
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to open file: _DEU_MultiWordAreaNames.properties");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            throw new RuntimeException("Unable to open file _DEU_MultiWordAreaNames.properties");
        }
        BufferedReader inputReader = null;
        try {
            inputReader = new BufferedReader(new FileReader("DEU_MultiWordAreaNames.properties"));
            String line = null;
            while ((line = inputReader.readLine()) != null) {
                this.multiWordSet.add(line.trim());
                this.multiWordFile.println(line.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void writeMultiWord(String areaName) {
        String areaNameU = DEU_AddressTerm.removeDiacritics(areaName.toUpperCase());
        if (areaNameU.length() > 0 && areaNameU.charAt(0) == '+') {
            if (areaNameU.length() > 1) {
                areaNameU = areaNameU.substring(1);
            } else {
                return;
            }
        }
        if (this.multiWordFile != null && this.multiWordSet != null && !this.multiWordSet.contains(areaNameU)) {
            this.multiWordFile.println(areaNameU);
            this.multiWordSet.add(areaNameU);
            this.multiWordFile.flush();
        }
    }
}

