/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.DEU_InternalCandidateAddress;
import com.mapinfo.mapmarker.DEU.DEU_ScoringHelper;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.EMEA.dp.EMEA_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.core.parser.ParserException;
import java.util.ArrayList;
import java.util.Properties;

public class DEU_StreetDataSourceRecordConvertorImpl
extends EMEA_StreetDataSourceRecordConvertorImpl {
    public DEU_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyString = alternateBrowseString.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = DEU_ScoringHelper.getFirstNormChar(keyString);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        ArrayList keyBases = this.getKeyBases(address);
        ArrayList<MapMarkerBrowseMultiLevelIndexKey> keys = new ArrayList<MapMarkerBrowseMultiLevelIndexKey>(keyBases.size());
        for (String keyBase : keyBases) {
            int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
            char c = DEU_ScoringHelper.getFirstNormChar(keyBase);
            keys.add(new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey));
        }
        MapMarkerIndexKey[] keyArray = new MapMarkerIndexKey[keys.size()];
        return keys.toArray(keyArray);
    }

    @Override
    public boolean canReassembleAddress(String original_street, Address parsed) {
        String parsed_street = DEU_InternalCandidateAddress.reconstructAddress(new InternalCandidateAddress(parsed));
        boolean result = parsed_street.equals(original_street);
        return result;
    }

    @Override
    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        return record;
    }

    @Override
    protected ArrayList getKeyBases(Address address) {
        ArrayList keyBases = super.getKeyBases(address);
        keyBases.add(DEU_AddressUtils.getFormattedStreetAddress(address, false).toUpperCase());
        return keyBases;
    }

    @Override
    protected Address parseStreet(Address input) {
        input.setAreaName3("DummyTownName");
        String mainAddress = input.getMainAddress();
        String tempMainAddress = mainAddress.substring(0, mainAddress.indexOf("100"));
        Address addr = this.privateParseStreet(input);
        if (addr.getAddressNumber() != null && addr.getAddressNumber().equals("100")) {
            addr.setAddressNumber((ParsedNumber)null);
        } else {
            addr.setMainAddress(tempMainAddress);
            addr = this.privateParseStreet(addr);
        }
        if (addr.getAddressNumber() != null) {
            String postAddr;
            String mainAddr = addr.getMainAddress().trim();
            boolean flag = false;
            for (int i = 0; i < mainAddr.length(); ++i) {
                if (!DEU_AddressTerm.isDigit(mainAddr.charAt(i))) {
                    flag = false;
                    break;
                }
                flag = true;
            }
            String string = postAddr = (postAddr = addr.getPostAddress()) == null ? "" : postAddr;
            if (!flag) {
                postAddr = postAddr + " " + addr.getAddressNumber();
            }
            addr.setPostAddress(postAddr);
            addr.setAddressNumber((ParsedNumber)null);
        }
        addr.setAreaName3(null);
        return addr;
    }

    protected Address privateParseStreet(Address input) {
        Address[] parsedAddresses;
        try {
            parsedAddresses = this.m_parser.parse(input, (IConstraints)this.m_parserConstraints);
        }
        catch (ParserException PEx) {
            DataCreationLogger.getLogger().logInternalError("AbstractStreetDataSourceConvertor:: getParsedAddress(): Unable to parse street address: \n" + input.getMainAddress());
            DataCreationLogger.getLogger().logInternalError(PEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)PEx);
            return null;
        }
        if (parsedAddresses == null || parsedAddresses.length != 1) {
            return null;
        }
        return parsedAddresses[0];
    }
}

