/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.DEU_ScoringHelper;
import com.mapinfo.mapmarker.DEU.dp.DEU_DataConstructionParser;
import com.mapinfo.mapmarker.DEU.dp.DEU_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.DEU.dp.DEU_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.DEU.dp.DEU_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.DEU.dp.ap.DEU_APStreetDataSourceRecordConverter;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_DataFileMasksProvider;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_StreetBuilder;
import com.mapinfo.mapmarker.DEU.dp.binary.ap.DEU_APStreetBuilder;
import com.mapinfo.mapmarker.DEU.dp.binary.index.DEU_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.DEU.dp.intermediate.DEU_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.DEU.dp.intermediate.ap.DEU_APIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_TabDataProvider;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.Properties;

public abstract class DEU_AbstractDataProvider
extends EMEA_TabDataProvider {
    static MiVersion m_version = new MiVersion(4, 0, 0);
    private MMJComplexDataFileMetadata m_streetMetadata;
    private MMJComplexDataFileMetadata m_postInfoMetadata;
    private MMJComplexDataFileMetadata m_geoInfoMetadata;
    private static GeoInfoSoundexIndexer m_GeoInfoSoundexIndexer = null;
    protected boolean m_bAPStreetData;
    private boolean m_isUserDictioanry;

    protected DEU_AbstractDataProvider() {
        this(false);
    }

    protected DEU_AbstractDataProvider(boolean isUserDictionary) {
        this.m_isUserDictioanry = isUserDictionary;
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        String apKey = processingProperties.getProperty("AP_PROCESSING", "");
        this.m_bAPStreetData = apKey != null ? apKey.equals("YES") : false;
        this.m_dataBuilder = this.m_bAPStreetData ? new DEU_APStreetBuilder(processingProperties, this.m_bAPStreetData) : new DEU_StreetBuilder(processingProperties, this.m_bAPStreetData);
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new Post2SacDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        boolean bProcessGeo2Sac = "YES".equalsIgnoreCase(processingProperties.getProperty("geo2sac_create"));
        if (bProcessGeo2Sac) {
            this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new DEU_Geo2SacDataSourceRecordConvertorImpl(processingProperties, new DEUGermanSoundex(), this.m_bAPStreetData), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new PostInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new DEU_GeoInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        if ("YES".equalsIgnoreCase(processingProperties.getProperty("street_create"))) {
            DEU_IntermediateStreetDataFileFormatHandler intermediateHandler;
            DEU_StreetDataSourceRecordConvertorImpl streetRecordConvertor;
            DEU_Constraints constraints = new DEU_Constraints();
            constraints.setDataConstructionConstraint(true);
            String intermediateHandlerPath = StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp");
            if (this.m_bAPStreetData) {
                streetRecordConvertor = new DEU_APStreetDataSourceRecordConverter(new DEUGermanSoundex(), processingProperties, new CollationKeyGenerator(new Locale("DE", "DEU"), DEU_ScoringHelper.getCollationRules()), new DEU_DataConstructionParser(), constraints);
                intermediateHandler = new DEU_APIntermediateStreetDataFileFormatHandler(intermediateHandlerPath);
            } else {
                streetRecordConvertor = new DEU_StreetDataSourceRecordConvertorImpl(new DEUGermanSoundex(), processingProperties, new CollationKeyGenerator(new Locale("DE", "DEU"), DEU_ScoringHelper.getCollationRules()), new DEU_DataConstructionParser(), constraints);
                intermediateHandler = new DEU_IntermediateStreetDataFileFormatHandler(intermediateHandlerPath);
            }
            this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)streetRecordConvertor, (IIntermediateDataHandler)intermediateHandler, (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new DEU_MMJStreetRecordComparator(), new MMJSegmentComparer());
        }
    }

    protected abstract IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        if (m_GeoInfoSoundexIndexer == null) {
            m_GeoInfoSoundexIndexer = new DEU_GeoInfoSoundexIndexer();
        }
        ((DEU_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.getGeoInfoForStreetsFileBaseName());
        return m_GeoInfoSoundexIndexer;
    }

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = new DEU_MMJComplexDataFileMetadata(this.m_isUserDictioanry);
            this.m_streetMetadata.setVersion(m_version);
            DataFileMasks masks = this.getStreetDataFileMasks();
            this.m_streetMetadata.setDataFileMasks(masks);
            if (this.m_bAPStreetData) {
                this.m_streetMetadata.setXPow10((byte)6);
                this.m_streetMetadata.setYPow10((byte)6);
            } else {
                this.m_streetMetadata.setXPow10((byte)5);
                this.m_streetMetadata.setYPow10((byte)5);
            }
            this.m_streetMetadata.setCountry("DEU");
        }
        this.m_streetMetadata.setVendorCode(this.getVandorAndDataType());
        return this.m_streetMetadata;
    }

    protected DataFileMasks getStreetDataFileMasks() {
        DataFileMasks masks = null;
        masks = this.m_bAPStreetData ? DEU_DataFileMasksProvider.getAPStreetMasks() : DEU_DataFileMasksProvider.getSegmentedStreetMasks();
        return masks;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (this.m_postInfoMetadata == null) {
            this.m_postInfoMetadata = new DEU_MMJComplexDataFileMetadata(this.m_isUserDictioanry);
            this.m_postInfoMetadata.setCountry("DEU");
            this.m_postInfoMetadata.setXPow10((byte)5);
            this.m_postInfoMetadata.setYPow10((byte)5);
            this.m_postInfoMetadata.setVersion(m_version);
            this.m_postInfoMetadata.setDataFileMasks(DEU_DataFileMasksProvider.getPostInfoDataFileMasks());
            this.m_postInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_postInfoMetadata;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.m_geoInfoMetadata == null) {
            this.m_geoInfoMetadata = new DEU_MMJComplexDataFileMetadata(this.m_isUserDictioanry);
            this.m_geoInfoMetadata.setCountry("DEU");
            this.m_geoInfoMetadata.setXPow10((byte)5);
            this.m_geoInfoMetadata.setYPow10((byte)5);
            this.m_geoInfoMetadata.setVersion(m_version);
            this.m_geoInfoMetadata.setDataFileMasks(DEU_DataFileMasksProvider.getGeoInfoDataFileMasks());
            this.m_geoInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_geoInfoMetadata;
    }

    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new DEU_MiStringIndexFileConvertor(tempIndex, newIndex);
    }

    public boolean supportsReverseGeocode() {
        return true;
    }
}

