/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.DEU_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.DEU.DEU_ScoringHelper;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_AddressFetcher;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MMJSac2FnData;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataDictionary;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_Geo2SacRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class DEU_DataDictionary
extends EMEA_DataDictionary {
    private static final String NO_SAC2FN_FILE = "exception.no.sac2fn";
    private static final String SAC2FN_FILE_OPEN = "exception.open.sac2fn";
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_GEOBASE_USE_PROVINCE_SEARCH = "KEY_GEOBASE_USE_PROVINCE_SEARCH";
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_DEU_ALTERNATE_SOUNDEX_CODES = "KEY_DEU_ALTERNATE_SOUNDEX_CODES";
    private static Soundex soundex = new DEUGermanSoundex();
    private boolean m_isAPDictionary;
    private static final Soundex m_soundex = new DEUGermanSoundex();
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("DE", "DEU"), DEU_ScoringHelper.getCollationRules());
    private static final String STREET_DATA_FILE_CACHE_COUNT = "setting.street.data.cache.count";
    private static final String STREET_INDEX_FILE_CACHE_COUNT = "setting.street.index.cache.count";

    public DEU_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    protected void initStreetDataFileCache() {
        this.getDataManagerSettings().setProperty(STREET_DATA_FILE_CACHE_COUNT, "20");
        super.initStreetDataFileCache();
    }

    protected void initStreetIndexFileCaches() {
        this.getDataManagerSettings().setProperty(STREET_INDEX_FILE_CACHE_COUNT, "20");
        super.initStreetIndexFileCaches();
    }

    @Override
    public IGeoBase[] getGeoBases(Address pa, IConstraints preferences) {
        int spacePos;
        String areaName3 = DEU_ParsePostAddressRule.removeCommonWords(this.cleanAreaNameString(pa.getAreaName3()));
        String areaName4 = DEU_ParsePostAddressRule.removeCommonWords(this.cleanAreaNameString(pa.getAreaName4()));
        String altAreaName3 = null;
        String altAreaName4 = null;
        if (!(areaName3 != null && areaName3.trim().length() != 0 || areaName4 != null && areaName4.trim().length() != 0)) {
            return null;
        }
        boolean bStringKey = new Boolean(preferences.getCustomString("KEY_GEOBASE_STRING_ONLY"));
        if (areaName3 != null && (spacePos = areaName3.indexOf(32)) > 0) {
            altAreaName3 = areaName3.substring(0, spacePos);
        }
        if (areaName4 != null && (spacePos = areaName4.indexOf(32)) > 0) {
            altAreaName4 = areaName4.substring(0, spacePos);
        }
        boolean forGeographicCentroid = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID));
        ISoundexKey areaName3SndxKey = null;
        ISoundexKey areaName4SndxKey = null;
        ISoundexKey altAreaName3SndxKey = null;
        ISoundexKey altAreaName4SndxKey = null;
        boolean bUseAreaName3 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA3));
        boolean bUseAreaName4 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4));
        if (areaName3 != null && bUseAreaName3) {
            areaName3SndxKey = bStringKey ? DEUGermanSoundex.getStringKey(areaName3) : soundex.getSoundex(areaName3);
        }
        if (areaName4 != null && bUseAreaName4) {
            areaName4SndxKey = bStringKey ? DEUGermanSoundex.getStringKey(areaName4) : soundex.getSoundex(areaName4);
        }
        if (altAreaName3 != null && bUseAreaName3) {
            if (bStringKey) {
                altAreaName3SndxKey = DEUGermanSoundex.getStringKey(altAreaName3);
            } else if (!((DEU_Constraints)preferences).isExactMatchMode()) {
                altAreaName3SndxKey = soundex.getSoundex(altAreaName3);
            }
        }
        if (altAreaName4 != null && bUseAreaName4) {
            altAreaName4SndxKey = bStringKey ? DEUGermanSoundex.getStringKey(altAreaName4) : soundex.getSoundex(altAreaName4);
        }
        if (forGeographicCentroid) {
            areaName3SndxKey = soundex.getSoundex(areaName3);
            areaName4SndxKey = soundex.getSoundex(areaName4);
            altAreaName3SndxKey = soundex.getSoundex(altAreaName3);
            ArrayList<MiSoundexGeoBase> bases = new ArrayList<MiSoundexGeoBase>(3);
            if (areaName3SndxKey != null) {
                bases.add(new MiSoundexGeoBase((MiSoundexKey)areaName3SndxKey));
            }
            if (areaName4SndxKey != null) {
                bases.add(new MiSoundexGeoBase((MiSoundexKey)areaName4SndxKey));
            }
            if (altAreaName3SndxKey != null) {
                bases.add(new MiSoundexGeoBase((MiSoundexKey)altAreaName3SndxKey));
            }
            if (altAreaName4SndxKey != null) {
                bases.add(new MiSoundexGeoBase((MiSoundexKey)altAreaName4SndxKey));
            }
            IGeoBase[] retvals = new IGeoBase[bases.size()];
            for (int i = 0; i < bases.size(); ++i) {
                retvals[i] = (MiSoundexGeoBase)bases.get(i);
            }
            return retvals;
        }
        ArrayList<EMEA_GeoBase> bases = new ArrayList<EMEA_GeoBase>(4);
        if (areaName3SndxKey != null) {
            if (bUseAreaName3) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)areaName3SndxKey, 3));
            }
            if (bUseAreaName4) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)areaName3SndxKey, 4));
            }
        }
        if (areaName4SndxKey != null) {
            if (bUseAreaName3) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)areaName4SndxKey, 3));
            }
            if (bUseAreaName4) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)areaName4SndxKey, 4));
            }
        }
        if (altAreaName3SndxKey != null) {
            if (bUseAreaName3) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)altAreaName3SndxKey, 3));
            }
            if (bUseAreaName4) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)altAreaName3SndxKey, 4));
            }
        }
        if (altAreaName4SndxKey != null) {
            if (bUseAreaName3) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)altAreaName4SndxKey, 3));
            }
            if (bUseAreaName4) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)altAreaName4SndxKey, 4));
            }
        }
        IGeoBase[] retvals = new IGeoBase[bases.size()];
        for (int i = 0; i < bases.size(); ++i) {
            retvals[i] = (EMEA_GeoBase)bases.get(i);
        }
        return retvals;
    }

    @Override
    protected IPostalBase makePostalBase(String zipCode) {
        if (zipCode == null || zipCode.length() <= 2) {
            return null;
        }
        return new StandardPostalBase(zipCode.substring(0, 3));
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new EMEA_Geo2SacRecord();
    }

    protected IAddressFetcher initAddressFetcher() {
        return new DEU_AddressFetcher(this.getDataManagerSettings(), null, this.m_isAPDictionary);
    }

    protected MMJSac2FnData initSac2FnData() throws DataDictionaryIntializationException {
        try {
            DEU_MMJSac2FnData data = new DEU_MMJSac2FnData(super.getDictionaryPath());
            this.m_isAPDictionary = data.isAPDictionary();
            this.setIsUserDictionary(data.forUserDictionary());
            return data;
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException(NO_SAC2FN_FILE, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(SAC2FN_FILE_OPEN, (Throwable)IOEx);
        }
    }

    public boolean isAPDictionary() {
        return this.m_isAPDictionary;
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int caseNum) {
        return this.privateGetAlternateGeoBases(pa, preferences, caseNum);
    }

    private IGeoBase[] privateGetAlternateGeoBases(Address pa, IConstraints preferences, int caseNum) {
        String areaName3 = DEU_ParsePostAddressRule.removeCommonWords(this.cleanAreaNameString(pa.getAreaName3()));
        String areaName4 = DEU_ParsePostAddressRule.removeCommonWords(this.cleanAreaNameString(pa.getAreaName4()));
        if (!(areaName3 != null && areaName3.length() != 0 || areaName4 != null && areaName4.length() != 0)) {
            return null;
        }
        MiSoundexKey key = (MiSoundexKey)soundex.getSoundex(areaName3);
        boolean bStringKey = new Boolean(preferences.getCustomString("KEY_GEOBASE_STRING_ONLY"));
        boolean forGeographicCentroid = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID));
        List alternatesList = new ArrayList();
        boolean bAreaName4 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4));
        switch (caseNum) {
            case 0: {
                if (forGeographicCentroid || !bStringKey) break;
                preferences.removeCustomObject((Object)"KEY_GEOBASE_STRING_ONLY");
                IGeoBase[] altBases = this.getGeoBases(pa, preferences);
                preferences.setCustomString("KEY_GEOBASE_STRING_ONLY", "true");
                if (altBases == null) break;
                return altBases;
            }
            case 1: {
                IGeoBase[] altBases;
                if (!forGeographicCentroid && areaName4 == null && preferences.getCustomObject((Object)KEY_GEOBASE_FOR_AREA4) == null) {
                    preferences.setCustomString(KEY_GEOBASE_FOR_AREA4, "true");
                    altBases = this.getGeoBases(pa, preferences);
                    preferences.removeCustomObject((Object)KEY_GEOBASE_FOR_AREA4);
                    if (altBases != null) {
                        return altBases;
                    }
                }
            }
            case 2: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 32, alternatesList);
                break;
            }
            case 3: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 1, alternatesList);
                break;
            }
            case 4: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 16, alternatesList);
                break;
            }
            case 5: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 8, alternatesList);
                break;
            }
            case 6: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 2, alternatesList);
                break;
            }
            case 7: {
                alternatesList = soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 4, alternatesList);
                break;
            }
            default: {
                return null;
            }
        }
        if (alternatesList == null || alternatesList.size() == 0) {
            return null;
        }
        int size = alternatesList.size();
        Object[] objs = alternatesList.toArray();
        if (forGeographicCentroid) {
            MiSoundexGeoBase[] retvals = new MiSoundexGeoBase[size];
            for (int j = 0; j < size; ++j) {
                retvals[j] = new MiSoundexGeoBase((MiSoundexKey)objs[j]);
            }
            return retvals;
        }
        IGeoBase[] retvals = new EMEA_GeoBase[size];
        for (int j = 0; j < size; ++j) {
            retvals[j] = bAreaName4 ? new EMEA_GeoBase((MiSoundexKey)objs[j], 4) : new EMEA_GeoBase((MiSoundexKey)objs[j], 3);
        }
        return retvals;
    }

    @Override
    protected CollationKeyGenerator getCollationKeyGenerator() {
        return m_collationKeyGenerator;
    }

    @Override
    protected Soundex getSoundex() {
        return m_soundex;
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String mainAddrItem = addr.getMainAddress();
        if (mainAddrItem == null || mainAddrItem.length() == 0) {
            return null;
        }
        if (DEU_AddressUtils.isEmpty(mainAddrItem)) {
            return null;
        }
        String browseStrKey = DEU_AddressUtils.getFormattedStreetAddress(addr, false).toUpperCase();
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        if (DEU_AddressUtils.isEmpty(addr.getPlaceName())) {
            return null;
        }
        String browseStrKey = addr.getPlaceName().trim();
        if (DEU_AddressUtils.isEmpty(browseStrKey)) {
            return null;
        }
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
    }

    private MapMarkerBrowseMultiLevelIndexKey createBrowseIndexKey(String browseStrKey) {
        char c = DEU_ScoringHelper.getFirstNormChar(browseStrKey);
        int[] collationKey1 = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        return new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey1);
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        String origStr = addr.getMainAddress();
        ISoundexKey origKey = soundex.getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)KEY_DEU_ALTERNATE_SOUNDEX_CODES);
        int altTypes = 0;
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        List alternates = new ArrayList<ISoundexKey>();
        alternates.add(origKey);
        alternates = soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        int size = alternates.size();
        Object[] objs = alternates.toArray();
        ISoundexKey[] retvals = new ISoundexKey[size];
        for (int i = 0; i < size; ++i) {
            retvals[i] = (ISoundexKey)objs[i];
        }
        return retvals;
    }

    private String cleanAreaNameString(String areaName) {
        if (areaName == null || areaName.length() == 0) {
            return null;
        }
        int pos = areaName.indexOf(40);
        if (pos > 0) {
            String newAreaName = areaName.substring(0, pos).trim();
            return newAreaName;
        }
        if (StringUtilities.hasNumeric((String)areaName)) {
            StringBuffer newAreaName = new StringBuffer(areaName.length());
            for (int i = 0; i < areaName.length(); ++i) {
                if (StringUtilities.isNumeric((String)areaName.substring(i, i + 1))) {
                    newAreaName.append(" ");
                    continue;
                }
                newAreaName.append(areaName.charAt(i));
            }
            areaName = newAreaName.toString();
        }
        return areaName;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new DEU_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null, this.m_isAPDictionary);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        return new DEU_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null, this.m_isAPDictionary);
    }

    @Override
    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        DEU_DictionaryGeographyInfo info = new DEU_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        String[] streetDataFileNames = this.getStreetDataFileNames();
        if (streetDataFileNames != null && streetDataFileNames.length > 0) {
            info.setHasStreets(true);
            info.setHasCentroids(true);
        }
        if (this.isUserDictionary()) {
            info.setIsUserDictionary(true);
        } else {
            info.setIsUserDictionary(false);
        }
        if (this.m_isAPDictionary) {
            info.setIsAPDictionanry(true);
        } else {
            info.setIsAPDictionanry(false);
        }
        return info;
    }

    public int[] getSacList(Address addr, IConstraints constraints, boolean bDoIntersectionOnly) {
        int[] saclist = super.getSacList(addr, constraints, bDoIntersectionOnly);
        DEU_Constraints deuConstraints = (DEU_Constraints)constraints;
        if (saclist != null && saclist.length > 0) {
            HashSet<Integer> foundSacs = new HashSet<Integer>();
            for (int sac : saclist) {
                foundSacs.add(sac);
            }
            Set<Integer> ignoredSacs = deuConstraints.getIgnoredSacs();
            if (ignoredSacs != null) {
                foundSacs.removeAll(ignoredSacs);
            }
            if (foundSacs.size() > 0) {
                Set<Integer> searchedSacs = deuConstraints.getSearchedSacs();
                if (searchedSacs == null) {
                    deuConstraints.setSearchedSacs(foundSacs);
                } else {
                    searchedSacs.addAll(foundSacs);
                }
            }
            saclist = new int[foundSacs.size()];
            int i = 0;
            for (Integer filteresSac : foundSacs) {
                saclist[i++] = filteresSac;
            }
        }
        return saclist;
    }
}

