/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.DEU_StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_DataDictionary;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.DEU.licensing.DEULicenseFilter;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataManager;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexKey;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public final class DEU_DataManager
extends EMEA_DataManager {
    private static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    private static final String ERROR_LOAD_DICT_MSG = "exception.error.reading.dictionaries";
    private static Soundex soundex = new DEUGermanSoundex();
    private static double STREET_FILTER_SCORE_THRESHOLD_MAINADDRESS = 0.45;
    private static double STREET_FILTER_SCORE_THRESHOLD_PREADDRESS = 0.0;
    private static double STREET_FILTER_SCORE_THRESHOLD_POSTTT = 0.0;
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_POSTBASE_FOR_POSTAL_CENTROID = "KEY_POSTBASE_FOR_POSTAL_CENTROID";
    public static final String KEY_DEU_ALTERNATE_SOUNDEX_CODES = "KEY_DEU_ALTERNATE_SOUNDEX_CODES";
    public static final String KEY_GEOBASE_FOR_POSTTOWN_ONLY = "KEY_GEOBASE_FOR_POSTTOWN_ONLY";
    public static final String KEY_STREETS_TO_REMOVE = "KEY_STREETS_TO_REMOVE";
    public static final String KEY_GEOBASE_STRING_ONLY = "KEY_GEOBASE_STRING_ONLY";
    public static final String KEY_GEOBASE_FOR_AREA2 = "KEY_GEOBASE_FOR_AREA2";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_IGNORE_NO_SAC_ERROR = "KEY_IGNORE_NO_SAC_ERROR";
    private static Throwable m_SetupException;
    public static final String KEY_POSTALBASE_FOR_POSTCODE_FALLBACK = "KEY_POSTALBASE_FOR_POSTCODE_FALLBACK";
    public final short GEOBASE_AREA1_FLAG = (short)2;
    private DEU_StreetCandidateAddressFilter m_DEUstreetFilter;
    static IDataDictionary[] m_dataDicts;
    static int m_numDicts;
    static Properties m_DataResources;
    public static final String KEY_SAC_ERROR_HAS_OCCURED = "KEY_SAC_ERROR_HAS_OCCURED";
    public static final String KEY_SUCCESS_HAS_OCCURED = "KEY_SUCCESS_HAS_OCCURED";
    public static final String KEY_SET_SAC_ERROR = "KEY_SET_SAC_ERROR";
    private static LicenseFilter m_licenseFilter;

    public DEU_DataManager() throws MMJEDataManagerInitializationException {
        if (m_SetupException != null) {
            if (m_SetupException instanceof MMLicenseException) {
                throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
            }
            ResourceBundle rb = DEU_DataManager.loadBundleForLocale(null, (String)LSTRING_FILE);
            throw new MMJEDataManagerInitializationException(rb.getString(ERROR_LOAD_DICT_MSG));
        }
    }

    public void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                this.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            DEU_DataManager.start();
            if (m_SetupException != null) {
                throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
            }
        }
    }

    private void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            dict.close();
            DEU_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public MapMarkerIndexKey makeGeoInfoIndexKey(IGeoBase geoBase) {
        MiSoundexGeoBase base = (MiSoundexGeoBase)geoBase;
        return new MiSoundexIndexKey((MiSoundexKey)base);
    }

    public static ArrayList getGeoInfoAlias(String strGeoKey, String strPostCode, int dictNum) {
        DEU_GeoInfoFetcherImpl geoFetcher = (DEU_GeoInfoFetcherImpl)((DEU_DataDictionary)m_dataDicts[dictNum]).getGeoInfoFetcher();
        return geoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(strGeoKey, strPostCode));
    }

    public IRetrievedCandidates privateRetrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        DataAccessException streetCandidateException = null;
        DataAccessException altStreetCandidateException = null;
        ResourceBundle rb = null;
        int[] saclist = null;
        boolean bSacsMustmatchGeoAndPostal = "true".equalsIgnoreCase(preferences.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL"));
        ArrayList candList = new ArrayList();
        int debugLevel = DebugLevel.getDebugLevel((int)3);
        boolean foundUsableDictionary = false;
        IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
        IDataDictionary dict = null;
        AbstractDataManager.DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        int ctr = 0;
        while (dictIterator.hasNext()) {
            if (order != null && !order.isDictionaryAvailableForSearch(ctr + 1)) {
                ++ctr;
                continue;
            }
            AbstractDataManager.Dictionary dictionary = dictIterator.next();
            dict = dictionary.getDictionary();
            this.assignInternalDictionaryPrefrence(dict, preferences);
            ++ctr;
            if ((!dict.isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.AD_ONLY) && (dict.isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.UD_ONLY)) continue;
            foundUsableDictionary = true;
            boolean poi_op = pa.getPlaceName() != null;
            ISoundexKey[] streetbases = null;
            AlternateSearchTypeKey[] alternateBases = null;
            streetbases = dict.makeStreetBases(pa, preferences);
            if (poi_op) {
                alternateBases = dict.getAlternateSearchTypeKeys(pa, preferences);
            }
            if ((streetbases == null || streetbases.length == 0) && (alternateBases == null || alternateBases.length == 0) || (saclist = dict.getSacList(pa, preferences, bSacsMustmatchGeoAndPostal)).length == 0) continue;
            if (streetbases != null) {
                try {
                    candList.addAll(this.getStreetCandidates(streetbases, saclist, preferences, dict, debugLevel, scoringAddress));
                }
                catch (DataAccessException e) {
                    streetCandidateException = e;
                }
            }
            if (alternateBases == null) continue;
            try {
                candList.addAll(this.getAlternateStreetCandidates(alternateBases, saclist, preferences, dict, debugLevel, scoringAddress));
            }
            catch (DataAccessException e) {
                altStreetCandidateException = e;
            }
        }
        if (candList == null || candList.isEmpty()) {
            if (streetCandidateException != null) {
                throw streetCandidateException;
            }
            if (altStreetCandidateException != null) {
                throw altStreetCandidateException;
            }
            if (!foundUsableDictionary) {
                throw new DataAccessException(2103);
            }
        }
        if (debugLevel >= 3) {
            if (rb == null) {
                rb = DEU_DataManager.loadBundleForLocale((IConstraints)preferences, (String)LSTRING_FILE);
            }
            MMJLog.getLog().debug(rb.getString("info.returning.candidates") + candList.size());
        }
        if ((result = this.buildRetrievedCandidates(candList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 0)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    @Override
    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates;
        try {
            retCandidates = this.privateRetrieveCandidates(pa, scoringAddress, preferences);
        }
        catch (DataAccessException e) {
            if (e.getErrorCode() == 2104) {
                retCandidates = new CoreRetrievedCandidates(new ArrayList());
            }
            throw e;
        }
        return retCandidates;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("DEU");
    }

    protected LicenseFilter getLicenseFilter() {
        return m_licenseFilter;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    private static void start() {
        m_SetupException = null;
        try {
            m_DataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("DEU");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_DataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new DEU_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    DEU_DataManager.m_dataDicts[i] = new DEU_DataDictionary(i, m_DataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_SetupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        try {
            m_licenseFilter = new DEULicenseFilter();
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
    }

    public ISoundexKey[] getStreetBases(int dictNum, Address pa, IConstraints preferences) {
        return this.privateGetStreetBases(dictNum, pa, preferences);
    }

    private ISoundexKey[] privateGetStreetBases(int dictNum, Address pa, IConstraints preferences) {
        String origStr = pa.getMainAddress();
        ISoundexKey origKey = soundex.getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        Integer tmp = new Integer(preferences.getCustomString(KEY_DEU_ALTERNATE_SOUNDEX_CODES));
        int altTypes = 0;
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        List alternates = new ArrayList<ISoundexKey>();
        alternates.add(origKey);
        alternates = soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        int size = alternates.size();
        Object[] objs = alternates.toArray();
        ISoundexKey[] retvals = new ISoundexKey[size];
        for (int i = 0; i < size; ++i) {
            retvals[i] = (ISoundexKey)objs[i];
        }
        return retvals;
    }

    public IPostalBase[] getPostalBases(int dictNum, Address pa, IConstraints preferences) {
        String postcode = pa.getPostCode1();
        if (postcode != null) {
            IPostalBase[] retvals = new IPostalBase[1];
            boolean forPostalCentroid = new Boolean(preferences.getCustomString(KEY_POSTBASE_FOR_POSTAL_CENTROID));
            if (forPostalCentroid) {
                retvals[0] = new StandardPostalBase(postcode.trim());
            } else if (postcode.trim().length() > 2) {
                retvals[0] = new StandardPostalBase(postcode.trim().substring(0, 3));
            } else {
                return null;
            }
            return retvals;
        }
        return null;
    }

    public PostInfoIndexKey makePostInfoIndexKey(IPostalBase base) {
        return new StandardPostInfoIndexKey((StandardPostalBase)base);
    }

    public long[] getGeoInfoSearchPositions(MapMarkerIndexValue indexValue) {
        MapMarkerIndexMultiValue value = (MapMarkerIndexMultiValue)indexValue;
        int count = value.getValueCount();
        long[] returnArray = new long[count];
        for (int i = 0; i < count; ++i) {
            returnArray[i] = value.getOffsetAt((short)i);
        }
        return returnArray;
    }

    protected StreetCandidateAddressFilter getStreetFilter() {
        if (this.m_DEUstreetFilter == null) {
            FieldScores thresholds = new FieldScores();
            thresholds.setMainAddress(STREET_FILTER_SCORE_THRESHOLD_MAINADDRESS);
            thresholds.setPreAddress(STREET_FILTER_SCORE_THRESHOLD_PREADDRESS);
            thresholds.setPostThoroughfareType(STREET_FILTER_SCORE_THRESHOLD_POSTTT);
            this.m_DEUstreetFilter = new DEU_StreetCandidateAddressFilter(thresholds);
        }
        return this.m_DEUstreetFilter;
    }

    public boolean hasAPDictionary() {
        for (int index = 0; index < m_dataDicts.length; ++index) {
            if (!((DEU_DataDictionary)m_dataDicts[index]).isAPDictionary()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSegmentedDictionary() {
        for (int index = 0; index < m_dataDicts.length; ++index) {
            if (((DEU_DataDictionary)m_dataDicts[index]).isAPDictionary() || m_dataDicts[index].isUserDictionary()) continue;
            return true;
        }
        return false;
    }

    private void assignInternalDictionaryPrefrence(IDataDictionary dictionary, IConstraints constraints) {
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        int dictionaryNumber = dictionary.getDictionaryNumber();
        int dictSearchOrderNum = -1;
        if (order != null) {
            dictSearchOrderNum = order.getSearchOrderForDictionary(dictionaryNumber + 1);
        }
        if (order == null && dictionaryNumber == 0 || order != null && dictSearchOrderNum == 1) {
            String inputedAddressNumber = constraints.getHandler().getParsedAddress().getAddressNumber();
            DEU_Constraints inconstraints = (DEU_Constraints)constraints;
            DEU_DataDictionary inDictionary = (DEU_DataDictionary)dictionary;
            boolean inputHasNumber = false;
            if (StringUtilities.hasNumeric((String)constraints.getHandler().getParsedAddress().getMainAddress())) {
                inputHasNumber = true;
            }
            if (inDictionary.isAPDictionary()) {
                if (inputedAddressNumber != null || inputHasNumber) {
                    inconstraints.setPreferAPDictionary(true);
                } else {
                    inconstraints.setPreferSegmentDictionary(true);
                }
            } else if (!inDictionary.isAPDictionary()) {
                inconstraints.setPreferSegmentDictionary(true);
            }
        }
    }

    public boolean hasUDDictionary() {
        for (int index = 0; index < m_dataDicts.length; ++index) {
            if (!((DEU_DataDictionary)m_dataDicts[index]).isUserDictionary()) continue;
            return true;
        }
        return false;
    }

    public IRetrievedCandidates retrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        LicenseFilter filter;
        int debugLevel = this.getDebugLevel(preferences);
        if (debugLevel >= 3) {
            MMJLog.getLog().debug("in retrieveGeoCentroid");
        }
        ArrayList candList = new ArrayList();
        int dictCount = this.getDictionaryCount();
        boolean foundUsableDictionary = false;
        AbstractDataManager.DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        boolean doSkipDictionary = false;
        int dictCounter = 0;
        try {
            while (dictIterator.hasNext()) {
                foundUsableDictionary = true;
                if (dictCount > 1 && dictCounter > 0) {
                    doSkipDictionary = true;
                }
                IDataDictionary dict = dictIterator.next().getDictionary();
                if (dictCount > 1 && dictCounter > 0) {
                    doSkipDictionary = true;
                }
                if (dict.getGeoInfoFetcher() == null || doSkipDictionary) continue;
                try {
                    List candidates = dict.getGeoInfoFetcher().getGeoInfoCandidates(pa, preferences);
                    if (candidates != null) {
                        IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
                        for (InternalGeographicCandidate candidate : candidates) {
                            if (dict.isUserDictionary()) {
                                candidate.setFromUserDictionary();
                            }
                            candidate.setDictionaryPriority(dict.getDictionaryNumber());
                            if (order != null) {
                                candidate.setUserDictionaryPriority(order.getSearchOrderForDictionary(dict.getDictionaryNumber() + 1));
                                continue;
                            }
                            candidate.setUserDictionaryPriority(dict.getDictionaryNumber() + 1);
                        }
                        candList.addAll(candidates);
                    }
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
                ++dictCounter;
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessException(2102, (Throwable)e);
        }
        if ((candList == null || candList.isEmpty()) && !foundUsableDictionary) {
            throw new DataAccessException(2103);
        }
        IRetrievedCandidates result = this.buildRetrievedCandidates(candList);
        if (result.getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 3)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    public IRetrievedCandidates retrievePostalCentroids(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        int debugLevel = this.getDebugLevel(preferences);
        if (debugLevel >= 3) {
            MMJLog.getLog().debug("in retrievePostalCentroids");
        }
        ResourceBundle rb = null;
        ArrayList candList = new ArrayList();
        int numDicts = this.getDictionaryCount();
        boolean foundUsableDictionary = false;
        AbstractDataManager.DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        boolean doSkipDictionary = false;
        int dictCounter = 0;
        int dictCount = this.getDictionaryCount();
        try {
            while (dictIterator.hasNext()) {
                foundUsableDictionary = true;
                IDataDictionary dict = dictIterator.next().getDictionary();
                if (dictCount > 1 && dictCounter > 0) {
                    doSkipDictionary = true;
                }
                if (dict.getPostInfoFetcher() == null || doSkipDictionary) continue;
                try {
                    List candidates = dict.getPostInfoFetcher().getPostInfoCandidates(pa, preferences);
                    if (candidates != null) {
                        IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
                        for (InternalPostalCandidate candidate : candidates) {
                            if (dict.isUserDictionary()) {
                                candidate.setFromUserDictionary();
                            }
                            candidate.setDictionaryPriority(dict.getDictionaryNumber());
                            if (order != null) {
                                candidate.setUserDictionaryPriority(order.getSearchOrderForDictionary(dict.getDictionaryNumber() + 1));
                                continue;
                            }
                            candidate.setUserDictionaryPriority(dict.getDictionaryNumber() + 1);
                        }
                        candList.addAll(candidates);
                    }
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
                ++dictCounter;
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessException(2102, (Throwable)e);
        }
        if ((candList == null || candList.isEmpty()) && !foundUsableDictionary) {
            throw new DataAccessException(2103);
        }
        if (debugLevel >= 2) {
            if (rb == null) {
                rb = DEU_DataManager.loadBundleForLocale((IConstraints)preferences, (String)LSTRING_FILE);
            }
            MMJLog.getLog().debug(rb.getString("info.returning.candidates") + candList.size());
        }
        if ((result = this.buildRetrievedCandidates(candList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 2)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    public IRetrievedCandidates retrieveBrowseAddresses(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        boolean foundStreetBaseForStreet = true;
        boolean foundStreetSac = true;
        DataAccessException browseException = null;
        DataAccessException altBrowseException = null;
        int[] sacList = null;
        boolean bSacsMustmatchGeoAndPostal = "true".equalsIgnoreCase(preferences.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL"));
        ArrayList browseList = new ArrayList();
        int debugLevel = DebugLevel.getDebugLevel((int)3);
        boolean foundUsableDictionary = false;
        AbstractDataManager.DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        boolean doSkipDictionary = false;
        int dictCounter = 0;
        int dictCount = this.getDictionaryCount();
        while (dictIterator.hasNext()) {
            foundUsableDictionary = true;
            IDataDictionary dict = dictIterator.next().getDictionary();
            if (dictCount > 1 && dictCounter > 0) {
                doSkipDictionary = true;
            }
            if (doSkipDictionary) continue;
            MapMarkerIndexKey[] browseBases = dict.makeBrowseBases(pa, preferences);
            AlternateSearchTypeKey[] alternateBases = dict.getAlternateBrowseTypeKeys(pa, preferences);
            if (browseBases == null && alternateBases == null) {
                foundStreetBaseForStreet = false;
                continue;
            }
            sacList = dict.getSacList(pa, preferences, bSacsMustmatchGeoAndPostal);
            if (sacList.length == 0) {
                foundStreetSac = false;
                continue;
            }
            if (browseBases != null) {
                try {
                    browseList.addAll(this.getBrowseAddresses(browseBases, sacList, preferences, dict, debugLevel));
                }
                catch (DataAccessException e) {
                    browseException = e;
                }
            }
            if (alternateBases != null) {
                try {
                    browseList.addAll(this.getAlternateBrowseAddresses(alternateBases, sacList, preferences, dict, debugLevel));
                }
                catch (DataAccessException e) {
                    altBrowseException = e;
                }
            }
            ++dictCounter;
        }
        if (browseList == null || browseList.size() == 0) {
            if (browseException != null) {
                throw browseException;
            }
            if (altBrowseException != null) {
                throw altBrowseException;
            }
            if (!foundStreetBaseForStreet) {
                throw new DataAccessException(2105);
            }
            if (!foundUsableDictionary) {
                throw new DataAccessException(2103);
            }
        }
        if ((result = this.buildRetrievedCandidates(browseList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 1)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    static {
        DEU_DataManager.start();
    }
}

