/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_InternalGeographicCandidate;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.DEU.dp.binary.index.DEU_GeoInfoIndexFile;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoSoundexIndexFile;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DEU_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    private DEU_GeoInfoIndexFile m_geoInfoStringIndex;
    private Soundex m_soundex = new DEUGermanSoundex();
    private static final int MAX_ALIAS_CACHE_SIZE = 10;
    private static DEU_AliasCachedItem[] m_aliasCachedItems = new DEU_AliasCachedItem[10];
    private static DEU_AliasCachedItem m_tempAliasCahcedItem;
    private boolean m_isAPCandiate;

    public DEU_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages, boolean isAPCandidate) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
        try {
            this.m_geoInfoStringIndex = new DEU_GeoInfoIndexFile();
            this.m_geoInfoStringIndex.open(StringUtilities.appendToPath((String)dataPath, (String)"geoinfo.jdx"));
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.data.geoinfo", (Throwable)e);
        }
        this.m_isAPCandiate = isAPCandidate;
        m_tempAliasCahcedItem = new DEU_AliasCachedItem(null, null);
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new DEU_GeoInfoPreLoadedDataHelper();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new EMEA_GeoInfoSoundexIndexFile();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        ArrayList<MiSoundexIndexKey> list = new ArrayList<MiSoundexIndexKey>();
        String areaName3 = addr.getAreaName3();
        if (areaName3 != null) {
            ISoundexKey area3shortCalcKey;
            String area3shortCalc;
            ISoundexKey firstArea3Key;
            String firstAreaName3;
            ISoundexKey area3Key = this.m_soundex.getSoundex(areaName3.trim());
            if (area3Key != null) {
                MiSoundexIndexKey key = new MiSoundexIndexKey((MiSoundexKey)area3Key);
                list.add(key);
            }
            if ((firstAreaName3 = this.getFirstName(areaName3)) != null && (firstArea3Key = this.m_soundex.getSoundex(firstAreaName3)) != null) {
                MiSoundexIndexKey firstKey = new MiSoundexIndexKey((MiSoundexKey)firstArea3Key);
                list.add(firstKey);
            }
            if (!(area3shortCalc = DEU_ParsePostAddressRule.removeCommonWords(areaName3)).equalsIgnoreCase(areaName3) && (area3shortCalcKey = this.m_soundex.getSoundex(area3shortCalc)) != null) {
                MiSoundexIndexKey shortKey = new MiSoundexIndexKey((MiSoundexKey)area3shortCalcKey);
                list.add(shortKey);
            }
        }
        this.removeDupedSoundexKey(list);
        MapMarkerIndexKey[] retvals = new MapMarkerIndexKey[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retvals[i] = (MapMarkerIndexKey)list.get(i);
        }
        return retvals;
    }

    public List getAltLangNameList(String town) {
        MiStringIndexKey stringIndexKey = new MiStringIndexKey(town);
        ArrayList<String> altLanguageNamesList = new ArrayList<String>();
        MapMarkerIndexMultiValue indexValue = null;
        try {
            indexValue = (MapMarkerIndexMultiValue)this.m_geoInfoStringIndex.search((MapMarkerIndexKey)stringIndexKey);
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (indexValue != null) {
            int loopiterator = indexValue.getValueCount();
            for (int i = 0; i < loopiterator; ++i) {
                long offset = indexValue.getOffsetAt((short)i);
                EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)this.getGeoInfoRecord(offset);
                String altLangName = record.getAltLanguageNames();
                if (altLangName == null || altLanguageNamesList.contains(altLangName)) continue;
                altLanguageNamesList.add(altLangName);
            }
        }
        return altLanguageNamesList;
    }

    public List getAltLangNames(String town) {
        return this.getAltLangNameList(town);
    }

    private String getFirstName(String name) {
        String result = null;
        StringTokenizer st = new StringTokenizer(name, " /-");
        if (st.countTokens() != 1) {
            result = st.nextToken();
        }
        return result;
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new DEU_InternalGeographicCandidate(this.m_isAPCandiate);
    }

    protected void removeDupedSoundexKey(ArrayList list) {
        if (list.size() < 2) {
            return;
        }
        TreeSet set = new TreeSet();
        set.addAll(list);
        if (list.size() != set.size()) {
            list.clear();
            list.addAll(set);
        }
    }

    private static DEU_AliasCachedItem findKeyItem(String searchkey) {
        for (int i = 0; i < 10; ++i) {
            DEU_AliasCachedItem aliasItem = m_aliasCachedItems[i];
            if (aliasItem == null) {
                return null;
            }
            if (!aliasItem.equalsKey(searchkey)) continue;
            return aliasItem;
        }
        return null;
    }

    public ArrayList getGeoInfoAlias(String key) {
        DEU_AliasCachedItem cachedItem = DEU_GeoInfoFetcherImpl.findKeyItem(key);
        if (cachedItem != null) {
            return cachedItem.getAliasList();
        }
        int nOffsets = 0;
        try {
            ArrayList<GeoInfoRecord> aliasList = new ArrayList<GeoInfoRecord>();
            MiStringIndexKey stringIndexKey = new MiStringIndexKey(key);
            MapMarkerIndexValue indexValue = this.m_geoInfoStringIndex.search((MapMarkerIndexKey)stringIndexKey);
            long[] geoOffsets = super.getGeoInfoIndexOffsets(indexValue);
            nOffsets = geoOffsets == null ? 0 : geoOffsets.length;
            for (int i = 0; i < nOffsets; ++i) {
                aliasList.add(this.getGeoInfoRecord(geoOffsets[i]));
            }
            DEU_GeoInfoFetcherImpl.addIntoAliasCache(key, aliasList);
            return aliasList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addIntoAliasCache(String key, ArrayList aliasList) {
        DEU_AliasCachedItem newAliasItem = m_tempAliasCahcedItem.createNewItem(key, aliasList);
        for (int i = 8; i >= 0; --i) {
            DEU_GeoInfoFetcherImpl.m_aliasCachedItems[i + 1] = m_aliasCachedItems[i];
        }
        DEU_GeoInfoFetcherImpl.m_aliasCachedItems[0] = newAliasItem;
    }

    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        ArrayList candidates = (ArrayList)super.getGeoInfoCandidates(addr, constraints);
        if (candidates != null) {
            int size = candidates.size();
            for (int i = size - 1; i >= 0; --i) {
                EMEA_InternalGeographicCandidate candidate = (EMEA_InternalGeographicCandidate)((Object)candidates.get(i));
                if (candidate.getPrecision() != 0) continue;
                candidates.remove(i);
            }
            candidates.trimToSize();
        }
        return candidates;
    }

    public void close() throws DataAccessException {
        super.close();
        if (this.m_geoInfoStringIndex != null) {
            try {
                this.m_geoInfoStringIndex.close();
                this.m_geoInfoStringIndex = null;
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102, (Throwable)IOEx);
            }
        }
    }

    public DEU_GeoInfoIndexFile getgeoinfoIndexFileHandle() {
        return this.m_geoInfoStringIndex;
    }

    class DEU_AliasCachedItem {
        private String key;
        private ArrayList aliasList;

        public DEU_AliasCachedItem(String key, ArrayList alias) {
            this.key = key;
            this.aliasList = alias;
        }

        public ArrayList getAliasList() {
            return this.aliasList;
        }

        public boolean equalsKey(String inkey) {
            if (inkey != null) {
                return inkey.equals(this.key);
            }
            return false;
        }

        public DEU_AliasCachedItem createNewItem(String key, ArrayList aliasList) {
            return new DEU_AliasCachedItem(key, aliasList);
        }
    }
}

