/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnRecord;
import com.mapinfo.mapmarker.utils.IntObjMap;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class DEU_MMJSac2FnData
extends MMJSac2FnData {
    public static final String SAC2FN_AP_FILE_NAME = "sac2fn_ap.mmj";
    public static final String SAC2FN_UD_AP_FILE_NAME = "sac2fn_ud_ap.mmj";
    private boolean m_isAPDictionary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DEU_MMJSac2FnData(String dataPath) throws IOException {
        String sac2fnFileName = this.buildSac2FnFileName(dataPath);
        FilterInputStream in = null;
        try {
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(sac2fnFileName)));
                IntObjMap map = this.getMap();
                while (true) {
                    MMJSac2FnRecord record = MMJSac2FnRecord.read((DataInput)((Object)in));
                    map.put(record.getSac(), (Object)record.getData());
                }
            }
            catch (EOFException eOFException) {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                in.close();
            }
            throw throwable;
        }
    }

    public String buildSac2FnFileName(String dataPath) {
        String sac2fnFileName = StringUtilities.appendToPath((String)dataPath, (String)"sac2fn.mmj");
        File sac2FnFile = new File(sac2fnFileName);
        if (!sac2FnFile.exists()) {
            sac2fnFileName = StringUtilities.appendToPath((String)dataPath, (String)"sac2fn_ud.mmj");
            sac2FnFile = new File(sac2fnFileName);
            if (!sac2FnFile.exists()) {
                sac2fnFileName = StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_UD_AP_FILE_NAME);
                sac2FnFile = new File(sac2fnFileName);
                if (!sac2FnFile.exists()) {
                    sac2fnFileName = StringUtilities.appendToPath((String)dataPath, (String)SAC2FN_AP_FILE_NAME);
                    this.m_isAPDictionary = true;
                } else {
                    this.setForUserDictionary(true);
                    this.m_isAPDictionary = true;
                }
            } else {
                this.setForUserDictionary(true);
            }
        }
        return sac2fnFileName;
    }

    public boolean isAPDictionary() {
        return this.m_isAPDictionary;
    }

    protected boolean forUserDictionary() {
        return super.forUserDictionary();
    }
}

