/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.intermediate.ap;

import com.mapinfo.mapmarker.DEU.dp.binary.ap.DEU_MMJAPRangeRecord;
import com.mapinfo.mapmarker.DEU.dp.intermediate.DEU_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;

public class DEU_APIntermediateStreetDataFileFormatHandler
extends DEU_IntermediateStreetDataFileFormatHandler {
    public DEU_APIntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        try {
            super.convertRangeRecord2DataItem(record, item);
            item.putByte(3, ((DEU_MMJAPRangeRecord)record).getPositionAccuracy());
            item.putLong(4, ((DEU_MMJAPRangeRecord)record).getPoinID());
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        try {
            super.convertRangeDataItem2Record(record, item);
            DEU_MMJAPRangeRecord rangeRecord = (DEU_MMJAPRangeRecord)record;
            if (item.hasByte(3)) {
                rangeRecord.setPositionAccuracy(item.getByte(3));
            }
            if (item.hasLong(4)) {
                rangeRecord.setPoinID(item.getLong(4));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new DEU_MMJAPRangeRecord();
    }
}

