/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.ud.tab;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.DEU_ScoringHelper;
import com.mapinfo.mapmarker.DEU.dp.DEU_DataConstructionParser;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MMJDataWriter;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_StreetBuilder;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_TabDataProvider;
import com.mapinfo.mapmarker.DEU.dp.binary.ap.DEU_APStreetBuilder;
import com.mapinfo.mapmarker.DEU.dp.binary.index.DEU_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.DEU.dp.intermediate.DEU_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.DEU.dp.intermediate.ap.DEU_APIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.DEU.dp.tab.DEU_APTabStreetDataHandler;
import com.mapinfo.mapmarker.DEU.dp.ud.DEU_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.DEU.dp.ud.tab.DEU_UDGeoInfoDataHandler;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.EMEA.dp.tab.EMEA_TabStreetDataHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Locale;
import java.util.Properties;

public class DEU_TabUDDataProvider
extends AbstractUDDataProvider {
    private static GeoInfoSoundexIndexer m_GeoInfoSoundexIndexer = null;
    private DEU_TabDataProvider m_tabDataProvider = new DEU_TabDataProvider(true);
    private String m_geoInfoPathAndBaseName;
    private DEU_UDStreetDataSourceRecordConvertor m_DEUStreetRecordConverter = null;
    private boolean m_APStreetData;
    private static final int DATATYPE_USER_DICTIONARY = 10;

    public DEU_TabUDDataProvider() {
        this.m_dataWriter = new DEU_MMJDataWriter((IDataProvider)this);
    }

    @Override
    public MMJComplexDataFileMetadata getGeoInfoMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metadata = this.m_tabDataProvider.getGeoInfoMetadata();
        metadata.setDataFileMasks(this.getGeoInfoDataFileMasks());
        metadata.setVendorCode(10);
        return metadata;
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        if (m_GeoInfoSoundexIndexer == null) {
            m_GeoInfoSoundexIndexer = new DEU_GeoInfoSoundexIndexer();
            ((DEU_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.m_geoInfoPathAndBaseName);
        }
        return m_GeoInfoSoundexIndexer;
    }

    @Override
    public MMJComplexDataFileMetadata getPostInfoMetadata() throws DataCreationException {
        return null;
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_APStreetData = this.identifyDicationary(processingProperties);
        this.m_dataBuilder = new DEU_StreetBuilder(processingProperties, this.m_APStreetData);
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_postInfoDataHandler = null;
        this.m_geoInfoDataHandler = new DEU_UDGeoInfoDataHandler();
        DEU_Constraints constraints = new DEU_Constraints();
        constraints.setDataConstructionConstraint(true);
        this.m_DEUStreetRecordConverter = new DEU_UDStreetDataSourceRecordConvertor(processingProperties, (UDPost2SacDataHandler)this.m_post2sacDataHandler, (UDGeo2SacDataHandler)this.m_geo2sacDataHandler, new DEUGermanSoundex(), new CollationKeyGenerator(new Locale("de", "DEU"), DEU_ScoringHelper.getCollationRules()), new DEU_DataConstructionParser(), constraints, (DEU_UDGeoInfoDataHandler)this.m_geoInfoDataHandler, this.m_APStreetData);
        String tempStreetFileFullName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"street.tmp");
        if (!this.m_APStreetData) {
            this.m_streetDataHandler = new EMEA_TabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)this.m_DEUStreetRecordConverter, (IIntermediateDataHandler)new DEU_IntermediateStreetDataFileFormatHandler(tempStreetFileFullName), new DEU_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        } else {
            this.m_dataBuilder = new DEU_APStreetBuilder(processingProperties, this.m_APStreetData);
            this.m_streetDataHandler = new DEU_APTabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)this.m_DEUStreetRecordConverter, (IIntermediateDataHandler)new DEU_APIntermediateStreetDataFileFormatHandler(tempStreetFileFullName), new DEU_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        String geoUDFilePath = processingProperties.getProperty("geoInfo_outputFilePath");
        this.m_geoInfoPathAndBaseName = geoUDFilePath + File.separator + "geoinfo";
    }

    private boolean identifyDicationary(Properties processingsProperties) {
        boolean isAP = false;
        String hasLefStartthsnum = processingsProperties.getProperty("street_toLeft");
        String hasRightStarthsnum = processingsProperties.getProperty("street_toRight");
        String hasLeftEndhsnum = processingsProperties.getProperty("street_fromLeft");
        String hasRightEndhsnum = processingsProperties.getProperty("street_fromRight");
        if (hasLefStartthsnum == null || hasRightStarthsnum == null || hasLeftEndhsnum == null || hasRightEndhsnum == null) {
            isAP = true;
        }
        return isAP;
    }

    public void processStreets(boolean createStatistics) throws DataCreationException {
        try {
            super.processStreets(createStatistics);
        }
        finally {
            if (this.m_DEUStreetRecordConverter != null) {
                this.m_DEUStreetRecordConverter.close();
                this.m_DEUStreetRecordConverter = null;
            }
        }
    }

    @Override
    public void preProcessStreetDataSet() throws DataCreationException {
        super.preProcessStreetDataSet();
        ((EMEA_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.m_geoInfoPathAndBaseName);
    }

    @Override
    public void createOtherFiles() throws DataCreationException {
        super.copyOtherFiles();
    }

    private void convertGeoInfoIndexFile() throws DataCreationException {
        this.processGeoInfo(false);
        IndexFileConvertor geoInfoStandardConvertor = this.getExactMatchGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tdx", this.m_geoInfoPathAndBaseName + ".jdx");
        if (geoInfoStandardConvertor != null) {
            try {
                DataCreationLogger.getLogger().logStatus("Creating geoInfo exact index file.");
                geoInfoStandardConvertor.convert();
                DataCreationLogger.getLogger().logStatus("Finished creating geoInfo exact index file.");
            }
            catch (DataCreationException e) {
                throw new DataCreationException(400, (Throwable)e);
            }
        }
        this.deleteFile(this.m_geoInfoPathAndBaseName + ".tdx");
        GeoInfoSoundexIndexer indexer = this.getGeoInfoSoundexIndexer();
        if (indexer != null) {
            DataCreationLogger.getLogger().logStatus("Creating temporary geoInfo soundex index file.");
            indexer.processGeoInfoFile(this.m_geoInfoPathAndBaseName);
            DataCreationLogger.getLogger().logStatus("Finished creating temporary geoInfo soundex index file.");
            IndexFileConvertor geoInfoSoundexConvertor = this.getSoundexGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tsx", this.m_geoInfoPathAndBaseName + ".sdx");
            if (geoInfoSoundexConvertor != null) {
                try {
                    DataCreationLogger.getLogger().logStatus("Creating geoInfo soundex index file.");
                    geoInfoSoundexConvertor.convert();
                    this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
                    DataCreationLogger.getLogger().logStatus("Finished creating soundex geoInfo index file.");
                }
                catch (DataCreationException e) {
                    throw new DataCreationException(400, (Throwable)e);
                }
            } else {
                this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySupportingFiles(String source, String destination) throws FileNotFoundException, IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(destination).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public DataFileMasks getPostInfoDataFileMasks() {
        return null;
    }

    public DataFileMasks getGeoInfoDataFileMasks() {
        return new DataFileMasks();
    }

    public MMJComplexDataFileMetadata getStreetMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metaData = this.m_tabDataProvider.getStreetMetadata();
        metaData.setVendorCode(10);
        return metaData;
    }

    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new DEU_MiStringIndexFileConvertor(tempIndex, newIndex);
    }

    public boolean isAPDataProvider() {
        return this.m_APStreetData;
    }
}

