/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.licensing;

import com.mapinfo.mapmarker.DEU.DEU_InternalBrowseAddress;
import com.mapinfo.mapmarker.DEU.DEU_InternalCandidateAddress;
import com.mapinfo.mapmarker.DEU.DEU_InternalGeographicCandidate;
import com.mapinfo.mapmarker.DEU.DEU_InternalPostalCandidate;
import com.mapinfo.mapmarker.DEU.licensing.MMDEULicenseException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.licensing.MMLicensing;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.MMCustomConfiguration;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.scp.spi.License;
import com.mapinfo.scp.spi.LicenseDefinition;
import com.mapinfo.scp.spi.LicenseRequest;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DEULicenseFilter
extends LicenseFilter {
    private static final String FACTORY_CONFIG_FILE = "MMDEULicenseFactory.config";
    private static final String PROVIDER_CONFIG_FILE = "MMDEULicenseProvider.config";
    private static final String VERSION = "1.0";
    private static final String STREET_LIC_HEADER = "DEU street: ";
    private static final String POSTAL_LIC_HEADER = "DEU postal: ";
    private static final String GEOGRAPHIC_LIC_HEADER = "DEU geographic: ";
    private static final String FEATURE_PREFIX = "mapmarker.data.deu";
    private static final String STREET_SUFFIX = ".street";
    private static final String STREET_SUFFIX_AP = ".ap.street";
    private static final String POSTAL_SUFFIX = ".postal";
    private static final String POSTAL_SUFFIX_AP = ".ap.postal";
    private static final String GEOGRAPHIC_SUFFIX = ".geographic";
    private static final String GEOGRAPHIC_SUFFIX_AP = ".ap.geographic";
    private static final String AP_REQUEST = "AP_REQUEST";
    private static final String AP_REQUEST_GEOGRAPHIC = "AP_REQUEST_GEOGRAPHIC";
    private static final String AP_REQUEST_POSTAL = "AP_REQUEST_POSTAL";
    private static final String STANDARD_REQUEST = "STANDARD_REQUEST";
    private static final String STANDARD_REQUEST_GEOGRAPHIC = "STANDARD_REQUEST_GEOGRAPHIC";
    private static final String STANDARD_REQUEST_POSTAL = "STANDARD_REQUEST_POSTAL";
    private static final String BASIC_FEATURE = "mapmarker.data.emea.basic";
    private MMLicensing m_licenser;
    private Map<String, LicenseRequest> m_streetRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_streetAPRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_postalRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_geographicRequestMap = new HashMap<String, LicenseRequest>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DEULicenseFilter() throws MMLicenseException {
        URL providerURL;
        URL factoryURL;
        if (MMCustomConfiguration.getUseCustomProperties()) {
            factoryURL = FileUtilities.getUrlFromString((String)(MMCustomConfiguration.getConfigLocation() + FACTORY_CONFIG_FILE));
            providerURL = FileUtilities.getUrlFromString((String)(MMCustomConfiguration.getConfigLocation() + PROVIDER_CONFIG_FILE));
        } else {
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            factoryURL = cl.getResource(FACTORY_CONFIG_FILE);
            providerURL = cl.getResource(PROVIDER_CONFIG_FILE);
        }
        this.m_licenser = factoryURL == null || providerURL == null ? new MMLicensing() : new MMLicensing(factoryURL.toExternalForm(), providerURL.toExternalForm());
        LicenseRequest basicRequest = this.m_licenser.createLicenseRequest(BASIC_FEATURE, VERSION);
        License basicLicense = null;
        try {
            basicLicense = this.m_licenser.checkout(basicRequest);
            if (basicLicense == null) {
                throw new MMDEULicenseException(5200);
            }
        }
        finally {
            if (basicLicense != null) {
                this.m_licenser.checkin(basicLicense);
            }
        }
    }

    protected LicenseRequest buildRequest(ICandidate candidate, int mode) throws MapMarkerInternalException {
        switch (mode) {
            case 0: {
                DEU_InternalCandidateAddress candAddress = (DEU_InternalCandidateAddress)candidate;
                LicenseRequest request = null;
                request = candAddress.isAPCandidate() ? this.getAPStreetRequest(AP_REQUEST) : this.getStreetRequest(STANDARD_REQUEST);
                return request;
            }
            case 1: {
                DEU_InternalBrowseAddress candAddress = (DEU_InternalBrowseAddress)candidate;
                LicenseRequest request = null;
                request = candAddress.isAPCandidate() ? this.getAPStreetRequest(AP_REQUEST) : this.getStreetRequest(STANDARD_REQUEST);
                return request;
            }
            case 2: {
                DEU_InternalPostalCandidate postalCandiate = (DEU_InternalPostalCandidate)candidate;
                LicenseRequest request = null;
                request = postalCandiate.isAPCandidate() ? this.getAPPostalRequest(AP_REQUEST_POSTAL) : this.getPostalRequest(STANDARD_REQUEST_POSTAL);
                return request;
            }
            case 3: {
                DEU_InternalGeographicCandidate geoCandiate = (DEU_InternalGeographicCandidate)candidate;
                LicenseRequest request = null;
                request = geoCandiate.isAPCandidate() ? this.getAPGeographicRequest(AP_REQUEST_GEOGRAPHIC) : this.getGeographicRequest(STANDARD_REQUEST_GEOGRAPHIC);
                return request;
            }
        }
        throw new MMDEULicenseException(5201);
    }

    protected MMLicensing getLicenser() {
        return this.m_licenser;
    }

    public String[] getLicenseInformation() {
        StringBuffer streetLic = new StringBuffer(STREET_LIC_HEADER);
        StringBuffer postalLic = new StringBuffer(POSTAL_LIC_HEADER);
        StringBuffer geographicLic = new StringBuffer(GEOGRAPHIC_LIC_HEADER);
        LicenseDefinition[] defs = this.m_licenser.getAvailableLicenseDefinitions();
        if (defs.length > 0) {
            Arrays.sort(defs, new LicenseComparator());
            LicenseDefinition lastDef = null;
            for (int i = 0; i < defs.length; ++i) {
                LicenseDefinition def = defs[i];
                if (lastDef != null && lastDef.getLicenseFeature().getName().equals(def.getLicenseFeature().getName())) continue;
                String featureName = def.getLicenseFeature().getName();
                if (featureName.startsWith(FEATURE_PREFIX)) {
                    if (featureName.endsWith(STREET_SUFFIX_AP)) {
                        streetLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length()));
                        streetLic.append(", ");
                    } else if (featureName.endsWith(STREET_SUFFIX)) {
                        streetLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length()));
                        streetLic.append(", ");
                    } else if (featureName.endsWith(POSTAL_SUFFIX)) {
                        postalLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length()));
                        postalLic.append(", ");
                    } else if (featureName.endsWith(GEOGRAPHIC_SUFFIX)) {
                        geographicLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length()));
                        geographicLic.append(", ");
                    }
                }
                lastDef = def;
            }
            streetLic.setLength(streetLic.length() - 2);
            postalLic.setLength(postalLic.length() - 2);
            geographicLic.setLength(geographicLic.length() - 2);
        }
        return new String[]{streetLic.toString(), postalLic.toString(), geographicLic.toString()};
    }

    private LicenseRequest getStreetRequest(String licenseRequest) {
        LicenseRequest request = this.m_streetRequestMap.get(licenseRequest);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(STREET_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_streetRequestMap.put(licenseRequest, request);
        }
        return request;
    }

    private LicenseRequest getAPStreetRequest(String licenseRequest) {
        LicenseRequest request = this.m_streetAPRequestMap.get(licenseRequest);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(STREET_SUFFIX_AP);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_streetAPRequestMap.put(licenseRequest, request);
        }
        return request;
    }

    private LicenseRequest getAPGeographicRequest(String licenseRequest) {
        LicenseRequest request = this.m_streetAPRequestMap.get(licenseRequest);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(GEOGRAPHIC_SUFFIX_AP);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_streetAPRequestMap.put(licenseRequest, request);
        }
        return request;
    }

    private LicenseRequest getAPPostalRequest(String licenseRequest) {
        LicenseRequest request = this.m_streetAPRequestMap.get(licenseRequest);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(POSTAL_SUFFIX_AP);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_streetAPRequestMap.put(licenseRequest, request);
        }
        return request;
    }

    private LicenseRequest getGeographicRequest(String licenseRequest) {
        LicenseRequest request = this.m_geographicRequestMap.get(licenseRequest);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(GEOGRAPHIC_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_geographicRequestMap.put(licenseRequest, request);
        }
        return request;
    }

    private LicenseRequest getPostalRequest(String licenseRequest) {
        LicenseRequest request = this.m_postalRequestMap.get(licenseRequest);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(POSTAL_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_postalRequestMap.put(licenseRequest, request);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICandidate filterCandidate(ICandidate candidate, int mode) throws IllegalArgumentException {
        boolean licensed;
        if (mode > 3 || mode < 0) {
            throw new IllegalArgumentException();
        }
        if (this.needToFilter(candidate, mode)) {
            return candidate;
        }
        LicenseRequest request = null;
        try {
            request = this.buildRequest(candidate, mode);
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().debug("Unable to filter candidate.", (Throwable)e);
            return null;
        }
        MMLicensing licenser = this.getLicenser();
        if (licenser == null) {
            MMJLog.getLog().error("Null licensing object, unable to check license.");
            return null;
        }
        License license = null;
        try {
            license = licenser.checkout(request);
            licensed = license != null;
        }
        finally {
            if (license != null) {
                licenser.checkin(license);
            }
        }
        if (licensed) {
            return candidate;
        }
        return null;
    }

    private boolean needToFilter(ICandidate candidate, int mode) {
        switch (mode) {
            case 0: {
                return ((DEU_InternalCandidateAddress)candidate).fromUserDictionary();
            }
            case 1: {
                return ((DEU_InternalBrowseAddress)candidate).fromUserDictionary();
            }
            case 2: {
                return ((DEU_InternalPostalCandidate)candidate).fromUserDictionary();
            }
            case 3: {
                return ((DEU_InternalGeographicCandidate)candidate).fromUserDictionary();
            }
        }
        return false;
    }

    private class LicenseComparator
    implements Comparator {
        private LicenseComparator() {
        }

        public int compare(Object o1, Object o2) {
            LicenseDefinition def1 = (LicenseDefinition)o1;
            LicenseDefinition def2 = (LicenseDefinition)o2;
            int result = def1.getLicenseFeature().getName().compareTo(def2.getLicenseFeature().getName());
            if (result == 0) {
                result = def1.getLicenseFeature().getVersion().compareTo(def2.getLicenseFeature().getVersion());
            }
            return result;
        }
    }
}

