/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DEU_AddressTerm {
    private static final String KEY_COMMON_WORDS = "common-words";
    private static final String KEY_IGNORE_WORDS = "ignore-words";
    private static final String KEY_DIRECTIONALS = "directionals";
    private static final String ROMAN_NUMERAL_WORDS = "roman_numeral_words";
    private static Vector commonWords = null;
    private static Vector ignoreWords = null;
    private static Vector directionals = null;
    private static ArrayList multiWordAreaNames = null;
    private static char[] PUNCTUATION_CHARS = new char[]{'-', '_', '/', '\\', ',', '\"', '\''};
    private static char[] romanNumberChars = new char[]{'X', 'V', 'I', ' '};
    private static StringBuffer punctuationList = null;
    private static final String VALID_NUMERALS = "IVXLCDM";
    private static Properties diacritics;
    private static final long[] CORRESPONDING_VALUES;
    private static HashMap romanNumeralWordList;
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String regexPatternForPOBox = "(((\\b[P]\\s*\\.*\\s*(OST|O)\\.*\\s*\\.*\\s*(BOX))|(POST\\s*FACH))\\.*\\s*(NUMBER|NO|#)?\\.*\\s*\\d+)";
    private static Pattern pattern;

    public static boolean isIgnoreWord(String word) {
        if (word == null) {
            return false;
        }
        return ignoreWords != null && ignoreWords.contains(word.toUpperCase().trim());
    }

    public static boolean isCommonWord(String word) {
        if (commonWords == null || word == null || word.trim().length() == 0) {
            return false;
        }
        return commonWords.contains(word.trim().toUpperCase());
    }

    public static boolean isDirectional(String word) {
        if (word == null || word.trim().length() == 0 || directionals == null) {
            return false;
        }
        return directionals.contains(word.trim().toUpperCase());
    }

    public static String[] removeCommonWords(String str) {
        if (commonWords == null || str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer commonBuf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, ".- ");
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (!commonWords.contains(word.toUpperCase())) {
                buf.append(word);
                buf.append(' ');
                continue;
            }
            commonBuf.append(word);
            commonBuf.append(' ');
        }
        String[] ret = new String[2];
        String str1 = buf.toString().trim();
        ret[0] = str1.length() > 0 ? str1 : null;
        str1 = commonBuf.toString().trim();
        ret[1] = str1.length() > 0 ? str1 : null;
        return ret;
    }

    public static String removePunctuationChars(String inTerm, boolean flag) {
        StringBuffer tempString = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(inTerm, String.valueOf(PUNCTUATION_CHARS));
        while (tokens.hasMoreElements()) {
            tempString.append(tokens.nextElement());
            if (!flag) continue;
            tempString.append(' ');
        }
        return tempString.toString().trim();
    }

    private static void loadRomanNumeralWords(String key, String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (romanNumeralWordList == null) {
            romanNumeralWordList = new HashMap();
        }
        romanNumeralWordList.put(key.substring(ROMAN_NUMERAL_WORDS.length()), raw);
    }

    public static boolean isRomanNumber(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        int index = term.trim().lastIndexOf(".");
        if (index > 0) {
            term = term.substring(0, index - 1);
        }
        term = term.toUpperCase();
        char[] termChars = term.toCharArray();
        for (int i = 0; i < termChars.length; ++i) {
            int j;
            for (j = 0; j < romanNumberChars.length && termChars[i] != romanNumberChars[j]; ++j) {
            }
            if (j != romanNumberChars.length) continue;
            return false;
        }
        return true;
    }

    public static long convertRomanToLong(String romanNumerals) {
        long sum = 0L;
        long oldV = 0L;
        if (romanNumerals.equals("1")) {
            sum = 1L;
        } else {
            for (int k = romanNumerals.length() - 1; k >= 0; --k) {
                char c = romanNumerals.charAt(k);
                int pos = VALID_NUMERALS.indexOf(Character.toUpperCase(c));
                if (pos < 0) continue;
                long newV = CORRESPONDING_VALUES[pos];
                if (newV < oldV) {
                    newV = -newV;
                }
                sum += newV;
                oldV = newV;
            }
        }
        return sum;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isPunctuation(String term) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(term) > -1;
    }

    private static void loadPunctuations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (punctuationList == null) {
                punctuationList = new StringBuffer(raw.length());
            }
            punctuationList.append(raw);
        }
    }

    public static boolean isPunctuation(char ch) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(ch) > -1;
    }

    public static String isromanWord(String word) {
        if (romanNumeralWordList == null || word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)romanNumeralWordList.get(word);
    }

    public static String seperatePOBox(StringBuffer strBuffer) {
        Matcher matcher = pattern.matcher(strBuffer);
        if (matcher.find()) {
            int startPos = matcher.start();
            int endPos = matcher.end();
            strBuffer.replace(startPos, endPos, "");
        }
        return strBuffer.toString();
    }

    public static boolean areOnlyVowelsDifferent(String string1, String string2) {
        boolean areOnlyVowelChange = true;
        if (string1 != null && !"".equals(string1) && string2 != null && !"".equals(string2)) {
            char[] charArray2;
            String modified1 = string1.toUpperCase();
            String modified2 = string2.toUpperCase();
            char[] charArray1 = modified1.toCharArray();
            if (DEU_AddressTerm.shouldCondiationExecute(charArray1.length, (charArray2 = modified2.toCharArray()).length)) {
                int loopCounter = Math.min(charArray1.length, charArray2.length);
                for (int i = 0; i < loopCounter; ++i) {
                    char char1 = charArray1[i];
                    char char2 = charArray2[i];
                    if (char1 == char2 || DEU_AddressTerm.isVowel(char1) && DEU_AddressTerm.isVowel(char2)) continue;
                    areOnlyVowelChange = false;
                    break;
                }
            } else {
                areOnlyVowelChange = false;
            }
        }
        return areOnlyVowelChange;
    }

    private static boolean isVowel(char character) {
        switch (character) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldCondiationExecute(int stringLength1, int stringLength2) {
        int minLen;
        int maxLen = Math.max(stringLength1, stringLength2);
        return maxLen / (minLen = Math.min(stringLength1, stringLength2)) < 2;
    }

    public static boolean doesRomanWordExist(String word) {
        if (romanNumeralWordList == null || word == null || word.trim().length() == 0) {
            return false;
        }
        return romanNumeralWordList.containsValue(word);
    }

    private static void loadMultiWordAreaNames() {
        String filename = "DEU_MultiWordAreaNames.properties";
        try {
            InputStream in = DEU_AddressTerm.class.getResourceAsStream(filename);
            BufferedReader stream = new BufferedReader(new InputStreamReader(in));
            multiWordAreaNames = new ArrayList();
            String s = null;
            while ((s = stream.readLine()) != null) {
                s = DEU_AddressTerm.removeVowels(s);
                multiWordAreaNames.add(s.toUpperCase());
            }
        }
        catch (FileNotFoundException fx) {
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to read required files for DEU_Parser.");
        }
    }

    public static boolean isMultiWordAreaName(String word) {
        if (word == null) {
            return false;
        }
        return multiWordAreaNames.contains(DEU_AddressTerm.removeVowels(DEU_AddressTerm.removeDiacritics(word.toUpperCase())));
    }

    protected static void loadDiacritics() {
        String fileName = "com/mapinfo/mapmarker/DEU/parser/DEUSpecialCharacters.properties";
        try {
            diacritics = FileUtilities.loadProperties((String)fileName);
        }
        catch (FileNotFoundException fx) {
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to read required files for DEU_Parser.");
        }
    }

    public static String removeDiacritics(String s) {
        if (s == null || s.equalsIgnoreCase("")) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        char[] chars = s.toUpperCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            String tmp = String.valueOf(chars[i]);
            if (diacritics.containsKey(tmp)) {
                result.append(diacritics.getProperty(tmp));
                continue;
            }
            result.append(tmp);
        }
        if (result.toString().trim().length() > 0) {
            return result.toString().trim();
        }
        return null;
    }

    public static String removeVowels(String s) {
        if (s == null || s.equalsIgnoreCase("")) {
            return null;
        }
        char[] chars = s.toUpperCase().toCharArray();
        StringBuffer buff = new StringBuffer();
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': {
                    continue block3;
                }
                default: {
                    buff.append(chars[i]);
                }
            }
        }
        return buff.toString();
    }

    static {
        CORRESPONDING_VALUES = new long[]{1L, 5L, 10L, 50L, 100L, 500L, 1000L};
        romanNumeralWordList = null;
        pattern = Pattern.compile(regexPatternForPOBox, 2);
        try {
            DEU_AddressTerm.loadDiacritics();
            DEU_AddressTerm.loadMultiWordAreaNames();
            Properties prop = new Properties();
            prop.load(DEU_AddressTerm.class.getResourceAsStream("DEU_AddressTerms.properties"));
            commonWords = new Vector();
            ignoreWords = new Vector();
            directionals = new Vector();
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String word;
                StringTokenizer st;
                String value;
                String key = (String)e.nextElement();
                if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
                    DEU_AddressTerm.loadPunctuations(prop.getProperty(key));
                }
                if (key.startsWith(KEY_COMMON_WORDS)) {
                    value = (String)prop.get(key);
                    st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        word = st.nextToken().toUpperCase().trim();
                        commonWords.add(word);
                    }
                    continue;
                }
                if (key.startsWith(KEY_IGNORE_WORDS)) {
                    value = (String)prop.get(key);
                    st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        word = st.nextToken().toUpperCase().trim();
                        ignoreWords.add(word);
                    }
                    continue;
                }
                if (key.startsWith(KEY_DIRECTIONALS)) {
                    value = (String)prop.get(key);
                    st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        word = st.nextToken().toUpperCase().trim();
                        directionals.add(word);
                    }
                    continue;
                }
                if (!key.startsWith(ROMAN_NUMERAL_WORDS)) continue;
                DEU_AddressTerm.loadRomanNumeralWords(key, prop.getProperty(key));
            }
        }
        catch (Throwable t) {
            commonWords = null;
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
    }
}

