/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EMEA_AddressFilter {
    private static double ADDITIONAL_FIELD_THRESHOLD = 0.75;
    private static double ADDRESS_THRESHOLD = 0.75;
    private static double PERFECT_ADDITIONAL_FIELD_THRESHOLD = 0.9;
    private static double PERFECT_ADDRESS_THRESHOLD = 0.9;

    public static void filterAddresses(IConstraints constraints, GeocodeResult geocodeResult) {
        boolean removed;
        List candidates = constraints.getHandler().getMatchResults();
        if (candidates != null && candidates.size() > 0 && (removed = EMEA_AddressFilter.maybeFilterStreetCandidates(candidates) | EMEA_AddressFilter.maybeFilterPostalCandidates(candidates) | EMEA_AddressFilter.maybeFilterGeographicCandidates(candidates))) {
            EMEA_AddressFilter.countCandidates(candidates, geocodeResult);
            EMEA_AddressFilter.countCloseMatches(candidates, geocodeResult);
            ((ArrayList)candidates).trimToSize();
        }
    }

    private static boolean maybeFilterStreetCandidates(List candidates) {
        boolean removed = false;
        if (candidates.get(0) instanceof InternalCandidateAddress) {
            double combined;
            InternalCandidateAddress addr;
            double highest = 0.0;
            Iterator i = candidates.iterator();
            while (i.hasNext() && highest != 1.0) {
                InternalCandidateAddress addr2 = (InternalCandidateAddress)i.next();
                double temp = addr2.getCombinedAdditionalFieldScore();
                if (!(temp > highest)) continue;
                highest = temp;
            }
            double threshold = highest == 1.0 ? highest * PERFECT_ADDITIONAL_FIELD_THRESHOLD : highest * ADDITIONAL_FIELD_THRESHOLD;
            i = candidates.iterator();
            while (i.hasNext()) {
                addr = (InternalCandidateAddress)i.next();
                combined = addr.getCombinedAdditionalFieldScore();
                if (!(combined > 0.0) || !(threshold > combined)) continue;
                i.remove();
                removed = true;
            }
            highest = 0.0;
            i = candidates.iterator();
            while (i.hasNext() && highest != 1.0) {
                addr = (InternalCandidateAddress)i.next();
                double temp = addr.getCombinedAddressScore();
                if (!(temp > highest)) continue;
                highest = temp;
            }
            threshold = highest >= 0.9 ? highest * PERFECT_ADDRESS_THRESHOLD : highest * ADDRESS_THRESHOLD;
            i = candidates.iterator();
            while (i.hasNext()) {
                addr = (InternalCandidateAddress)i.next();
                combined = addr.getCombinedAddressScore();
                if (!(combined > 0.0) || !(threshold > combined)) continue;
                i.remove();
                removed = true;
            }
        }
        return removed;
    }

    private static boolean maybeFilterGeographicCandidates(List candidates) {
        return false;
    }

    private static boolean maybeFilterPostalCandidates(List candidates) {
        return false;
    }

    protected static void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null) {
            geocodeResult.setNumberCandidates(0);
        } else {
            geocodeResult.setNumberCandidates(candidateList.size());
        }
    }

    protected static void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList != null) {
            Iterator candidateIterator = candidateList.iterator();
            boolean done = false;
            while (candidateIterator.hasNext() && !done) {
                ICandidate candidate = (ICandidate)candidateIterator.next();
                if (candidate.isCloseMatch()) {
                    ++closeMatchCount;
                    continue;
                }
                done = true;
            }
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }
}

