/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.CoreMatcher;
import com.mapinfo.mapmarker.core.matcher.CoreMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class EMEA_MatcherHandler
implements IMatcherHandler {
    private CoreMatcherHandler m_coreHandler = new CoreMatcherHandler();
    private Comparator m_comparator;

    public EMEA_MatcherHandler() {
        this.setComparator(null);
    }

    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress parsedAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        candidate.computeScores(parsedAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = this.fieldExists(parsedAddress.getPlaceName()) ? (score += candidate.getPlaceNameScore() * matchedConstants.getPlaceName()) : (score += blankConstants.getPlaceName());
        score = this.fieldExists(parsedAddress.getPreAddress()) || this.fieldExists(candidate.getPreAddress()) ? (score += matchedConstants.getPreAddress() * candidate.getPreAddressScore()) : (score += blankConstants.getPreAddress());
        score = this.fieldExists(parsedAddress.getMainAddress()) || this.fieldExists(candidate.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
        score = this.fieldExists(parsedAddress.getPostAddress()) || this.fieldExists(candidate.getPostAddress()) ? (score += matchedConstants.getPostAddress() * candidate.getPostAddressScore()) : (score += blankConstants.getPostAddress());
        score = this.fieldExists(parsedAddress.getPreThoroughfareType()) || this.fieldExists(candidate.getPreThoroughfareType()) ? (score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore()) : (score += blankConstants.getPreThoroughfareType());
        score = this.fieldExists(parsedAddress.getPostThoroughfareType()) || this.fieldExists(candidate.getPostThoroughfareType()) ? (score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore()) : (score += blankConstants.getPostThoroughfareType());
        if (parsedAddress.hasAdditionalFields()) {
            score += matchedConstants.getAdditionalFields() * candidate.getAdditionalParserFieldsScore();
        }
        candidate.setCombinedAddressScore(score / this.getMaximumAddressScore());
        score = 0.0;
        score = this.fieldExists(parsedAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = this.fieldExists(parsedAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = this.fieldExists(parsedAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = this.fieldExists(parsedAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = this.fieldExists(parsedAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        candidate.setCombinedAdditionalFieldScore(score / this.getMaximumAdditionalFieldScore());
        candidate.buildInputMatchScore((Address)parsedAddress, matchedConstants);
    }

    public double getMaximumAddressScore() {
        return this.m_coreHandler.getMaximumAddressScore();
    }

    public double getMaximumAdditionalFieldScore() {
        return this.m_coreHandler.getMaximumAdditionalFieldScore();
    }

    public void setMaximumAddressScore(double value) {
        this.m_coreHandler.setMaximumAddressScore(value);
    }

    public void setMaximumAdditionalFieldScore(double value) {
        this.m_coreHandler.setMaximumAdditionalFieldScore(value);
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public List removeMultipleSegmentsForStreet(List candidates, IConstraints constraints) {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        if (constraints.isMatcherRemoveMultipleSegments()) {
            Collections.sort(candidates, this.getComparator());
            Collections.reverse(candidates);
            Iterator candidateIterator = candidates.iterator();
            boolean first = true;
            InternalCandidateAddress bestCandidateForStreet = null;
            while (candidateIterator.hasNext()) {
                if (first) {
                    bestCandidateForStreet = (InternalCandidateAddress)candidateIterator.next();
                    first = false;
                    continue;
                }
                InternalCandidateAddress candidate = (InternalCandidateAddress)candidateIterator.next();
                if (candidate.getStreetOffset() == bestCandidateForStreet.getStreetOffset()) {
                    if (this.removeSecondCandidate(bestCandidateForStreet, candidate)) {
                        candidateIterator.remove();
                        continue;
                    }
                    bestCandidateForStreet = candidate;
                    continue;
                }
                bestCandidateForStreet = candidate;
            }
            return candidates;
        }
        return candidates;
    }

    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        if (StringUtilities.equalStrings((String)best.getPostCode1(), (String)other.getPostCode1())) {
            if (best.getAreaName3() == null && other.getAreaName3() != null) {
                return false;
            }
            if (best.getAreaName3() != null && other.getAreaName3() == null) {
                return false;
            }
            if (best.getAreaName3() == null && other.getAreaName3() == null) {
                return true;
            }
            return best.getAreaName3().equals(other.getAreaName3());
        }
        return false;
    }

    public void computeMaximumAdditionalFieldScore(Address parsedAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = this.fieldExists(parsedAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1()) : (score += blankConstants.getAreaName1());
        score = this.fieldExists(parsedAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2()) : (score += blankConstants.getAreaName2());
        score = this.fieldExists(parsedAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3()) : (score += blankConstants.getAreaName3());
        score = this.fieldExists(parsedAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4()) : (score += blankConstants.getAreaName4());
        score = this.fieldExists(parsedAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1()) : (score += blankConstants.getPostalCode1());
        this.setMaximumAdditionalFieldScore(score);
    }

    protected boolean fieldExists(String val) {
        return CoreMatcher.fieldExists((String)val);
    }
}

