/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Map;

public class EMEA_ScoringAddress
extends ScoringAddress {
    StringScorer m_scorer = null;
    private static ItemsCachedScore[] m_scoreCache = new ItemsCachedScore[20];
    private static final int MAX_SCORE_CACHE = 20;

    public EMEA_ScoringAddress(Address addr) {
        super(addr);
    }

    public EMEA_ScoringAddress(AddressImpl impl, boolean bCacheArea1, boolean bCacheTypes, boolean bCachePrePost) {
        super((Address)new AddressImpl(), false, false, false);
    }

    public EMEA_ScoringAddress(Address addr, boolean bCacheArea1, boolean bCacheTypes, boolean bCachePrePost) {
        super(addr, false, false, false);
    }

    public StringScorer getStringScorer() {
        return this.m_scorer;
    }

    public void setStringScorer(StringScorer stringScorer) {
        this.m_scorer = stringScorer;
    }

    public double scoreItems(String str1, String str2) {
        return this.doScore(str1, str2, null, false);
    }

    protected double doScore(String str1, String str2, Map cache) {
        return this.doScore(str1, str2, cache, false);
    }

    protected double doScore(String str1, String str2, Map cache, boolean bNoShortWordBonus) {
        if (str1 == null) {
            if (str2 == null) {
                return 1.0;
            }
            return 0.0;
        }
        if (str2 == null) {
            return 0.0;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return 1.0;
        }
        ItemsCachedScore cachedScoreItem = this.findCachedScore(str1, str2);
        if (cachedScoreItem != null) {
            return cachedScoreItem.score;
        }
        String charsToIgnore = this.getCharsToIgnore();
        if (charsToIgnore != null && charsToIgnore.length() != 0) {
            str1 = StringUtilities.stripString((String)str1, (String)charsToIgnore);
            str2 = StringUtilities.stripString((String)str2, (String)charsToIgnore);
        }
        double score = this.getStringScorer().scoreString(str1, str2, bNoShortWordBonus);
        score = this.scoreExtensions(score, str1, str2, bNoShortWordBonus);
        this.addIntoScoreCache(str1, str2, score);
        return score;
    }

    public double scorePostCode1(String str) {
        String postcode = this.getPostCode1();
        ItemsCachedScore cachedScoreItem = this.findCachedScore(str, postcode);
        if (cachedScoreItem != null) {
            return cachedScoreItem.score;
        }
        double score = this.getStringScorer().scoreString(str, postcode, false);
        this.addIntoScoreCache(str, postcode, score);
        return score;
    }

    protected double scoreExtensions(double score, String str1, String srt2, boolean bNoShortWordBonus) {
        return score;
    }

    private ItemsCachedScore findCachedScore(String item1, String item2) {
        if (m_scoreCache != null) {
            for (int i = 0; i < 20; ++i) {
                ItemsCachedScore cachedScore = m_scoreCache[i];
                if (cachedScore == null) {
                    return null;
                }
                if (!cachedScore.equalItems(item1, item2)) continue;
                return cachedScore;
            }
        }
        return null;
    }

    private void addIntoScoreCache(String item1, String item2, double score) {
        if (m_scoreCache != null) {
            ItemsCachedScore cachedScore = new ItemsCachedScore(item1, item2, score);
            for (int i = 18; i >= 0; --i) {
                EMEA_ScoringAddress.m_scoreCache[i + 1] = m_scoreCache[i];
            }
            EMEA_ScoringAddress.m_scoreCache[0] = cachedScore;
        }
    }

    public double scoreStrings(String str1, String str2) {
        return this.doScore(str1, str2, null);
    }

    class ItemsCachedScore {
        private double score;
        private String firstItem;
        private String secondItem;

        public ItemsCachedScore(String item1, String item2, double score) {
            this.firstItem = item1;
            this.secondItem = item2;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public boolean equalItems(String item1, String item2) {
            return item1 != null && item1.equals(this.firstItem) && item2 != null && item2.equals(this.secondItem);
        }
    }
}

