/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_Geo2SacRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.InvalidRangeStatusDataSourceException;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Properties;

public abstract class EMEA_StreetDataSourceRecordConvertorImpl
extends StreetDataSourceRecordConvertorImpl {
    private boolean m_bLogParsingAddressNumberErrors;

    public EMEA_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        this(soundex, dataProperties, generator, parser, parserConstraints, false);
    }

    protected EMEA_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, boolean bLogParsingAddressNumberErrors) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
        this.m_bLogParsingAddressNumberErrors = bLogParsingAddressNumberErrors;
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new EMEA_Geo2SacRecord(sac, (EMEA_GeoBase)base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new EMEA_Geo2SacRecord();
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        return record;
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        Address parsedAddress = null;
        boolean validParse = false;
        for (int parserRetries = 0; !validParse && parserRetries <= this.m_maximumParserRetries; ++parserRetries) {
            parsedAddress = this.parseStreet(inputStreetAddress);
            validParse = this.validateParse(parsedAddress, inputStreetAddress, input, false, "100");
        }
        if (parsedAddress == null) {
            DataCreationLogger.getLogger().logInternalError("EMEA_StreetDataSourceRecordConvertorImpl:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        if (parsedAddress.getMainAddress() == null) {
            DataCreationLogger.getLogger().logInternalError("EMEA_StreetDataSourceRecordConvertorImpl:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.");
            return null;
        }
        return parsedAddress;
    }

    protected Address parseStreet(Address input) {
        input.setAreaName3("DummyTownName");
        Address addr = super.parseStreet(input);
        if (addr != null) {
            if (this.m_bLogParsingAddressNumberErrors && !"100".equals(addr.getAddressNumber())) {
                DataCreationLogger.getLogger().logInternalError("EMEA_StreetDataSourceRecordConvertorImpl::parseStreet -- 100 not returned as house number when parsing: " + input.getMainAddress());
            }
            addr.setAddressNumber((ParsedNumber)null);
            addr.setAreaName3(null);
        }
        return addr;
    }

    protected String makeMainAddressString(String street, String houseNumber) {
        if (houseNumber == null) {
            return street;
        }
        return street + " " + houseNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        if (this.m_bPointDataSource) return 0;
        if (this.isUDDataCreation()) return 0;
        String value = input.getStatus();
        if (value.equals("0")) return -1;
        if (value.equals("1")) {
            return -1;
        }
        if (value.equals("2")) {
            return 2;
        }
        if (value.equals("3")) {
            return 1;
        }
        if (value.equals("4")) {
            return 0;
        }
        if (!value.equals("5")) throw new InvalidRangeStatusDataSourceException(9, "The range will not be added as the range contains an unsupportedStruct field " + value);
        return 5;
    }

    protected ArrayList getKeyBases(Address address) {
        String postKey;
        String mainKey = address.getMainAddress().toUpperCase();
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(mainKey);
        String preKey = address.getPreAddress();
        if (preKey != null) {
            keys.add(preKey.toUpperCase());
        }
        if ((postKey = address.getPostAddress()) != null) {
            keys.add(postKey.toUpperCase());
        }
        return keys;
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        int inputSAC = leftSac != this.NO_SAC ? leftSac : rightSac;
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsed = this.getParsedStreet(input, preParsed);
        if (parsed == null) {
            return null;
        }
        String original_street = input.getMainAddress();
        if (!this.canReassembleAddress(original_street, parsed)) {
            parsed.setGenericField4(original_street);
        }
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setAddress(parsed);
        record.setSac(inputSAC);
        record.setKey(this.makeStreetSearchKey(parsed, inputSAC));
        if (record.getKey() == null) {
            DataCreationLogger.getLogger().logError("Could not generate a search key for address '" + input.getMainAddress() + "'");
            return null;
        }
        this.assignBrowseKeys(record);
        ISegmentDataSourceRecord inputSegment = input.getSegment();
        MMJSegmentRecord segment = this.convertSegmentRecord(inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        if (segment == null) {
            return null;
        }
        record.setSegment(segment);
        this.addRangesToSegment(segment, inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        this.populateAlternateDataItems(record, input, inputSAC);
        return record;
    }

    public boolean canReassembleAddress(String original_street, Address parsed) {
        return false;
    }

    protected boolean isUDDataCreation() {
        String createGeo2sac = this.m_dataProperties.getProperty("geo2sac_create");
        String createPost2sac = this.m_dataProperties.getProperty("post2sac_create");
        String createGeoinfo = this.m_dataProperties.getProperty("geoInfo_create");
        if (!(StringUtilities.isEmpty((String)createGeo2sac) || StringUtilities.isEmpty((String)createPost2sac) || StringUtilities.isEmpty((String)createGeoinfo))) {
            return "NO".equalsIgnoreCase(createGeo2sac) && "NO".equalsIgnoreCase(createPost2sac) && "NO".equalsIgnoreCase(createGeoinfo);
        }
        return false;
    }
}

