/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp.binary;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.ResourceBundle;

public abstract class EMEA_DataManager
extends AbstractDataManager {
    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        boolean foundStreetBase = true;
        boolean foundStreetSac = true;
        DataAccessException streetCandidateException = null;
        DataAccessException altStreetCandidateException = null;
        ResourceBundle rb = null;
        int[] saclist = null;
        boolean bSacsMustmatchGeoAndPostal = "true".equalsIgnoreCase(preferences.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL"));
        ArrayList candList = new ArrayList();
        int numDicts = this.getDictionaryCount();
        int debugLevel = DebugLevel.getDebugLevel((int)3);
        boolean foundUsableDictionary = false;
        IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
        IDataDictionary dict = null;
        for (int dictNum = 0; dictNum < numDicts; ++dictNum) {
            if (order != null && !order.isDictionaryAvailableForSearch(dictNum + 1) || (!(dict = this.getDictionary(dictNum)).isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.AD_ONLY) && (dict.isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.UD_ONLY)) continue;
            foundUsableDictionary = true;
            boolean poi_op = pa.getPlaceName() != null;
            ISoundexKey[] streetbases = null;
            AlternateSearchTypeKey[] alternateBases = null;
            streetbases = dict.makeStreetBases(pa, preferences);
            if (poi_op) {
                alternateBases = dict.getAlternateSearchTypeKeys(pa, preferences);
            }
            if (!(streetbases != null && streetbases.length != 0 || alternateBases != null && alternateBases.length != 0)) {
                foundStreetBase = false;
                continue;
            }
            saclist = dict.getSacList(pa, preferences, bSacsMustmatchGeoAndPostal);
            if (saclist.length == 0) {
                foundStreetSac = false;
                continue;
            }
            if (streetbases != null) {
                try {
                    candList.addAll(this.getStreetCandidates(streetbases, saclist, preferences, dict, debugLevel, scoringAddress));
                }
                catch (DataAccessException e) {
                    streetCandidateException = e;
                }
            }
            if (alternateBases == null) continue;
            try {
                candList.addAll(this.getAlternateStreetCandidates(alternateBases, saclist, preferences, dict, debugLevel, scoringAddress));
                continue;
            }
            catch (DataAccessException e) {
                altStreetCandidateException = e;
            }
        }
        if (candList == null || candList.isEmpty()) {
            if (streetCandidateException != null) {
                throw streetCandidateException;
            }
            if (altStreetCandidateException != null) {
                throw altStreetCandidateException;
            }
            if (!foundUsableDictionary) {
                throw new DataAccessException(2103);
            }
        }
        if (debugLevel >= 3) {
            if (rb == null) {
                rb = EMEA_DataManager.loadBundleForLocale((IConstraints)preferences, (String)"com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings");
            }
            MMJLog.getLog().debug(rb.getString("info.returning.candidates") + candList.size());
        }
        if ((result = this.buildRetrievedCandidates(candList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 0)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }
}

