/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp.binary;

import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoIndexFile;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public abstract class EMEA_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    protected EMEA_GeoInfoIndexFile m_geoInfoStringIndex;
    protected HashSet m_usedOffsets;
    private static final int MAX_ALIAS_CACHE_SIZE = 10;
    private static AliasCachedItem[] m_aliasCachedItems = new AliasCachedItem[10];
    private static AliasCachedItem m_tempAliasCahcedItem;
    private static final Object LOCK;

    public EMEA_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
        try {
            this.m_geoInfoStringIndex = new EMEA_GeoInfoIndexFile();
            this.m_geoInfoStringIndex.open(StringUtilities.appendToPath((String)dataPath, (String)"geoinfo.jdx"));
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.data.geoinfo", (Throwable)e);
        }
        m_tempAliasCahcedItem = new AliasCachedItem(null, null);
    }

    public ArrayList getGeoInfoAlias(String key) {
        AliasCachedItem cachedItem = EMEA_GeoInfoFetcherImpl.findKeyItem(key);
        if (cachedItem != null) {
            return cachedItem.getAliasList();
        }
        int nItem = 0;
        int nOffsets = 0;
        try {
            ArrayList<GeoInfoRecord> aliasList = new ArrayList<GeoInfoRecord>();
            do {
                MiStringIndexKey stringIndexKey;
                MapMarkerIndexValue indexValue;
                long[] geoOffsets;
                nOffsets = (geoOffsets = super.getGeoInfoIndexOffsets(indexValue = this.m_geoInfoStringIndex.search((MapMarkerIndexKey)(stringIndexKey = new MiStringIndexKey(nItem + key))))) == null ? 0 : geoOffsets.length;
                for (int i = 0; i < nOffsets; ++i) {
                    aliasList.add(this.getGeoInfoRecord(geoOffsets[i]));
                }
                ++nItem;
            } while (nOffsets > 0);
            EMEA_GeoInfoFetcherImpl.addIntoAliasCache(key, aliasList);
            return aliasList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static AliasCachedItem findKeyItem(String searchkey) {
        for (int i = 0; i < 10; ++i) {
            AliasCachedItem aliasItem = m_aliasCachedItems[i];
            if (aliasItem == null) {
                return null;
            }
            if (!aliasItem.equalsKey(searchkey)) continue;
            return aliasItem;
        }
        return null;
    }

    private static void addIntoAliasCache(String key, ArrayList aliasList) {
        AliasCachedItem newAliasItem = m_tempAliasCahcedItem.createNewItem(key, aliasList);
        for (int i = 8; i >= 0; --i) {
            AliasCachedItem aliasItem = m_aliasCachedItems[i];
            EMEA_GeoInfoFetcherImpl.m_aliasCachedItems[i + 1] = m_aliasCachedItems[i];
        }
        EMEA_GeoInfoFetcherImpl.m_aliasCachedItems[0] = newAliasItem;
    }

    protected void removeDupedSoundexKey(ArrayList list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = 1; j < list.size(); ++j) {
                MiSoundexIndexKey oi = (MiSoundexIndexKey)list.get(i);
                MiSoundexIndexKey oj = (MiSoundexIndexKey)list.get(j);
                if (oi == null || oj == null || !oi.equals((Object)oj)) continue;
                list.remove(j);
                --j;
            }
        }
    }

    protected void startRecordingOffsets() {
        this.m_usedOffsets = new HashSet();
    }

    protected boolean maybeRecordOffset(long offset) {
        return this.m_usedOffsets.add(new Long(offset));
    }

    protected void endRecordingOffsets() {
        this.m_usedOffsets = null;
    }

    protected long[] getGeoInfoIndexOffsets(MapMarkerIndexValue value) {
        long[] values = null;
        MapMarkerIndexMultiValue multiValue = (MapMarkerIndexMultiValue)value;
        values = new long[multiValue.getValueCount()];
        for (short i = 0; i < multiValue.getValueCount(); i = (short)(i + 1)) {
            long offset = multiValue.getOffsetAt(i);
            if (!this.maybeRecordOffset(offset)) continue;
            values[i] = offset;
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        ArrayList candidates = null;
        Object object = LOCK;
        synchronized (object) {
            this.startRecordingOffsets();
            candidates = (ArrayList)super.getGeoInfoCandidates(addr, constraints);
            this.endRecordingOffsets();
        }
        if (candidates != null) {
            int size = candidates.size();
            for (int i = size - 1; i >= 0; --i) {
                EMEA_InternalGeographicCandidate candidate = (EMEA_InternalGeographicCandidate)((Object)candidates.get(i));
                if (candidate.getPrecision() != 0) continue;
                Object e = candidates.remove(i);
            }
            candidates.trimToSize();
        }
        return candidates;
    }

    static {
        LOCK = new Object();
    }

    class AliasCachedItem {
        private String key;
        private ArrayList aliasList;

        public AliasCachedItem(String key, ArrayList alias) {
            this.key = key;
            this.aliasList = alias;
        }

        public ArrayList getAliasList() {
            return this.aliasList;
        }

        public boolean equalsKey(String inkey) {
            if (inkey != null) {
                return inkey.equals(this.key);
            }
            return false;
        }

        public AliasCachedItem createNewItem(String key, ArrayList aliasList) {
            return new AliasCachedItem(key, aliasList);
        }
    }
}

