/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.EMEA_DataBuildingUtilities;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_MissingGeoInfoStatus;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_NewFormatGeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public class EMEA_NewFormatStreetBuilder
extends GenericStreetBuilder {
    protected static final long NO_GEOINFO_OFFSET = -1L;
    protected EMEA_GeoInfoIndexFile m_geoIndex;
    private EMEA_MissingGeoInfoStatus m_missingGeoInfoStatus;

    public void openGeoInfoIndex(String geoInfoFilePath, String geoInfoFileBaseName, EMEA_MissingGeoInfoStatus missingGeoInfoStatus) throws DataCreationException {
        this.setMissingGeoInfoStatus(missingGeoInfoStatus);
        String fileName = StringUtilities.appendToPath((String)geoInfoFilePath, (String)geoInfoFileBaseName, (String)"jdx");
        try {
            this.m_geoIndex = new EMEA_GeoInfoIndexFile();
            this.m_geoIndex.open(fileName);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to open geoinfo index file: " + fileName);
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            throw new DataCreationException(400, (Throwable)IOEx);
        }
    }

    public void closeGeoInfoIndex() throws DataCreationException {
        if (this.m_geoIndex != null) {
            try {
                this.m_geoIndex.close();
            }
            catch (IOException IOEx) {
                throw new DataCreationException(400, (Throwable)IOEx);
            }
            finally {
                this.m_geoIndex = null;
            }
        }
    }

    protected void setMissingGeoInfoStatus(EMEA_MissingGeoInfoStatus missingGeoInfoStatus) {
        this.m_missingGeoInfoStatus = missingGeoInfoStatus;
    }

    protected MapMarkerIndexSingleValue getGeoInfoOffset(MiStringIndexKey key) throws IOException {
        return (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)segmentItem;
        MiStringIndexKey leftKey = this.makeGeoInfoLookupKey(segmentRecord, true);
        MiStringIndexKey rightKey = this.makeGeoInfoLookupKey(segmentRecord, false);
        long leftOffset = -1L;
        long rightOffset = -1L;
        try {
            MapMarkerIndexSingleValue val;
            if (leftKey != null) {
                val = this.getGeoInfoOffset(leftKey);
                if (val != null) {
                    leftOffset = val.getOffset();
                } else {
                    this.m_missingGeoInfoStatus.addMissingGeoInfo(leftKey.toString(), true);
                }
            }
            if (rightKey != null) {
                val = this.getGeoInfoOffset(rightKey);
                if (val != null) {
                    rightOffset = val.getOffset();
                } else {
                    this.m_missingGeoInfoStatus.addMissingGeoInfo(rightKey.toString(), false);
                }
            }
        }
        catch (IOException IOEx) {
            throw new DataCreationException(400, (Throwable)IOEx);
        }
        try {
            if (leftOffset == -1L && rightOffset == -1L) {
                String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
                String rightPostalCode1 = segmentRecord.getRightPostalCode1();
                if (leftPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                    if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                        int postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(32, (short)postVal);
                        } else {
                            segment.putInt(32, postVal);
                        }
                        segment.removeString(12);
                    }
                } else {
                    int postVal;
                    if (leftPostalCode1 != null && StringUtilities.isNumeric((String)leftPostalCode1)) {
                        postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(33, (short)postVal);
                        } else {
                            segment.putInt(33, postVal);
                        }
                        segment.removeString(0);
                    }
                    if (rightPostalCode1 != null && StringUtilities.isNumeric((String)rightPostalCode1)) {
                        postVal = Integer.parseInt(rightPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(34, (short)postVal);
                        } else {
                            segment.putInt(34, postVal);
                        }
                        segment.removeString(1);
                    }
                }
            } else if (leftOffset == rightOffset) {
                segment.putLong(0, leftOffset);
                this.cleanupSharedSegmentValues(segment);
            } else {
                String leftPostalCode1;
                boolean bHadLeftGeoInfo = false;
                boolean bHadRightGeoInfo = false;
                if (leftOffset != -1L) {
                    bHadLeftGeoInfo = true;
                    segment.putLong(35, leftOffset);
                    this.cleanupIndividualSegmentString(segment, 14, 4, 5);
                    this.cleanupIndividualSegmentString(segment, 15, 6, 7);
                    this.cleanupIndividualSegmentString(segment, 16, 8, 9);
                    this.cleanupIndividualSegmentString(segment, 17, 10, 11);
                    this.cleanupIndividualSegmentString(segment, 12, 0, 1);
                }
                if (rightOffset != -1L) {
                    bHadRightGeoInfo = true;
                    segment.putLong(36, rightOffset);
                    this.cleanupIndividualSegmentString(segment, 14, 5, 4);
                    this.cleanupIndividualSegmentString(segment, 15, 7, 6);
                    this.cleanupIndividualSegmentString(segment, 16, 9, 8);
                    this.cleanupIndividualSegmentString(segment, 17, 11, 10);
                    this.cleanupIndividualSegmentString(segment, 12, 1, 0);
                }
                if (bHadLeftGeoInfo && !bHadRightGeoInfo) {
                    String rightPostalCode1 = segmentRecord.getRightPostalCode1();
                    if (rightPostalCode1 != null && StringUtilities.isNumeric((String)rightPostalCode1)) {
                        int postVal = Integer.parseInt(rightPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(34, (short)postVal);
                        } else {
                            segment.putInt(34, postVal);
                        }
                        if (segment.hasString(1)) {
                            segment.removeString(1);
                        }
                    }
                } else if (bHadRightGeoInfo && !bHadLeftGeoInfo && (leftPostalCode1 = segmentRecord.getLeftPostalCode1()) != null && StringUtilities.isNumeric((String)leftPostalCode1)) {
                    int postVal = Integer.parseInt(leftPostalCode1);
                    if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                        segment.putShort(33, (short)postVal);
                    } else {
                        segment.putInt(33, postVal);
                    }
                    if (segment.hasString(0)) {
                        segment.removeString(0);
                    }
                }
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            throw new DataCreationException(106, (Throwable)MMJETASEEx);
        }
    }

    protected MiStringIndexKey makeGeoInfoLookupKey(MMJSegmentRecord segment, boolean bLeft) {
        String keySource = "";
        if (bLeft) {
            if (segment.getLeftPostalCode1() == null || segment.getLeftAreaName1() == null || segment.getLeftAreaName2() == null || segment.getLeftAreaName3() == null) {
                return null;
            }
            keySource = keySource + segment.getLeftPostalCode1();
            keySource = keySource + segment.getLeftAreaName1();
            keySource = keySource + segment.getLeftAreaName2();
            keySource = keySource + segment.getLeftAreaName3();
            if (segment.getLeftAreaName4() != null) {
                keySource = keySource + segment.getLeftAreaName4();
            }
        } else {
            if (segment.getRightPostalCode1() == null || segment.getRightAreaName1() == null || segment.getRightAreaName2() == null || segment.getRightAreaName3() == null) {
                return null;
            }
            keySource = keySource + segment.getRightPostalCode1();
            keySource = keySource + segment.getRightAreaName1();
            keySource = keySource + segment.getRightAreaName2();
            keySource = keySource + segment.getRightAreaName3();
            if (segment.getRightAreaName4() != null) {
                keySource = keySource + segment.getRightAreaName4();
            }
        }
        return new MiStringIndexKey(keySource);
    }

    private void cleanupSharedSegmentValues(GenericSegment segment) throws MMJETypeArraySizeExceededException {
        if (segment.hasString(14)) {
            segment.removeString(14);
        }
        if (segment.hasString(15)) {
            segment.removeString(15);
        }
        if (segment.hasString(16)) {
            segment.removeString(16);
        }
        if (segment.hasString(17)) {
            segment.removeString(17);
        }
        if (segment.hasString(12)) {
            segment.removeString(12);
        }
    }

    protected void cleanupIndividualSegmentString(GenericSegment segment, int sharedIndex, int indexToClean, int indexToUpdateWithShared) throws MMJETypeArraySizeExceededException {
        if (segment.hasString(sharedIndex)) {
            segment.putString(indexToUpdateWithShared, segment.getString(sharedIndex));
            segment.removeString(sharedIndex);
        } else if (segment.hasString(indexToClean)) {
            segment.removeString(indexToClean);
        }
    }

    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        EMEA_NewFormatGeoInfoRecord emeaRecord = (EMEA_NewFormatGeoInfoRecord)record;
        GeoInfoDataItem geoInfo = (GeoInfoDataItem)geoInfoItem;
        try {
            String[] altArray;
            String postCode;
            String areaName4Short;
            String areaName3Short = emeaRecord.getAreaName3Short();
            if (!StringUtilities.isEmpty((String)areaName3Short)) {
                geoInfo.putString(9, areaName3Short);
            }
            if (!StringUtilities.isEmpty((String)(areaName4Short = emeaRecord.getAreaName4Short()))) {
                geoInfo.putString(12, areaName4Short);
            }
            if (!StringUtilities.isEmpty((String)(postCode = emeaRecord.getPostCode()))) {
                geoInfo.putString(8, postCode);
            }
            if ((altArray = emeaRecord.getAltAreaName1Array()) != null) {
                geoInfo.putBlob(0, EMEA_DataBuildingUtilities.encodeStringArray(altArray));
            }
            if ((altArray = emeaRecord.getAltAreaName2Array()) != null) {
                geoInfo.putBlob(1, EMEA_DataBuildingUtilities.encodeStringArray(altArray));
            }
            if ((altArray = emeaRecord.getAltAreaName3Array()) != null) {
                geoInfo.putBlob(2, EMEA_DataBuildingUtilities.encodeStringArray(altArray));
            }
            if ((altArray = emeaRecord.getAltAreaName4Array()) != null) {
                geoInfo.putBlob(3, EMEA_DataBuildingUtilities.encodeStringArray(altArray));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build GeoInfoDataItem in EMEA_NewFormatStreetBuilder.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }
}

