/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.List;

public abstract class EMEA_StreetBuilder
extends GenericStreetBuilder {
    protected EMEA_GeoInfoIndexFile m_geoIndex;

    public void setGeoInfoBaseName(String geoInfoFileBaseName) {
        try {
            this.m_geoIndex = new EMEA_GeoInfoIndexFile();
            this.m_geoIndex.open(geoInfoFileBaseName + ".jdx");
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to open geoinfo files.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        EMEA_GeoInfoRecord emeaRecord = (EMEA_GeoInfoRecord)record;
        GeoInfoDataItem geoInfo = (GeoInfoDataItem)geoInfoItem;
        try {
            String altLangNames;
            String aliasedLocality;
            String postCode;
            String areaName3Short = emeaRecord.getAreaName3Short();
            if (areaName3Short != null && areaName3Short.length() != 0) {
                geoInfo.putString(9, areaName3Short);
            }
            if ((postCode = emeaRecord.getPostCode()) != null && postCode.length() != 0) {
                geoInfo.putString(8, postCode);
            }
            if ((aliasedLocality = emeaRecord.getAliasedLocality()) != null && aliasedLocality.length() != 0) {
                geoInfo.putString(10, aliasedLocality);
            }
            if ((altLangNames = emeaRecord.getAltLanguageNames()) != null && altLangNames.length() != 0) {
                geoInfo.putString(11, altLangNames);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build GeoInfoDataItem in EMEA_StreetBuilder.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }

    protected IDataFileDataItem buildSegmentFromRecord(MMJSegmentRecord segmentRecord, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)this.getSegmentDataObject();
        try {
            int postVal;
            String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
            String rightPostalCode1 = segmentRecord.getRightPostalCode1();
            if (leftPostalCode1 != null && rightPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                    postVal = Integer.parseInt(leftPostalCode1);
                    if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                        segment.putShort(32, (short)postVal);
                    } else {
                        segment.putInt(32, postVal);
                    }
                } else {
                    segment.putString(12, leftPostalCode1);
                }
            } else {
                if (leftPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                        postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(33, (short)postVal);
                        } else {
                            segment.putInt(33, postVal);
                        }
                    } else {
                        segment.putString(0, leftPostalCode1);
                    }
                }
                if (rightPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)rightPostalCode1)) {
                        postVal = Integer.parseInt(rightPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(34, (short)postVal);
                        } else {
                            segment.putInt(34, postVal);
                        }
                    } else {
                        segment.putString(1, rightPostalCode1);
                    }
                }
            }
            String leftAreaName1 = segmentRecord.getLeftAreaName1();
            String rightAreaName1 = segmentRecord.getRightAreaName1();
            if (leftAreaName1 != null && rightAreaName1 != null && leftAreaName1.equals(rightAreaName1)) {
                segment.putString(14, leftAreaName1);
            } else {
                if (leftAreaName1 != null) {
                    segment.putString(4, leftAreaName1);
                }
                if (rightAreaName1 != null) {
                    segment.putString(5, rightAreaName1);
                }
            }
            String leftAreaName2 = segmentRecord.getLeftAreaName2();
            String rightAreaName2 = segmentRecord.getRightAreaName2();
            if (leftAreaName2 != null && rightAreaName2 != null && leftAreaName2.equals(rightAreaName2)) {
                segment.putString(15, leftAreaName2);
            } else {
                if (leftAreaName2 != null) {
                    segment.putString(6, leftAreaName2);
                }
                if (rightAreaName2 != null) {
                    segment.putString(7, rightAreaName2);
                }
            }
            String leftAreaName4 = segmentRecord.getLeftAreaName4();
            String rightAreaName4 = segmentRecord.getRightAreaName4();
            if (leftAreaName4 != null && rightAreaName4 != null && leftAreaName4.equals(rightAreaName4)) {
                segment.putString(17, leftAreaName4);
            } else {
                if (leftAreaName4 != null) {
                    segment.putString(10, leftAreaName4);
                }
                if (rightAreaName4 != null) {
                    segment.putString(11, rightAreaName4);
                }
            }
            String leftAreaName3 = segmentRecord.getLeftAreaName3();
            String rightAreaName3 = segmentRecord.getRightAreaName3();
            if (leftAreaName3 != null && rightAreaName3 != null) {
                if (this.m_geoIndex != null) {
                    if (leftAreaName3.equals(rightAreaName3)) {
                        long geoOffset;
                        String combinedKey = segmentRecord.getLeftAreaName4() == null ? "" : segmentRecord.getLeftAreaName4();
                        combinedKey = combinedKey + (segmentRecord.getLeftAreaName3() == null ? "" : segmentRecord.getLeftAreaName3());
                        combinedKey = combinedKey + (segmentRecord.getLeftAreaName2() == null ? "" : segmentRecord.getLeftAreaName2());
                        combinedKey = combinedKey + (segmentRecord.getLeftAreaName1() == null ? "" : segmentRecord.getLeftAreaName1());
                        MiStringIndexKey key = new MiStringIndexKey(0 + combinedKey);
                        MapMarkerIndexSingleValue val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                        if (val == null && (val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)(key = new MiStringIndexKey(0 + segmentRecord.getLeftAreaName3())))) == null) {
                            System.err.println("\n\nUnable to locate a geoinfo record for: " + leftAreaName3);
                            System.err.println("Address Info: " + segmentRecord.toString());
                            System.err.println("In zipcode: " + segmentRecord.getLeftPostalCode1());
                            System.exit(1);
                        }
                        if (val != null && (geoOffset = val.getOffset()) > 0L) {
                            segment.putLong(0, geoOffset);
                        }
                    } else {
                        if (leftAreaName3 != null) {
                            segment.putString(8, leftAreaName3);
                        }
                        if (rightAreaName3 != null) {
                            segment.putString(9, rightAreaName3);
                        }
                    }
                }
            } else {
                if (leftAreaName3 != null) {
                    segment.putString(8, leftAreaName3);
                }
                if (rightAreaName3 != null) {
                    segment.putString(9, rightAreaName3);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException IOEx) {
            System.err.println("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        this.storeSegmentPoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        this.storeHousePoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        MMJRangeRecord lastRange = null;
        List addressRanges = segmentRecord.getRanges();
        if (addressRanges != null) {
            for (MMJRangeRecord range : addressRanges) {
                this.compressRange(range, lastRange);
                lastRange = range;
                this.addRangeToSegment((IDataFileDataItem)segment, this.buildRangeFromRangeRecord(range, metadata));
                ++this.totalRanges;
            }
        }
        return segment;
    }
}

