/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp.binary.index;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataAccessUtilities;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class EMEA_NewFormatGeoInfoSoundexIndexer
extends GeoInfoSoundexIndexer {
    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        String areaName4 = this.getAreaName4(item);
        String areaName3 = this.getAreaName3(item);
        String areaName2 = this.getAreaName2(item);
        String areaName1 = this.getAreaName1(item);
        if (areaName4 != null) {
            this.addKey(keys, areaName4);
            this.addKey(keys, this.getShortAreaName4(item));
            this.addKeys(keys, this.getAltAreaName4Array(item));
        } else if (areaName3 != null) {
            this.addKey(keys, areaName3);
            this.addKey(keys, this.getShortAreaName3(item));
            this.addKeys(keys, this.getAltAreaName3Array(item));
        } else if (areaName2 != null) {
            this.addKey(keys, areaName2);
            this.addKeys(keys, this.getAltAreaName2Array(item));
        } else if (areaName1 != null) {
            this.addKey(keys, areaName1);
            this.addKeys(keys, this.getAltAreaName1Array(item));
        }
        ArrayList<ISoundexKey> result = new ArrayList<ISoundexKey>();
        result.addAll(keys);
        return result;
    }

    private void addKey(Set<ISoundexKey> keys, String keySource) {
        if (keySource != null) {
            ISoundexKey key = this.sndx.getSoundex(keySource);
            if (key != null) {
                keys.add(key);
            } else {
                DataCreationLogger.getLogger().logInternalError("Unable to create soundex for: " + keySource);
            }
        }
    }

    private void addKeys(Set<ISoundexKey> keys, String[] keySources) {
        if (keySources != null) {
            for (String keySource : keySources) {
                this.addKey(keys, keySource);
            }
        }
    }

    protected String getAreaName1(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getString(item, 0);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName1 from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String getAreaName2(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getString(item, 1);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName3 from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String getAreaName3(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getString(item, 2);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName3 from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String getShortAreaName3(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getString(item, 9);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get shortAreaName3 from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String getAreaName4(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getString(item, 3);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName4 from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String getShortAreaName4(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getString(item, 12);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get shortAreaName4 from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String[] getAltAreaName1Array(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getStringArray(item, 0);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName1Array from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String[] getAltAreaName2Array(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getStringArray(item, 1);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName23Array from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String[] getAltAreaName3Array(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getStringArray(item, 2);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName3Array from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String[] getAltAreaName4Array(GeoInfoDataItem item) throws DataCreationException {
        try {
            return this.getStringArray(item, 3);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName4Array from geoInfo item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(301, (Throwable)MMJETASEEx);
        }
    }

    protected String getString(GeoInfoDataItem item, int stringIndex) throws MMJETypeArraySizeExceededException {
        if (item.hasString(stringIndex)) {
            return item.getString(stringIndex);
        }
        return null;
    }

    protected String[] getStringArray(GeoInfoDataItem item, int blobIndex) throws MMJETypeArraySizeExceededException, DataCreationException {
        if (item.hasBlob(blobIndex)) {
            return EMEA_DataAccessUtilities.decodeStringBlob(item.getBlob(blobIndex));
        }
        return null;
    }
}

