/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp.ud;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_Geo2SacRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.UserDictSacData;
import com.mapinfo.mapmarker.core.parser.IParser;
import java.util.List;
import java.util.Properties;

public abstract class EMEA_UDStreetDataSourceRecordConvertor
extends UDStreetDataSourceRecordConvertor {
    public EMEA_UDStreetDataSourceRecordConvertor(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, UDPost2SacDataHandler post2SacHandler, UDGeo2SacDataHandler geo2SacHandler) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints, post2SacHandler, geo2SacHandler);
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new EMEA_Geo2SacRecord(sac, (EMEA_GeoBase)base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new EMEA_Geo2SacRecord();
    }

    protected IPostalBase makePostalBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        StandardPostalBase base = null;
        if (left && input.hasLeftPostCode1() && this.stringExists(input.getLeftPostCode1())) {
            String postcode = input.getLeftPostCode1().trim();
            base = new StandardPostalBase(postcode);
        }
        return base;
    }

    @Override
    protected int getPost2Sac(IPostalBase base) {
        SacData o = this.m_post2sac.getSacForPostalBase(base);
        UserDictSacData sacData = null;
        if (o != null) {
            sacData = new UserDictSacData((Object)o);
        }
        int[] sacs = null;
        int sac = 0;
        if (sacData == null) {
            sac = this.getEMEAPost2Sac((StandardPostalBase)base);
        } else {
            sacs = sacData.getSacs();
            sac = sacs[0];
        }
        this.addRecordToSet(this.makePost2SacDataRecordType(sac, base));
        return sac;
    }

    protected int getEMEAPost2Sac(StandardPostalBase base) {
        String value = base.getValue();
        if (value.matches(".*[A-Za-z].*")) {
            return this.FAKE_SAC;
        }
        int length = value.length();
        if (length < 3) {
            while (value.length() < 3) {
                value = value + "0";
            }
        } else if (length > 3) {
            value = value.substring(0, 3);
        }
        int sac = new Integer(value);
        return sac;
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        return record;
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        Address parsedAddress = null;
        boolean validParse = false;
        for (int parserRetries = 0; !validParse && parserRetries <= this.m_maximumParserRetries; ++parserRetries) {
            parsedAddress = this.parseStreet(inputStreetAddress);
            validParse = this.validateParse(parsedAddress, inputStreetAddress, input, false, "100");
        }
        if (parsedAddress == null) {
            DataCreationLogger.getLogger().logInternalError("EMEA_UDStreetDataSourceRecordConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        if (parsedAddress.getMainAddress() == null) {
            DataCreationLogger.getLogger().logInternalError("EMEA_UDStreetDataSourceRecordConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.");
            return null;
        }
        return parsedAddress;
    }

    protected Address parseStreet(Address input) {
        input.setAreaName3("DummyTownName");
        Address addr = super.parseStreet(input);
        addr.setAddressNumber((ParsedNumber)null);
        addr.setAreaName3(null);
        return addr;
    }

    protected String makeMainAddressString(String street, String houseNumber) {
        if (houseNumber == null) {
            return street;
        }
        return street + " " + houseNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        if (this.m_bPointDataSource) return 0;
        String value = input.getStatus();
        if (value.equals("0")) return -1;
        if (value.equals("1")) {
            return -1;
        }
        if (value.equals("2")) {
            return 2;
        }
        if (value.equals("3")) {
            return 1;
        }
        if (value.equals("4")) {
            return 0;
        }
        if (!value.equals("5")) throw new DataSourceException(9);
        return -1;
    }

    protected boolean isValidRange(String from, String to) {
        return this.stringExists(from) && this.stringExists(to);
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        int i;
        boolean useAlternate;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IStreetDataSourceRecord input = (IStreetDataSourceRecord)inputData;
        List addressList = null;
        try {
            if (!input.hasMainAddress() || !this.stringExists(input.getMainAddress())) {
                DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: All streets should have main addresses.");
                return null;
            }
            addressList = this.getAllPossibleMainAddresses(input);
            if (addressList == null || addressList.size() == 0) {
                DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No main adddress found.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        int[] leftSacs = this.getLeftSacs(input);
        int uniqueLeftSacs = this.getNumberOfNonNoSacs(leftSacs);
        if (uniqueLeftSacs == 0) {
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No unique sacs on either side of the street.");
            return null;
        }
        boolean bl = useAlternate = addressList.size() > 1;
        if (uniqueLeftSacs == 1 && !useAlternate) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
        } else {
            this.m_dataRecords = new Object[uniqueLeftSacs * addressList.size() - 1];
        }
        MMJStreetRecord record = null;
        this.m_nextDataRecordIndex = 0;
        int dataRecordsIndex = 0;
        if (uniqueLeftSacs > 0) {
            for (i = 0; i < leftSacs.length; ++i) {
                if (leftSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (useAlternate) {
            try {
                for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                    this.m_dataRecords[uniqueLeftSacs + altNum - 1] = this.createAlternateStreetRecord(record, input, (Address)addressList.get(altNum + 1));
                }
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(101, (Throwable)DSEx);
            }
            for (i = 1; i < uniqueLeftSacs; ++i) {
                try {
                    for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                        this.m_dataRecords[uniqueLeftSacs + i + altNum - 1] = this.createAlternateStreetRecord((MMJStreetRecord)this.m_dataRecords[i + altNum - 1], input, (Address)addressList.get(altNum + 1));
                    }
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        return record;
    }

    private int getNumberOfNonNoSacs(int[] sacs) {
        if (sacs == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < sacs.length; ++i) {
            if (sacs[i] == this.NO_SAC) continue;
            ++count;
        }
        return count;
    }

    protected int[] getLeftSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasLeftSAC()) {
                return new int[]{input.getLeftSAC()};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    private int[] getFinalSacs(int sacFromPost2Sac, int[] sacsFromGeo2Sac) {
        if (sacFromPost2Sac != this.NO_SAC) {
            for (int i = 0; i < sacsFromGeo2Sac.length; ++i) {
                if (sacFromPost2Sac != sacsFromGeo2Sac[i]) continue;
                return new int[]{sacFromPost2Sac};
            }
            if (sacsFromGeo2Sac[0] != this.NO_SAC) {
                return new int[]{sacFromPost2Sac, sacsFromGeo2Sac[0]};
            }
            return new int[]{sacFromPost2Sac};
        }
        if (sacsFromGeo2Sac[0] != this.NO_SAC) {
            return new int[]{sacsFromGeo2Sac[0]};
        }
        return new int[]{this.NO_SAC};
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        int inputSAC = leftSac != this.NO_SAC ? leftSac : rightSac;
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsed = this.getParsedStreet(input, preParsed);
        if (parsed == null) {
            return null;
        }
        String original_street = input.getMainAddress();
        if (!this.canReassembleAddress(original_street, parsed)) {
            parsed.setGenericField4(original_street);
        }
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setAddress(parsed);
        record.setSac(inputSAC);
        record.setKey(this.makeStreetSearchKey(parsed, inputSAC));
        if (record.getKey() == null) {
            DataCreationLogger.getLogger().logError("Could not generate a search key for address '" + input.getMainAddress() + "'");
            return null;
        }
        this.assignBrowseKeys(record);
        ISegmentDataSourceRecord inputSegment = input.getSegment();
        MMJSegmentRecord segment = this.convertSegmentRecord(inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        if (segment == null) {
            return null;
        }
        record.setSegment(segment);
        this.addRangesToSegment(segment, inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        this.populateAlternateDataItems(record, input, inputSAC);
        return record;
    }

    private boolean canReassembleAddress(String original_street, Address parsed) {
        return false;
    }
}

