/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.FIN.FIN_InternalBrowseAddress;
import com.mapinfo.mapmarker.FIN.FIN_InternalMatcherConstants;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class FIN_AddressFilter {
    private static double ADDITIONAL_FIELD_THRESHOLD = 0.75;
    private static double ADDRESS_THRESHOLD = 0.75;
    private static double PERFECT_ADDITIONAL_FIELD_THRESHOLD = 0.9;
    private static double PERFECT_ADDRESS_THRESHOLD = 0.75;
    private static double THRESHOLD = 0.9;
    private static double PERFECT_SCORE = 1.0;
    private static double PERFECT_GEOGRAPHIC_THRESHOLD = 0.75;
    private static double GEOGRAPHIC_THRESHOLD = 0.65;

    private FIN_AddressFilter() {
    }

    public static void filterAddresses(IConstraints constraints, GeocodeResult geocodeResult) {
        boolean removed;
        List candidates = constraints.getHandler().getMatchResults();
        if (candidates != null && candidates.size() != 0 && (removed = FIN_AddressFilter.maybeFilterStreetCandidates(constraints, candidates) | FIN_AddressFilter.maybeFilterPostalCandidates(candidates) | FIN_AddressFilter.maybeFilterGeographicCandidates(candidates))) {
            FIN_AddressFilter.countCandidates(candidates, geocodeResult);
            FIN_AddressFilter.countCloseMatches(candidates, geocodeResult);
        }
    }

    private static boolean maybeFilterStreetCandidates(IConstraints constraints, List candidates) {
        boolean removed;
        block11: {
            block12: {
                block10: {
                    double combined;
                    InternalCandidateAddress addr;
                    removed = false;
                    if (!(candidates.get(0) instanceof InternalCandidateAddress)) break block10;
                    double highest = 0.0;
                    Iterator iter = candidates.iterator();
                    while (iter.hasNext() && highest != PERFECT_SCORE) {
                        InternalCandidateAddress addr2 = (InternalCandidateAddress)iter.next();
                        double temp = addr2.getCombinedAdditionalFieldScore();
                        if (!(temp > highest)) continue;
                        highest = temp;
                    }
                    double threshold = highest == PERFECT_SCORE ? highest * PERFECT_ADDITIONAL_FIELD_THRESHOLD : highest * ADDITIONAL_FIELD_THRESHOLD;
                    iter = candidates.iterator();
                    while (iter.hasNext()) {
                        addr = (InternalCandidateAddress)iter.next();
                        combined = addr.getCombinedAdditionalFieldScore();
                        if (!(combined > 0.0) || !(threshold > combined)) continue;
                        InternalMatcherConstants imc = constraints.getHandler().getMatcherConstants().getStreetMatcherConstants();
                        double exemptionCutOff = ((FIN_InternalMatcherConstants)imc).getExemptionCutOff();
                        if (!(addr.getCombinedAddressScore() < exemptionCutOff)) continue;
                        iter.remove();
                        removed = true;
                    }
                    highest = 0.0;
                    iter = candidates.iterator();
                    while (iter.hasNext() && highest != PERFECT_SCORE) {
                        addr = (InternalCandidateAddress)iter.next();
                        double temp = addr.getCombinedAddressScore();
                        if (!(temp > highest)) continue;
                        highest = temp;
                    }
                    threshold = highest >= THRESHOLD ? highest * PERFECT_ADDRESS_THRESHOLD : highest * ADDRESS_THRESHOLD;
                    iter = candidates.iterator();
                    while (iter.hasNext()) {
                        addr = (InternalCandidateAddress)iter.next();
                        combined = addr.getCombinedAddressScore();
                        if (!(combined > 0.0) || !(threshold > combined)) continue;
                        iter.remove();
                        removed = true;
                    }
                    iter = candidates.iterator();
                    addr = (InternalCandidateAddress)iter.next();
                    while (iter.hasNext()) {
                        InternalCandidateAddress nextCandidateAddress = (InternalCandidateAddress)iter.next();
                        if (FIN_AddressFilter.getFormattedGeoinfoString(addr).equalsIgnoreCase(FIN_AddressFilter.getFormattedGeoinfoString(nextCandidateAddress))) {
                            iter.remove();
                            removed = true;
                            continue;
                        }
                        addr = nextCandidateAddress;
                    }
                    break block11;
                }
                if (!(candidates.get(0) instanceof InternalIntersectionCandidateAddress)) break block12;
                LinkedHashMap<DirectPosition, InternalIntersectionCandidateAddress> linkedMap = new LinkedHashMap<DirectPosition, InternalIntersectionCandidateAddress>(candidates.size());
                for (InternalIntersectionCandidateAddress interAddr : candidates) {
                    DirectPosition location = interAddr.getIntersectionPoint();
                    if (linkedMap.containsKey(location)) {
                        removed = true;
                        InternalIntersectionCandidateAddress oldInterAddr = (InternalIntersectionCandidateAddress)linkedMap.get(location);
                        if (!FIN_AddressFilter.promote(interAddr, oldInterAddr)) continue;
                        linkedMap.remove(location);
                        linkedMap.put(location, interAddr);
                        continue;
                    }
                    linkedMap.put(location, interAddr);
                }
                candidates.clear();
                candidates.addAll(linkedMap.values());
                break block11;
            }
            if (!(candidates.get(0) instanceof InternalBrowseAddress)) break block11;
            Iterator iter = candidates.iterator();
            InternalBrowseAddress addr = (InternalBrowseAddress)iter.next();
            while (iter.hasNext()) {
                InternalBrowseAddress nextCandidateAddress = (InternalBrowseAddress)iter.next();
                if (FIN_AddressFilter.getFormattedGeoinfoString(addr).equalsIgnoreCase(FIN_AddressFilter.getFormattedGeoinfoString(nextCandidateAddress))) {
                    iter.remove();
                    removed = true;
                    continue;
                }
                addr = nextCandidateAddress;
            }
        }
        return removed;
    }

    private static boolean maybeFilterGeographicCandidates(List candidates) {
        boolean removed = false;
        if (candidates.get(0) instanceof InternalGeographicCandidate) {
            double bestGeographicCandidateScore = 0.0;
            double tempBestGeographicCandidateScore = 0.0;
            for (InternalGeographicCandidate geographicCandidate : candidates) {
                tempBestGeographicCandidateScore = geographicCandidate.getCombinedScore();
                if (!(tempBestGeographicCandidateScore > bestGeographicCandidateScore)) continue;
                bestGeographicCandidateScore = tempBestGeographicCandidateScore;
            }
            double threshold = bestGeographicCandidateScore == 1.0 ? bestGeographicCandidateScore * PERFECT_GEOGRAPHIC_THRESHOLD : bestGeographicCandidateScore * GEOGRAPHIC_THRESHOLD;
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                InternalGeographicCandidate geographicCandidate = (InternalGeographicCandidate)iter.next();
                double candScore = geographicCandidate.getCombinedScore();
                if (!(candScore > 0.0) || !(candScore < threshold)) continue;
                iter.remove();
                removed = true;
            }
        }
        return removed;
    }

    private static boolean maybeFilterPostalCandidates(List candidates) {
        return false;
    }

    private static void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private static void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private static boolean promote(InternalIntersectionCandidateAddress srcAddr, InternalIntersectionCandidateAddress comparedAddr) {
        return FIN_AddressFilter.calculateSimpleScore(srcAddr) > FIN_AddressFilter.calculateSimpleScore(comparedAddr);
    }

    private static double calculateSimpleScore(InternalIntersectionCandidateAddress addr) {
        double score = 0.0;
        InternalCandidateAddress cand1 = addr.getCandidate1();
        InternalCandidateAddress cand2 = addr.getCandidate2();
        score += cand1.getAddressNumberScore();
        return score += cand2.getAddressNumberScore();
    }

    private static String getFormattedGeoinfoString(InternalCandidateAddress address) {
        String rec1AreaName1 = address.getSegment().getLeftAreaName1();
        String rec1AreaName2 = address.getSegment().getLeftAreaName2();
        String rec1AreaName3 = address.getSegment().getLeftAreaName3();
        String rec1AreaName4 = address.getSegment().getLeftAreaName4();
        String rec1MainAddress = address.getMainAddress();
        String rec1GeoString = (rec1MainAddress == null ? "" : rec1MainAddress) + (rec1AreaName1 == null ? "" : rec1AreaName1) + (rec1AreaName2 == null ? "" : rec1AreaName2) + (rec1AreaName3 == null ? "" : rec1AreaName3) + (rec1AreaName4 == null ? "" : rec1AreaName4);
        return rec1GeoString;
    }

    private static String getFormattedGeoinfoString(InternalBrowseAddress address) {
        String rec1AreaName1 = address.getSegmentAt(0).getLeftAreaName1();
        String rec1AreaName2 = address.getSegmentAt(0).getLeftAreaName2();
        String rec1AreaName3 = address.getSegmentAt(0).getLeftAreaName3();
        String rec1AreaName4 = address.getSegmentAt(0).getLeftAreaName4();
        String rec1MainAddress = ((FIN_InternalBrowseAddress)address).getFormattedStreetAddress();
        String rec1GeoString = (rec1MainAddress == null ? "" : rec1MainAddress) + (rec1AreaName1 == null ? "" : rec1AreaName1) + (rec1AreaName2 == null ? "" : rec1AreaName2) + (rec1AreaName3 == null ? "" : rec1AreaName3) + (rec1AreaName4 == null ? "" : rec1AreaName4);
        return rec1GeoString;
    }
}

