/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import java.util.HashMap;

public class FIN_AddressUtils {
    private static final double CLOSE_MATCH_SCORE = 1.0;

    private FIN_AddressUtils() {
    }

    public static String getFormattedStreetAddress(Address addr, boolean bAppendAddressNumber) {
        String addrNum;
        String postThoroughFaretype;
        String postAddr;
        String newMainAddress;
        String preAddress;
        StringBuffer buf = new StringBuffer(100);
        String preCommon = (String)addr.getAdditionalFields().get("address.common.pre.main");
        if (preCommon != null && preCommon.length() != 0) {
            buf.append(preCommon.trim());
            buf.append(' ');
        }
        if ((preAddress = addr.getPreAddress()) != null && preAddress.length() != 0) {
            buf.append(preAddress.trim());
            buf.append(' ');
        }
        if ((newMainAddress = addr.getMainAddress()) != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress.trim());
            buf.append(' ');
        }
        if ((postAddr = addr.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr.trim());
            buf.append(' ');
        }
        if ((postThoroughFaretype = addr.getPostThoroughfareType()) != null && postThoroughFaretype.length() != 0) {
            buf.append(postThoroughFaretype.trim());
            buf.append(' ');
        }
        if (bAppendAddressNumber && (addrNum = addr.getAddressNumber()) != null && addrNum.length() != 0) {
            buf.append(addrNum.trim());
        }
        return buf.toString().trim();
    }

    public static String getFormattedPreAddress(Address addr) {
        String preMainCommon;
        HashMap fields = addr.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get("address.common.pre.main")) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        return buf.toString().trim();
    }

    public static boolean isPrefixAndSuffixCloseMatch(Address input, InternalCandidateAddress addr) {
        boolean postMatch;
        boolean isCloseMatch = true;
        boolean preMatch = FIN_AddressUtils.isEmpty(input.getPreAddress()) || addr.getPreAddressScore() == 1.0;
        boolean bl = postMatch = FIN_AddressUtils.isEmpty(input.getPostAddress()) || addr.getPostAddressScore() == 1.0;
        if (!preMatch || !postMatch) {
            isCloseMatch = false;
        }
        return isCloseMatch;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

