/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp;

import com.mapinfo.mapmarker.FIN.parser.FIN_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IPostInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJPostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexKey;
import java.util.Properties;

public class FIN_PostInfoDataSourceRecordConvertorImpl
extends PostInfoDataSourceRecordConvertorImpl {
    public FIN_PostInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IPostInfoDataSourceRecord input = (IPostInfoDataSourceRecord)inputData;
        PostInfoRecord baseRecord = null;
        try {
            baseRecord = this.makePostInfoRecord(input);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(501, (Throwable)DSEx);
        }
        if (baseRecord == null) {
            return null;
        }
        MapMarkerIndexKey key = this.makePostInfoIndexKey(baseRecord);
        if (key == null) {
            return null;
        }
        return new MMJPostInfoRecord(baseRecord, key);
    }

    protected PostInfoRecord makePostInfoRecord(IPostInfoDataSourceRecord input) throws DataSourceException {
        PostInfoRecord record = this.makePostInfoRecordType();
        if (!input.hasPostCode1() || !this.stringExists(input.getPostCode1())) {
            DataCreationLogger.getLogger().logInternalError("PostInfoDataSourceRecordConvertorImpl:: makePostInfoRecord(): data source record must have postCode1 field.");
            return null;
        }
        record.setPostalCode1(input.getPostCode1());
        if (input.hasPostCode2() && this.stringExists(input.getPostCode2())) {
            record.setPostalCode2(input.getPostCode2());
        }
        if (input.hasAreaName1() && this.stringExists(input.getAreaName1())) {
            record.setAreaName1(input.getAreaName1());
        }
        if (input.hasAreaName2() && this.stringExists(input.getAreaName2())) {
            record.setAreaName2(input.getAreaName2());
        }
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            record.setAreaName3(input.getAreaName3());
        }
        if (input.hasAreaName4() && this.stringExists(input.getAreaName4())) {
            record.setAreaName4(input.getAreaName4());
        }
        String postcode1 = input.getPostCode1();
        int postCodeType = FIN_ParsePostAddressRule.getPostCodeType(postcode1);
        if (input.hasCentroid()) {
            record.setCentroid(input.getCentroid());
            if (input.hasPrecision()) {
                record.setPrecision(this.convertPostInfoPrecisionToByteValue(input.getPrecision()));
            } else if (postCodeType == 3) {
                record.setPrecision((byte)3);
            } else if (postCodeType == 4) {
                record.setPrecision((byte)4);
            }
        } else {
            record.setPrecision((byte)0);
        }
        return record;
    }

    protected MapMarkerIndexKey makePostInfoIndexKey(PostInfoRecord record) {
        PostInfoIndexKey key = new PostInfoIndexKey((IPostalBase)new StandardPostalBase(FIN_ParsePostAddressRule.getOutwardSortingCode(record.getPostalCode1())));
        return key;
    }
}

