/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_TabDataProvider;
import com.mapinfo.mapmarker.FIN.FIN_ScoringHelper;
import com.mapinfo.mapmarker.FIN.dp.FIN_DataConstructionParser;
import com.mapinfo.mapmarker.FIN.dp.FIN_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FIN.dp.FIN_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FIN.dp.FIN_Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FIN.dp.FIN_PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FIN.dp.FIN_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FIN.dp.binary.FINDataWriter;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_DataFileMasksProvider;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_StreetBuilder;
import com.mapinfo.mapmarker.FIN.dp.binary.index.FIN_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.FIN.dp.binary.index.FIN_PostInfoIndexFileConvertor;
import com.mapinfo.mapmarker.FIN.dp.intermediate.FIN_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.generic.soundex.ExtendedCharacters;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.Properties;

public abstract class FIN_AbstractDataProvider
extends EMEA_TabDataProvider {
    private static MiVersion m_version = new MiVersion(4, 0, 0);
    private static GeoInfoSoundexIndexer m_GeoInfoSoundexIndexer;
    private MMJComplexDataFileMetadata m_streetMetadata;
    private MMJComplexDataFileMetadata m_postInfoMetadata;
    private MMJComplexDataFileMetadata m_geoInfoMetadata;

    public FIN_AbstractDataProvider() {
        this.m_dataWriter = new FINDataWriter((IDataProvider)this);
    }

    public void initialize(Properties props) throws DataCreationException {
        super.initialize(props);
        Constraints constraints = new Constraints();
        ExtendedCharacters extendedChar = new ExtendedCharacters("com/mapinfo/mapmarker/generic/soundex/FINExtenedeCharacter.properties");
        GenericSoundex soundex = new GenericSoundex("com/mapinfo/mapmarker/generic/soundex/FINSoundex.properties", extendedChar);
        this.m_dataBuilder = new FIN_StreetBuilder();
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new FIN_Post2SacDataSourceRecordConvertorImpl(props), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String geo2sac_operation = props.getProperty("geo2sac_flag");
        if (geo2sac_operation != null) {
            this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new FIN_Geo2SacDataSourceRecordConvertorImpl(props, (Soundex)soundex), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new FIN_PostInfoDataSourceRecordConvertorImpl(props), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(false));
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new FIN_GeoInfoDataSourceRecordConvertorImpl(props), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String processStreets = (String)props.get("street_create");
        if (processStreets != null && processStreets.equals("YES")) {
            FIN_StreetDataSourceRecordConvertorImpl streetRecordConvertor = new FIN_StreetDataSourceRecordConvertorImpl((Soundex)soundex, props, new CollationKeyGenerator(new Locale("fi", "FI"), FIN_ScoringHelper.getCollationRules()), new FIN_DataConstructionParser(), constraints);
            this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)streetRecordConvertor, (IIntermediateDataHandler)new FIN_IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)props.getProperty("street_outputFilePath"), (String)"streets.tmp")), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new FIN_MMJStreetRecordComparator(), new MMJSegmentComparer());
        }
    }

    protected abstract IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    @Override
    public void processStreets(boolean bCreateStatistics) throws DataCreationException {
        ((FIN_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.getGeoInfoForStreetsFileBaseName());
        super.processStreets(bCreateStatistics);
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        if (m_GeoInfoSoundexIndexer == null) {
            m_GeoInfoSoundexIndexer = new FIN_GeoInfoSoundexIndexer();
        }
        return m_GeoInfoSoundexIndexer;
    }

    private void setMetaDataProperties(MMJComplexDataFileMetadata metadata) {
        metadata.setCountry("FIN");
        metadata.setXPow10((byte)5);
        metadata.setYPow10((byte)5);
        metadata.setVersion(m_version);
    }

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = new MMJComplexDataFileMetadata();
            this.m_streetMetadata.setDataFileMasks(FIN_DataFileMasksProvider.buildStreetDataFileMasks());
            this.setMetaDataProperties(this.m_streetMetadata);
            this.m_streetMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_streetMetadata;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (this.m_postInfoMetadata == null) {
            this.m_postInfoMetadata = new MMJComplexDataFileMetadata();
            this.m_postInfoMetadata.setDataFileMasks(FIN_DataFileMasksProvider.buildPostInfoDataFileMasks());
            this.setMetaDataProperties(this.m_postInfoMetadata);
            this.m_postInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_postInfoMetadata;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.m_geoInfoMetadata == null) {
            this.m_geoInfoMetadata = new MMJComplexDataFileMetadata();
            this.m_geoInfoMetadata.setDataFileMasks(FIN_DataFileMasksProvider.buildGeoInfoDataFileMasks());
            this.setMetaDataProperties(this.m_geoInfoMetadata);
            this.m_geoInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_geoInfoMetadata;
    }

    public IndexFileConvertor getPostInfoIndexFileConvertor(String tempIndex, String newIndex) {
        return new FIN_PostInfoIndexFileConvertor(tempIndex, newIndex);
    }

    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new FIN_MiStringIndexFileConvertor(tempIndex, newIndex);
    }

    public boolean supportsReverseGeocode() {
        return true;
    }
}

