/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataDictionary;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_Geo2SacRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.FIN.FIN_AddressUtils;
import com.mapinfo.mapmarker.FIN.FIN_Handler;
import com.mapinfo.mapmarker.FIN.FIN_ScoringHelper;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_AddressFetcher;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.FIN.parser.FIN_ParsePostAddressRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class FIN_DataDictionary
extends EMEA_DataDictionary {
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_FIN_ALTERNATE_SOUNDEX_CODES = "KEY_FIN_ALTERNATE_SOUNDEX_CODES";
    public static final String KEY_POSTBASE_FOR_POSTAL_CENTROID = "KEY_POSTBASE_FOR_POSTAL_CENTROID";
    private Soundex m_Soundex;
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("fi", "FIN"), FIN_ScoringHelper.getCollationRules());

    public FIN_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    @Override
    public IGeoBase[] getGeoBases(Address pa, IConstraints preferences) {
        boolean bAreaName3;
        this.initSoundex(preferences);
        String an3 = pa.getAreaName3();
        if (an3 == null || an3.trim().length() == 0) {
            return null;
        }
        boolean isGeographicCentroid = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID));
        if (isGeographicCentroid) {
            ISoundexKey sndxKey3 = null;
            sndxKey3 = this.m_Soundex.getSoundex(FIN_AddressTerm.removeCommonTerms(an3));
            IGeoBase[] bases = null;
            if (sndxKey3 != null) {
                bases = new IGeoBase[]{new MiSoundexGeoBase((MiSoundexKey)sndxKey3)};
            } else if (sndxKey3 != null) {
                bases = new IGeoBase[1];
                if (sndxKey3 != null) {
                    bases[0] = new MiSoundexGeoBase((MiSoundexKey)sndxKey3);
                }
            }
            return bases;
        }
        boolean isStringKey = new Boolean(preferences.getCustomString("KEY_GEOBASE_STRING_ONLY"));
        boolean bUseAreaName4 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4));
        Vector<EMEA_GeoBase> bases = new Vector<EMEA_GeoBase>();
        ISoundexKey sndxKey = null;
        if (an3 != null && (bAreaName3 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA3)).booleanValue()) && (sndxKey = isStringKey ? ((GenericSoundex)this.m_Soundex).getStringKey(an3) : this.m_Soundex.getSoundex(an3)) != null) {
            bases.add(new EMEA_GeoBase((MiSoundexKey)sndxKey, 3));
        }
        if (bUseAreaName4) {
            ISoundexKey an4sndxKeyOnAn3 = null;
            an4sndxKeyOnAn3 = isStringKey ? ((GenericSoundex)this.m_Soundex).getStringKey(FIN_AddressTerm.removeCommonTerms(an3)) : this.m_Soundex.getSoundex(FIN_AddressTerm.removeCommonTerms(an3));
            if (an4sndxKeyOnAn3 != null) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)an4sndxKeyOnAn3, 4));
            }
        }
        if (bases.size() > 0) {
            IGeoBase[] retbases = new IGeoBase[bases.size()];
            for (int i = 0; i < bases.size(); ++i) {
                retbases[i] = (EMEA_GeoBase)bases.get(i);
            }
            return retbases;
        }
        return null;
    }

    @Override
    protected IPostalBase makePostalBase(String zipCode) {
        if (zipCode == null || zipCode.trim().length() == 0) {
            return null;
        }
        if ((zipCode = FIN_ParsePostAddressRule.getOutwardSortingCode(zipCode)) == null || zipCode.trim().length() == 0) {
            return null;
        }
        return new StandardPostalBase(zipCode);
    }

    @Override
    protected IPostalBase[] getPostalBases(Address addr, IConstraints constraints) {
        this.initSoundex(constraints);
        String postcode = addr.getPostCode1();
        if (postcode != null && postcode.length() > 2) {
            return super.getPostalBases(addr, constraints);
        }
        IPostalBase[] retvals = new IPostalBase[10];
        for (int i = 0; i < 10; ++i) {
            retvals[i] = new StandardPostalBase(postcode + i);
        }
        return retvals;
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new EMEA_Geo2SacRecord();
    }

    protected IAddressFetcher initAddressFetcher() {
        return new FIN_AddressFetcher(this.getDataManagerSettings(), null);
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int i) {
        this.initSoundex(preferences);
        return null;
    }

    @Override
    protected CollationKeyGenerator getCollationKeyGenerator() {
        return m_collationKeyGenerator;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new FIN_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        FIN_PostInfoFetcherImpl postInfoFetcher = null;
        if (!this.isUserDictionary()) {
            postInfoFetcher = new FIN_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return postInfoFetcher;
    }

    @Override
    protected Soundex getSoundex() {
        return this.m_Soundex;
    }

    private void initSoundex(IConstraints constraints) {
        if (this.m_Soundex == null && constraints != null) {
            this.m_Soundex = ((FIN_Handler)constraints.getHandler()).getSoundex();
        }
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        this.initSoundex(constraints);
        String mainAddress = addr.getMainAddress();
        if (FIN_AddressUtils.isEmpty(mainAddress)) {
            return null;
        }
        String browseStrKey = FIN_AddressTerm.replaceExtendedChars(FIN_AddressUtils.getFormattedStreetAddress(addr, false).toUpperCase());
        char c = FIN_ScoringHelper.getFirstNormChar(browseStrKey.trim());
        int[] collationKey = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        MapMarkerBrowseMultiLevelIndexKey key = new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey);
        MapMarkerBrowseMultiLevelIndexKey[] keys = new MapMarkerBrowseMultiLevelIndexKey[]{key};
        return keys;
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        this.initSoundex(constraints);
        if (FIN_AddressUtils.isEmpty(addr.getPlaceName())) {
            return null;
        }
        String browseStrKey = addr.getPlaceName().trim();
        if (FIN_AddressUtils.isEmpty(browseStrKey)) {
            return null;
        }
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
    }

    private MapMarkerBrowseMultiLevelIndexKey createBrowseIndexKey(String browseStrKey) {
        char c = FIN_ScoringHelper.getFirstNormChar(browseStrKey.trim());
        int[] collationKey1 = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        return new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey1);
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        this.initSoundex(constraints);
        String origStr = addr.getMainAddress();
        ISoundexKey origKey = this.m_Soundex.getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)KEY_FIN_ALTERNATE_SOUNDEX_CODES);
        int altTypes = 0;
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        ArrayList alternates = new ArrayList();
        alternates.add(origKey);
        alternates = (ArrayList)this.m_Soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        int size = alternates.size();
        Object[] objs = alternates.toArray();
        ISoundexKey[] retvals = new ISoundexKey[size];
        for (int i = 0; i < size; ++i) {
            retvals[i] = (ISoundexKey)objs[i];
        }
        return retvals;
    }
}

