/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataManager;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoIndexFile;
import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.FIN.FIN_InternalCandidateAddress;
import com.mapinfo.mapmarker.FIN.FIN_StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_DataDictionary;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.FIN.parser.FIN_ParsePostAddressRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class FIN_DataManager
extends EMEA_DataManager {
    private static Throwable m_setupException;
    private static Properties m_dataResources;
    private static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    private static final String ERROR_LOAD_DICT_MSG = "exception.error.reading.dictionaries";
    public static final String KEY_FIN_ALTERNATE_SOUNDEX_CODES = "KEY_FIN_ALTERNATE_SOUNDEX_CODES";
    public static final String KEY_POSTBASE_FOR_POSTAL_CENTROID = "KEY_POSTBASE_FOR_POSTAL_CENTROID";
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_GEOBASE_STRING_ONLY = "KEY_GEOBASE_STRING_ONLY";
    public static final String KEY_IGNORE_NO_SAC_ERROR = "KEY_IGNORE_NO_SAC_ERROR";
    public static final String KEY_SAC_ERROR_HAS_OCCURED = "KEY_SAC_ERROR_HAS_OCCURED";
    public static final String KEY_SUCCESS_HAS_OCCURED = "KEY_SUCCESS_HAS_OCCURED";
    public static final String KEY_SET_SAC_ERROR = "KEY_SET_SAC_ERROR";
    public static final short GEOBASE_AREA3_FLAG = 3;
    public static final String KEY_DEU_ALTERNATE_SOUNDEX_CODES = "KEY_DEU_ALTERNATE_SOUNDEX_CODES";
    public EMEA_GeoInfoIndexFile m_geoInfoStringIndex;
    private StreetCandidateAddressFilter m_StreetFilter;
    public static final String KEY_STREETS_TO_REMOVE = "KEY_STREETS_TO_REMOVE";
    static IDataDictionary[] m_dataDicts;
    static int m_numDicts;
    static ResourceBundle m_DataResources;

    public FIN_DataManager() throws MMJEDataManagerInitializationException {
        if (m_setupException != null) {
            ResourceBundle rb = FIN_DataManager.loadBundleForLocale(null, (String)LSTRING_FILE);
            throw new MMJEDataManagerInitializationException(rb.getString(ERROR_LOAD_DICT_MSG));
        }
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public static ArrayList getGeoInfoAlias(String strGeoKey, String strPostCode, int dictNum) {
        if (strGeoKey == null && strPostCode == null) {
            return null;
        }
        FIN_GeoInfoFetcherImpl geoFetcher = (FIN_GeoInfoFetcherImpl)((FIN_DataDictionary)m_dataDicts[dictNum]).getGeoInfoFetcher();
        if (geoFetcher == null) {
            return null;
        }
        return geoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(strGeoKey.toUpperCase(), FIN_ParsePostAddressRule.getOutwardSortingCode(strPostCode)));
    }

    @Override
    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates;
        try {
            ArrayList cands;
            retCandidates = super.retrieveCandidates(pa, scoringAddress, preferences);
            Map streetsToRemove = (Map)preferences.getCustomObject((Object)KEY_STREETS_TO_REMOVE);
            if (streetsToRemove != null && streetsToRemove.size() > 0 && (cands = (ArrayList)retCandidates.getCandidates()) != null && cands.size() > 0) {
                ArrayList newCands = new ArrayList(cands.size());
                for (int i = 0; i < cands.size(); ++i) {
                    Long streetOffset = new Long(((FIN_InternalCandidateAddress)((Object)cands.get(i))).getStreetOffset());
                    if (streetsToRemove.containsKey(streetOffset)) continue;
                    newCands.add(cands.get(i));
                }
                retCandidates.setCandidates(newCands);
            }
        }
        catch (DataAccessException e) {
            if (e.getErrorCode() == 2104) {
                retCandidates = new CoreRetrievedCandidates(new ArrayList());
            }
            throw e;
        }
        return retCandidates;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    protected LicenseFilter getLicenseFilter() {
        return null;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("FIN");
    }

    public void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                this.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            FIN_DataManager.start();
            if (m_setupException != null) {
                throw new MMJEDataManagerInitializationException(m_setupException.getMessage(), m_setupException);
            }
        }
    }

    private void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            dict.close();
            FIN_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    private static void start() {
        m_setupException = null;
        try {
            m_dataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("FIN");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_setupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_dataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new FIN_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    FIN_DataManager.m_dataDicts[i] = new FIN_DataDictionary(i, m_dataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_setupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_setupException = e;
        }
    }

    public static boolean isGeoInfoPresent(String strGeoKey) {
        boolean isGeoInfoPresent = false;
        if (strGeoKey == null) {
            return false;
        }
        strGeoKey = strGeoKey.toUpperCase();
        for (int dictNum = 0; dictNum < m_numDicts; ++dictNum) {
            FIN_GeoInfoFetcherImpl geoFetcher = (FIN_GeoInfoFetcherImpl)((FIN_DataDictionary)m_dataDicts[dictNum]).getGeoInfoFetcher();
            try {
                MiStringIndexKey stringIndexKey = new MiStringIndexKey(strGeoKey);
                MapMarkerIndexMultiValue val = (MapMarkerIndexMultiValue)geoFetcher.m_geoInfoStringIndex.search((MapMarkerIndexKey)stringIndexKey);
                return val != null;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return isGeoInfoPresent;
    }

    public IRetrievedCandidates retrievePostalCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        String postcode = pa.getPostCode1();
        if (pa != null && pa.getGenericField1() != null && pa.getGenericField1().length() == 5 && pa.getGenericField1().substring(4).equalsIgnoreCase("1")) {
            pa.setGenericField1(pa.getGenericField1());
            pa.setPostCode1(postcode);
        }
        return this.privateRetrievePostalCentroids(pa, preferences);
    }

    private IRetrievedCandidates privateRetrievePostalCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        int debugLevel = this.getDebugLevel(preferences);
        if (debugLevel >= 3) {
            MMJLog.getLog().debug("in retrievePostalCentroids");
        }
        ResourceBundle rb = null;
        ArrayList<InternalPostalCandidate> candList = new ArrayList<InternalPostalCandidate>();
        int numDicts = this.getDictionaryCount();
        boolean foundUsableDictionary = false;
        IDataDictionary dict = null;
        try {
            for (int dictNum = 0; dictNum < numDicts; ++dictNum) {
                dict = this.getDictionary(dictNum);
                if ((!dict.isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.AD_ONLY) && (dict.isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.UD_ONLY)) continue;
                foundUsableDictionary = true;
                if (dict.getPostInfoFetcher() == null) continue;
                try {
                    List candidates = dict.getPostInfoFetcher().getPostInfoCandidates(pa, preferences);
                    if (candidates == null) continue;
                    IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
                    for (InternalPostalCandidate candidate : candidates) {
                        if (dict.isUserDictionary()) {
                            candidate.setFromUserDictionary();
                        }
                        candidate.setDictionaryPriority(dictNum);
                        if (order != null) {
                            candidate.setUserDictionaryPriority(order.getSearchOrderForDictionary(dictNum + 1));
                        } else {
                            candidate.setUserDictionaryPriority(dictNum + 1);
                        }
                        if (!FIN_ParsePostAddressRule.getOutwardSortingCode(candidate.getPostCode1()).equals(FIN_ParsePostAddressRule.getOutwardSortingCode(pa.getPostCode1()))) continue;
                        candList.add(candidate);
                    }
                    continue;
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessException(2102, (Throwable)e);
        }
        if ((candList == null || candList.isEmpty()) && !foundUsableDictionary) {
            throw new DataAccessException(2103);
        }
        if (debugLevel >= 2) {
            if (rb == null) {
                rb = FIN_DataManager.loadBundleForLocale((IConstraints)preferences, (String)LSTRING_FILE);
            }
            MMJLog.getLog().debug(rb.getString("info.returning.candidates") + candList.size());
        }
        if ((result = this.buildRetrievedCandidates(candList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 2)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    protected StreetCandidateAddressFilter getStreetFilter() {
        if (this.m_StreetFilter == null) {
            this.m_StreetFilter = new FIN_StreetCandidateAddressFilter(null);
        }
        return this.m_StreetFilter;
    }

    public IRetrievedCandidates retrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        DictionaryUsagePreference originalSetting = preferences.getDictionaryUsage();
        preferences.setDictionaryUsage(DictionaryUsagePreference.AD_ONLY);
        IRetrievedCandidates candidates = super.retrieveGeographicCentroids(pa, preferences);
        preferences.setDictionaryUsage(originalSetting);
        return candidates;
    }

    static {
        FIN_DataManager.start();
    }
}

