/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoSoundexIndexFile;
import com.mapinfo.mapmarker.FIN.FIN_Handler;
import com.mapinfo.mapmarker.FIN.FIN_InternalGeographicCandidate;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.FIN.dp.binary.index.FIN_GeoInfoIndexFile;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class FIN_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    protected Soundex m_soundex;
    protected FIN_GeoInfoIndexFile m_geoInfoStringIndex;
    private static final int MAX_ALIAS_CACHE_SIZE = 10;
    private static FIN_AliasCachedItem[] m_aliasCachedItems = new FIN_AliasCachedItem[10];
    private static FIN_AliasCachedItem m_tempAliasCahcedItem;
    protected HashSet m_usedOffsets;

    public FIN_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
        try {
            this.m_geoInfoStringIndex = new FIN_GeoInfoIndexFile();
            this.m_geoInfoStringIndex.open(StringUtilities.appendToPath((String)dataPath, (String)"geoinfo.jdx"));
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.data.geoinfo", (Throwable)e);
        }
        m_tempAliasCahcedItem = new FIN_AliasCachedItem(null, null);
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new FIN_GeoInfoPreLoadedDataHelper();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new EMEA_GeoInfoSoundexIndexFile();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        if (constraints != null) {
            if (this.m_soundex == null) {
                this.m_soundex = ((FIN_Handler)constraints.getHandler()).getSoundex();
            }
        } else if (this.m_soundex == null) {
            this.m_soundex = new GenericSoundex("com/mapinfo/mapmarker/generic/soundex/FINSoundex.properties");
        }
        ArrayList<MiSoundexIndexKey> list = new ArrayList<MiSoundexIndexKey>();
        String areaName3 = addr.getAreaName3();
        if (areaName3 != null) {
            String area3shortCalc;
            ISoundexKey area3Key = this.m_soundex.getSoundex(areaName3);
            MiSoundexIndexKey key = new MiSoundexIndexKey((MiSoundexKey)area3Key);
            list.add(key);
            String firstAreaName3 = this.getFirstName(areaName3);
            if (firstAreaName3 != null) {
                ISoundexKey firstArea3Key = this.m_soundex.getSoundex(firstAreaName3);
                MiSoundexIndexKey firstKey = new MiSoundexIndexKey((MiSoundexKey)firstArea3Key);
                list.add(firstKey);
            }
            if ((area3shortCalc = FIN_AddressTerm.removeCommonTerms(areaName3)) != null && !area3shortCalc.equalsIgnoreCase(areaName3)) {
                ISoundexKey area3shortCalcKey = this.m_soundex.getSoundex(area3shortCalc);
                MiSoundexIndexKey shortKey = new MiSoundexIndexKey((MiSoundexKey)area3shortCalcKey);
                list.add(shortKey);
            }
        }
        this.removeDupedSoundexKey(list);
        MapMarkerIndexKey[] retvals = new MapMarkerIndexKey[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retvals[i] = (MapMarkerIndexKey)list.get(i);
        }
        return retvals;
    }

    protected List getAltLangNameList(String town) {
        MiStringIndexKey stringIndexKey = new MiStringIndexKey(town);
        ArrayList<String> altLanguageNamesList = new ArrayList<String>();
        MapMarkerIndexMultiValue indexValue = null;
        try {
            indexValue = (MapMarkerIndexMultiValue)this.m_geoInfoStringIndex.search((MapMarkerIndexKey)stringIndexKey);
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (indexValue != null) {
            int loopiterator = indexValue.getValueCount();
            for (int i = 0; i < loopiterator; ++i) {
                long offset = indexValue.getOffsetAt((short)i);
                EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)this.getGeoInfoRecord(offset);
                String altLangName = record.getAltLanguageNames();
                if (altLangName == null || altLanguageNamesList.contains(altLangName)) continue;
                altLanguageNamesList.add(altLangName);
            }
        }
        return altLanguageNamesList;
    }

    public List getAltLangNames(String town) {
        return this.getAltLangNameList(town);
    }

    private String getFirstName(String name) {
        String result = null;
        StringTokenizer st = new StringTokenizer(name, " /-");
        if (st.countTokens() != 1) {
            result = st.nextToken();
        }
        return result;
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new FIN_InternalGeographicCandidate();
    }

    public ArrayList getGeoInfoAlias(String key) {
        FIN_AliasCachedItem cachedItem = FIN_GeoInfoFetcherImpl.findKeyItem(key);
        if (cachedItem != null) {
            return cachedItem.getAliasList();
        }
        int nOffsets = 0;
        try {
            ArrayList<GeoInfoRecord> aliasList = new ArrayList<GeoInfoRecord>();
            MiStringIndexKey stringIndexKey = new MiStringIndexKey(key);
            MapMarkerIndexValue indexValue = this.m_geoInfoStringIndex.search((MapMarkerIndexKey)stringIndexKey);
            long[] geoOffsets = super.getGeoInfoIndexOffsets(indexValue);
            nOffsets = geoOffsets == null ? 0 : geoOffsets.length;
            for (int i = 0; i < nOffsets; ++i) {
                aliasList.add(this.getGeoInfoRecord(geoOffsets[i]));
            }
            FIN_GeoInfoFetcherImpl.addIntoAliasCache(key, aliasList);
            return aliasList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addIntoAliasCache(String key, ArrayList aliasList) {
        FIN_AliasCachedItem newAliasItem = m_tempAliasCahcedItem.createNewItem(key, aliasList);
        for (int i = 8; i >= 0; --i) {
            FIN_GeoInfoFetcherImpl.m_aliasCachedItems[i + 1] = m_aliasCachedItems[i];
        }
        FIN_GeoInfoFetcherImpl.m_aliasCachedItems[0] = newAliasItem;
    }

    private static FIN_AliasCachedItem findKeyItem(String searchkey) {
        for (int i = 0; i < 10; ++i) {
            FIN_AliasCachedItem aliasItem = m_aliasCachedItems[i];
            if (aliasItem == null) {
                return null;
            }
            if (!aliasItem.equalsKey(searchkey)) continue;
            return aliasItem;
        }
        return null;
    }

    protected void removeDupedSoundexKey(ArrayList list) {
        if (list.size() < 2) {
            return;
        }
        TreeSet set = new TreeSet();
        set.addAll(list);
        if (list.size() != set.size()) {
            list.clear();
            list.addAll(set);
        }
    }

    protected boolean maybeRecordOffset(long offset) {
        return this.m_usedOffsets.add(new Long(offset));
    }

    protected void endRecordingOffsets() {
        this.m_usedOffsets = null;
    }

    protected long[] getGeoInfoIndexOffsets(MapMarkerIndexValue value) {
        long[] values = null;
        MapMarkerIndexMultiValue multiValue = (MapMarkerIndexMultiValue)value;
        values = new long[multiValue.getValueCount()];
        for (short i = 0; i < multiValue.getValueCount(); i = (short)(i + 1)) {
            long offset = multiValue.getOffsetAt(i);
            if (!this.maybeRecordOffset(offset)) continue;
            values[i] = offset;
        }
        return values;
    }

    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        this.startRecordingOffsets();
        ArrayList candidates = (ArrayList)super.getGeoInfoCandidates(addr, constraints);
        this.endRecordingOffsets();
        if (candidates != null) {
            int size = candidates.size();
            for (int i = size - 1; i >= 0; --i) {
                EMEA_InternalGeographicCandidate candidate = (EMEA_InternalGeographicCandidate)((Object)candidates.get(i));
                if (candidate.getPrecision() != 0) continue;
                candidates.remove(i);
            }
            candidates.trimToSize();
        }
        return candidates;
    }

    protected void startRecordingOffsets() {
        this.m_usedOffsets = new HashSet();
    }

    class FIN_AliasCachedItem {
        private String key;
        private ArrayList aliasList;

        public FIN_AliasCachedItem(String key, ArrayList alias) {
            this.key = key;
            this.aliasList = alias;
        }

        public ArrayList getAliasList() {
            return this.aliasList;
        }

        public boolean equalsKey(String inkey) {
            if (inkey != null) {
                return inkey.equals(this.key);
            }
            return false;
        }

        public FIN_AliasCachedItem createNewItem(String key, ArrayList aliasList) {
            return new FIN_AliasCachedItem(key, aliasList);
        }
    }
}

