/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.FIN.dp.binary.index.FIN_GeoInfoIndexFile;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.FIN.parser.FIN_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class FIN_StreetBuilder
extends EMEA_StreetBuilder {
    public IDataFileDataItem buildStreetFromRecord(MultiSegmentStreet record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericStreet street = (GenericStreet)super.buildStreetFromRecord(record, metadata);
        Address address = record.getAddress();
        try {
            if (address.hasAdditionalFields()) {
                HashMap fields = address.getAdditionalFields();
                this.putStringToStreet(street, 39, fields, "address.common.pre.main");
                this.putStringToStreet(street, 40, fields, "address.common.post.st_type");
                this.putStringToStreet(street, 41, fields, "address.separator.post.st_type");
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            System.err.println("Unable to add to the street.");
            System.err.println("Attempting to add: " + address.toString());
            System.err.println(MMJETASEEx.getMessage());
            MMJETASEEx.printStackTrace(System.err);
            throw new DataCreationException(101, (Throwable)MMJETASEEx);
        }
        return street;
    }

    private void putStringToStreet(GenericStreet street, int intKey, HashMap fields, String strKey) throws MMJETypeArraySizeExceededException {
        String value = (String)fields.get(strKey);
        String string = value = value == null ? null : value.trim();
        if (value != null && value.length() > 0) {
            street.putString(intKey, value);
        }
    }

    @Override
    protected IDataFileDataItem buildSegmentFromRecord(MMJSegmentRecord segmentRecord, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)this.getSegmentDataObject();
        try {
            int postVal;
            String segmentId = segmentRecord.getId();
            if (segmentId != null) {
                boolean storeSegmentIdAsLong = false;
                try {
                    segment.putLong(3, Long.parseLong(segmentId));
                    storeSegmentIdAsLong = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!storeSegmentIdAsLong) {
                    segment.putString(19, segmentId);
                }
            }
            String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
            String rightPostalCode1 = segmentRecord.getRightPostalCode1();
            if (leftPostalCode1 != null && rightPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                    postVal = Integer.parseInt(leftPostalCode1);
                    if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                        segment.putShort(32, (short)postVal);
                    } else {
                        segment.putInt(32, postVal);
                    }
                } else {
                    segment.putString(12, leftPostalCode1);
                }
            } else {
                if (leftPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                        postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(33, (short)postVal);
                        } else {
                            segment.putInt(33, postVal);
                        }
                    } else {
                        segment.putString(0, leftPostalCode1);
                    }
                }
                if (rightPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)rightPostalCode1)) {
                        postVal = Integer.parseInt(rightPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(34, (short)postVal);
                        } else {
                            segment.putInt(34, postVal);
                        }
                    } else {
                        segment.putString(1, rightPostalCode1);
                    }
                }
            }
            String leftAreaName1 = segmentRecord.getLeftAreaName1();
            String rightAreaName1 = segmentRecord.getRightAreaName1();
            if (leftAreaName1 != null && rightAreaName1 != null && leftAreaName1.equals(rightAreaName1)) {
                segment.putString(14, leftAreaName1);
            } else {
                if (leftAreaName1 != null) {
                    segment.putString(4, leftAreaName1);
                }
                if (rightAreaName1 != null) {
                    segment.putString(5, rightAreaName1);
                }
            }
            String leftAreaName2 = segmentRecord.getLeftAreaName2();
            String rightAreaName2 = segmentRecord.getRightAreaName2();
            if (leftAreaName2 != null && rightAreaName2 != null && leftAreaName2.equals(rightAreaName2)) {
                segment.putString(15, leftAreaName2);
            } else {
                if (leftAreaName2 != null) {
                    segment.putString(6, leftAreaName2);
                }
                if (rightAreaName2 != null) {
                    segment.putString(7, rightAreaName2);
                }
            }
            String leftAreaName4 = segmentRecord.getLeftAreaName4();
            String rightAreaName4 = segmentRecord.getRightAreaName4();
            if (leftAreaName4 != null && rightAreaName4 != null && leftAreaName4.equals(rightAreaName4)) {
                segment.putString(17, leftAreaName4);
            } else {
                if (leftAreaName4 != null) {
                    segment.putString(10, leftAreaName4);
                }
                if (rightAreaName4 != null) {
                    segment.putString(11, rightAreaName4);
                }
            }
            String leftAreaName3 = segmentRecord.getLeftAreaName3();
            String rightAreaName3 = segmentRecord.getRightAreaName3();
            if (leftAreaName3 != null && rightAreaName3 != null) {
                if (this.m_geoIndex != null) {
                    if (leftAreaName3.equals(rightAreaName3)) {
                        long geoOffset;
                        String combinedKey = segmentRecord.getLeftAreaName4() == null ? "" : segmentRecord.getLeftAreaName4();
                        combinedKey = combinedKey + (segmentRecord.getLeftAreaName3() == null ? "" : segmentRecord.getLeftAreaName3());
                        combinedKey = combinedKey + (segmentRecord.getLeftAreaName2() == null ? "" : segmentRecord.getLeftAreaName2());
                        MiStringIndexKey key = new MiStringIndexKey(FIN_AddressTerm.removeDiacritics((combinedKey = combinedKey + (segmentRecord.getLeftAreaName1() == null ? "" : segmentRecord.getLeftAreaName1())).toUpperCase()));
                        MapMarkerIndexMultiValue val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                        if (val == null) {
                            key = new MiStringIndexKey(FIN_AddressTerm.removeDiacritics(segmentRecord.getLeftAreaName3().toUpperCase()));
                            val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                            if (val == null) {
                                key = new MiStringIndexKey(FIN_AddressTerm.removeDiacritics(EMEA_GeoInfoAliasKeyCreator.createKey(segmentRecord.getLeftAreaName3().toUpperCase(), FIN_ParsePostAddressRule.getOutwardSortingCode(segmentRecord.getLeftPostalCode1()))));
                                val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                            }
                            if (val == null) {
                                System.err.println("\n\nUnable to locate a geoinfo record for: " + leftAreaName3);
                                System.err.println("Address Info: " + segmentRecord.toString());
                                System.err.println("In zipcode: " + segmentRecord.getLeftPostalCode1());
                            }
                        }
                        if (val != null && (geoOffset = val.getOffsetAt((short)0)) > 0L) {
                            segment.putLong(0, geoOffset);
                        }
                    } else {
                        if (leftAreaName3 != null) {
                            segment.putString(8, leftAreaName3);
                        }
                        if (rightAreaName3 != null) {
                            segment.putString(9, rightAreaName3);
                        }
                    }
                }
            } else {
                if (leftAreaName3 != null) {
                    segment.putString(8, leftAreaName3);
                }
                if (rightAreaName3 != null) {
                    segment.putString(9, rightAreaName3);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException IOEx) {
            System.err.println("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            throw new DataCreationException(101, (Throwable)IOEx);
        }
        this.storeSegmentPoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        MMJRangeRecord lastRange = null;
        List addressRanges = segmentRecord.getRanges();
        if (addressRanges != null) {
            for (MMJRangeRecord range : addressRanges) {
                this.compressRange(range, lastRange);
                lastRange = range;
                this.addRangeToSegment((IDataFileDataItem)segment, this.buildRangeFromRangeRecord(range, metadata));
                ++this.totalRanges;
            }
        }
        return segment;
    }

    @Override
    public void setGeoInfoBaseName(String geoInfoFileBaseName) {
        try {
            this.m_geoIndex = new FIN_GeoInfoIndexFile();
            this.m_geoIndex.open(geoInfoFileBaseName + ".jdx");
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to open geoinfo files.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            throw new RuntimeException("Unable to open the geoinfo index file", new DataCreationException(400, (Throwable)IOEx));
        }
    }
}

