/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.intermediate;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import java.util.HashMap;

public class FIN_IntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    public FIN_IntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetRecord2DataItem(record, item);
        Address address = record.getAddress();
        if (address.hasAdditionalFields()) {
            try {
                this.putField2DataItem(item, address, "address.common.pre.main", 13);
                this.putField2DataItem(item, address, "address.start", 11);
                this.putField2DataItem(item, address, "address.common.post.st_type", 14);
                this.putField2DataItem(item, address, "address.separator.post.st_type", 22);
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataSourceException(14, (Throwable)e);
            }
        }
    }

    private void putField2DataItem(IntermediateStreetDataItem item, Address address, Object hash, int index) throws MMJETypeArraySizeExceededException {
        String value = (String)address.getAdditionalFields().get(hash);
        if (value != null && value.length() > 0) {
            item.putString(index, value);
        }
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetDataItem2Record(record, item);
        try {
            HashMap adFields = new HashMap();
            this.putDataItem2Field(item, adFields, "address.common.pre.main", 13);
            this.putDataItem2Field(item, adFields, "address.common.post.st_type", 14);
            this.putDataItem2Field(item, adFields, "address.separator.post.st_type", 22);
            if (!adFields.isEmpty()) {
                Address address = record.getAddress();
                address.setAdditionalFields(adFields);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    private void putDataItem2Field(IntermediateStreetDataItem item, HashMap fields, Object hash, int index) throws MMJETypeArraySizeExceededException {
        if (item.hasString(index)) {
            fields.put(hash, item.getString(index));
        }
    }
}

