/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.ud.tab;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class FIN_TabUDSamplePropertiesWriter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("FINge: FIN_TabSamplePropertiesWriter <output properties file>");
            System.exit(1);
        }
        FIN_TabUDSamplePropertiesWriter sampleProps = new FIN_TabUDSamplePropertiesWriter();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(args[0]), true);
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to create output properties file: " + args[0]);
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        writer.println("## Sample processing properties file");
        writer.println();
        writer.println("COUNTRY=FIN");
        writer.println("useConsole=YES");
        writer.println("## Provide full path and file name if you want the log files somewhere other than the working directory.");
        writer.println("statusLog=<status log file name>");
        writer.println("errorLog=<error log file name>");
        writer.println("internalErrorLog=<internal error log file name>");
        writer.println();
        sampleProps.writeStreetProcessingProperties(writer);
        sampleProps.writePost2SacProcessingProperties(writer);
        sampleProps.writeGeo2SacProcessingProperties(writer);
        sampleProps.writePostInfoProcessingProperties(writer);
        sampleProps.writeGeoInfoProcessingProperties(writer);
        writer.close();
    }

    protected void writeStreetProcessingProperties(PrintWriter writer) {
        writer.println("## Street processing properties");
        writer.println("## The street_create property shoud be set to YES to enable street processing");
        writer.println("street_create=NO");
        writer.println("street_outputFile=<output street data file base name e.g. esp0>");
        writer.println("street_outputFilePath=<output street data file path.>");
        writer.println("dataSetPath=<path to the address dictionary.  Used for UDs.>");
        writer.println("street_inputTable=<input tab data file name>");
        writer.println("");
        writer.println("## startRow and endRow=0 will read all rows from tab file.");
        writer.println("startRow=0");
        writer.println("endRow=0");
        writer.println("");
        writer.println("");
        writer.println("## street_mainAddress must be defined");
        writer.println("street_mainAddress=NONE");
        writer.println("");
        writer.println("## The left and right areaName and postcode fields should be mapped to the same column in the case where only one is available");
        writer.println("street_leftPostCode1=NONE");
        writer.println("street_leftAreaName1=NONE");
        writer.println("street_leftAreaName2=NONE");
        writer.println("street_leftAreaName3=NONE");
        writer.println("street_leftAreaName4=NONE");
        writer.println("street_rightPostCode1=NONE");
        writer.println("street_rightAreaName1=NONE");
        writer.println("street_rightAreaName2=NONE");
        writer.println("street_rightAreaName3=NONE");
        writer.println("street_rightAreaName4=NONE");
        writer.println("street_rightPlaceName=NONE");
        writer.println("street_leftPlaceName=NONE");
        writer.println("street_fromLeft=NONE");
        writer.println("street_toLeft=NONE");
        writer.println("street_fromRight=NONE");
        writer.println("street_toRight=NONE");
        writer.println("");
        writer.println("## The street_leftRangeStatus field should contain odd/even information");
        writer.println("## Currently this should be any one of the following");
        writer.println("## 0 or 5 - No range, or unknown range. house number information will not be used");
        writer.println("## 2      - House number are even for this range");
        writer.println("## 3      - House number are odd for this range");
        writer.println("## 4      - House number are mixed for this range");
        writer.println("street_leftRangeStatus=NONE");
        writer.println("");
        writer.println("## The street_rightRangeStatus field should contain odd/even information");
        writer.println("## Currently this should be any one of the following");
        writer.println("## 0 or 5 - No range, or unknown range. house number information will not be used");
        writer.println("## 2      - House number are even for this range");
        writer.println("## 3      - House number are odd for this range");
        writer.println("## 4      - House number are mixed for this range");
        writer.println("street_rightRangeStatus=NONE");
        writer.println();
    }

    protected void writeGeo2SacProcessingProperties(PrintWriter writer) {
        writer.println("## Geo2Sac processing properties");
        writer.println("## The geo2sac_create property is always set to NO for user dictionaries");
        writer.println("## since geo2sac data is processed during street data processing.");
        writer.println("## The geo2sac.mmj file is the name of the geo2sac file and cannot be changed");
        writer.println("geo2sac_create=NO");
        writer.println("## Make the geo2sac output file path the same as the street_outputFilePath path.");
        writer.println("geo2sac_outputFilePath=<output geo2sac data file path.>");
        writer.println();
    }

    protected void writeGeoInfoProcessingProperties(PrintWriter writer) {
        writer.println("## Sample geoInfo processing properties");
        writer.println("## The geoInfo_create property is always set to NO for user dictionaries");
        writer.println("## since geoinfo data is processed during street data processing.");
        writer.println("geoInfo_create=NO");
        writer.println("geoInfo_outputFile=geoinfo");
        writer.println("## Make the geoinfo output file path the same as the street_outputFilePath path.");
        writer.println("geoInfo_outputFilePath=<output geoinfo data file path.>");
        writer.println();
    }

    protected void writePost2SacProcessingProperties(PrintWriter writer) {
        writer.println("## Post2Sac processing properties");
        writer.println("## The post2sac_create property is always set to NO for user dictionaries");
        writer.println("## since post2sac data is processed during street data processing.");
        writer.println("## The post2sac.mmj file is the name of the post2sac file and cannot be changed");
        writer.println("post2sac_create=NO");
        writer.println("## Make the post2sac output file path the same as the street_outputFilePath path.");
        writer.println("post2sac_outputFilePath=<output post2sac data file path.>");
        writer.println();
    }

    protected void writePostInfoProcessingProperties(PrintWriter writer) {
        writer.println("## PostInfo processing properties");
        writer.println("## The postInfo_create property is always set to NO for user dictionaries");
        writer.println("## since postinfo data is processed during street data processing.");
        writer.println("postInfo_create=NO");
        writer.println("postInfo_outputFile=postinfo");
        writer.println("## Make the post2sac output file path the same as the street_outputFilePath path.");
        writer.println("postInfo_outputFilePath=<output postinfo data file path.>");
        writer.println();
    }
}

