/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class FIN_AddressTerm {
    private static final String COMMON_TERMS_KEY = "common_words";
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String COUNTRY_CODES_KEY = "country_codes";
    private static final String HNR_START = "hnr_start";
    private static final String HNR_CAN_CONTAIN = "hnr_can_contain";
    private static final String STREET_NOT_CONTAIN = "street_not_contain";
    private static final String EXTENDED_CHARS = "extended_chars";
    private static final String DIRECTIONALS = "directionals";
    private static final String PRE_NUM_STREET_WORD = "pre_num_street_word";
    private static final String POST_NUM_STREET_WORD = "post_num_street_word";
    private static final String ORDINAL_CHARS = "ordinal_chars";
    private static final String COMPANY_SUFFIXES = "company_suffixes";
    private static final String FIN_SPECIAL_CHAR_PROPERTIRS = "com/mapinfo/mapmarker/FIN/FINSpecialCharacters.properties";
    private static final String FIN_MULTI_WORD_AREA_NAME_PROPERTIES = "FIN_MultiWordAreaNames.properties";
    private static char[] romanNumberChars = new char[]{'X', 'V', 'I', ' ', '1'};
    private static char[] validPunctuationChars = new char[]{'-', '\'', ',', ' ', '.'};
    private static StringBuffer punctuationList = null;
    private static ArrayList cntryCodeList = null;
    private static ArrayList commonTermList = null;
    private static ArrayList hnrStartList = null;
    private static ArrayList hnrContainList = null;
    private static ArrayList streetNotContainList = null;
    private static ArrayList extendedCharsList = null;
    private static ArrayList directionalList = null;
    private static ArrayList preNumStreetWordList = null;
    private static ArrayList postNumStreetWordList = null;
    private static ArrayList ordinalCharsList = null;
    private static ArrayList multiWordAreaNames = null;
    private static ArrayList companySuffixesList = null;
    private static Properties properties;
    private static Properties diacritics;
    public static HashMap extenedcharMap;

    private static void loadPunctuations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (punctuationList == null) {
                punctuationList = new StringBuffer(raw.length());
            }
            punctuationList.append(raw);
        }
    }

    public static String removeCommonTerms(String s) {
        String result = null;
        if (s == null || s.length() == 0) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(s, " ", true);
        String term = null;
        while (tokens.hasMoreTokens()) {
            term = tokens.nextToken();
            if (FIN_AddressTerm.isCommonTerm(term)) continue;
            buff.append(term);
        }
        result = buff.toString().trim();
        return result;
    }

    private static void loadCommonTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (commonTermList == null) {
                commonTermList = new ArrayList(10);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String commonWord = null;
            while (st.hasMoreTokens()) {
                commonWord = st.nextToken().trim();
                if (commonWord.length() <= 0) continue;
                commonTermList.add(commonWord.toUpperCase());
            }
        }
    }

    private static void loadCountryCodes(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (cntryCodeList == null) {
                cntryCodeList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String cntryCode = null;
            while (st.hasMoreTokens()) {
                cntryCode = st.nextToken().trim();
                if (cntryCode.length() <= 0) continue;
                cntryCodeList.add(cntryCode.toUpperCase());
            }
        }
    }

    private static void loadCompanySuffixes(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (companySuffixesList == null) {
                companySuffixesList = new ArrayList(7);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String suffix = null;
            while (st.hasMoreTokens()) {
                suffix = st.nextToken().trim();
                if (suffix.length() <= 0) continue;
                companySuffixesList.add(suffix.toUpperCase());
            }
        }
    }

    private static void loadHnrStartTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrStartList == null) {
                hnrStartList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String start = null;
            while (st.hasMoreTokens()) {
                start = st.nextToken().trim();
                if (start.length() <= 0) continue;
                hnrStartList.add(start.toUpperCase());
            }
        }
    }

    private static void loadHnrContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrContainList == null) {
                hnrContainList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String contains = null;
            while (st.hasMoreTokens()) {
                contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                hnrContainList.add(contains.toUpperCase());
            }
            hnrContainList.add(",");
        }
    }

    private static void loadStreetNotContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (streetNotContainList == null) {
                streetNotContainList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String contains = null;
            while (st.hasMoreTokens()) {
                contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                streetNotContainList.add(contains.toUpperCase());
            }
        }
    }

    public static String getPunctuationsAsString() {
        if (punctuationList == null) {
            return null;
        }
        return punctuationList.toString();
    }

    public static String getOrdinalsAsString() {
        if (ordinalCharsList == null) {
            return null;
        }
        return ordinalCharsList.toString();
    }

    public static boolean isCountryCode(String code) {
        if (cntryCodeList != null) {
            return cntryCodeList.contains(code.toUpperCase());
        }
        return false;
    }

    public static boolean containsCompanySuffix(String term) {
        if (term == null || term.length() == 0) {
            return false;
        }
        for (int i = 0; i < companySuffixesList.size(); ++i) {
            String suffix = (String)companySuffixesList.get(i);
            if (suffix == null || suffix.length() == 0 || !term.toUpperCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPunctuation(String term) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(term) > -1;
    }

    public static boolean isPunctuation(char ch) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(ch) > -1;
    }

    public static String getValidTerm(String inTerm) {
        return FIN_AddressTerm.getValidTerm(inTerm, false);
    }

    public static String getValidTerm(String inTerm, boolean canHaveNumeric) {
        if (inTerm == null || inTerm.trim().length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(inTerm.length());
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.charAt(i);
            if (ch == '_') {
                ch = '-';
            }
            if (ch == ',') {
                ch = ' ';
            }
            if (ch == '\'') {
                ch = ' ';
            }
            if (FIN_AddressTerm.isValidPunctuationCharacter(ch) && buf.length() > 0) {
                buf.append(ch);
                continue;
            }
            if (ch == '\'') {
                buf.append(ch);
                continue;
            }
            if (Character.isLetter(ch)) {
                buf.append(ch);
                continue;
            }
            if (FIN_AddressTerm.isExtendedChar(ch)) {
                buf.append(ch);
                continue;
            }
            if (!canHaveNumeric || !FIN_AddressTerm.isDigit(ch)) continue;
            buf.append(ch);
        }
        if (buf.length() > 0) {
            return buf.toString().trim();
        }
        return null;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isCommonTerm(String term) {
        if (commonTermList != null) {
            return commonTermList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isHnrStartTerm(String term) {
        if (hnrStartList != null) {
            return hnrStartList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isHnrCanContainTerm(String term) {
        if (term == null) {
            return false;
        }
        if (hnrContainList != null) {
            return hnrContainList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isOrdinal(String term) {
        if (term == null) {
            return false;
        }
        if (ordinalCharsList != null) {
            if (ordinalCharsList.contains(term)) {
                return true;
            }
            return ordinalCharsList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isStreetNotContainTerm(String term) {
        if (streetNotContainList != null) {
            return streetNotContainList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isRomanNumber(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        char[] termChars = term.toUpperCase().toCharArray();
        for (int i = 0; i < termChars.length; ++i) {
            int j;
            for (j = 0; j < romanNumberChars.length && termChars[i] != romanNumberChars[j]; ++j) {
            }
            if (j != romanNumberChars.length) continue;
            return false;
        }
        return true;
    }

    public static void loadExtendedChars(String key, String chars) {
        if (chars == null || chars.trim().length() == 0) {
            return;
        }
        if (extendedCharsList == null) {
            extendedCharsList = new ArrayList(10);
        }
        if (extenedcharMap == null) {
            extenedcharMap = new HashMap();
        }
        StringTokenizer st = new StringTokenizer(chars, ",");
        String exChar = null;
        while (st.hasMoreTokens()) {
            exChar = st.nextToken().trim().toUpperCase();
            extendedCharsList.add(exChar);
            extenedcharMap.put(exChar, key.substring(EXTENDED_CHARS.length()));
        }
    }

    public static void loadOrdinalChars(String chars) {
        if (chars == null || chars.trim().length() == 0) {
            return;
        }
        if (ordinalCharsList == null) {
            ordinalCharsList = new ArrayList(10);
        }
        StringTokenizer st = new StringTokenizer(chars, ",");
        String orChar = null;
        while (st.hasMoreTokens()) {
            orChar = st.nextToken().trim().toUpperCase();
            ordinalCharsList.add(orChar);
        }
    }

    public static boolean isExtendedChar(String ch) {
        if (ch != null && ch.length() == 1) {
            return FIN_AddressTerm.isExtendedChar(ch.charAt(0));
        }
        return false;
    }

    public static boolean isExtendedChar(char ch) {
        Character exChar = new Character(Character.toUpperCase(ch));
        if (extendedCharsList == null) {
            return false;
        }
        return extendedCharsList.contains(exChar);
    }

    public static boolean isValidPunctuationCharacter(char ch) {
        for (int i = 0; i < validPunctuationChars.length; ++i) {
            if (ch != validPunctuationChars[i]) continue;
            return true;
        }
        return false;
    }

    private static void loadDirectionals(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (directionalList == null) {
                directionalList = new ArrayList(10);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            String directional = null;
            while (st.hasMoreTokens()) {
                directional = st.nextToken().trim();
                if (directional.length() <= 0) continue;
                directionalList.add(directional.toUpperCase());
            }
        }
    }

    public static boolean isDirectional(String term) {
        if (term == null || directionalList == null) {
            return false;
        }
        return directionalList.contains(term.toUpperCase());
    }

    private static void loadPreNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (preNumStreetWordList == null) {
            preNumStreetWordList = new ArrayList(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        String word = null;
        while (st.hasMoreTokens()) {
            word = st.nextToken().trim();
            preNumStreetWordList.add(word.toUpperCase());
        }
    }

    private static void loadPostNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (postNumStreetWordList == null) {
            postNumStreetWordList = new ArrayList(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        String word = null;
        while (st.hasMoreTokens()) {
            word = st.nextToken().trim();
            postNumStreetWordList.add(word.toUpperCase());
        }
    }

    public static boolean isPreNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return preNumStreetWordList.contains(word.toUpperCase());
    }

    public static boolean isPostNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return postNumStreetWordList.contains(word.toUpperCase());
    }

    public static char convertAccent(char anAccent) {
        return Character.toUpperCase(anAccent);
    }

    protected static void loadDiacritics() {
        String filename = FIN_SPECIAL_CHAR_PROPERTIRS;
        try {
            diacritics = FileUtilities.loadProperties((String)filename);
        }
        catch (FileNotFoundException fx) {
            System.err.println("Could not find FINSpecialCharacters.properties");
            System.exit(1);
        }
        catch (IOException iox) {
            System.err.println("Could not read FINSpecialCharacters.properties");
            System.exit(1);
        }
    }

    public static String removeDiacritics(String s) {
        StringBuffer result = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            String tmp = String.valueOf(chars[i]);
            if (diacritics.containsKey(tmp)) {
                result.append(diacritics.getProperty(tmp));
                continue;
            }
            result.append(tmp);
        }
        if (result.toString().trim().length() > 0) {
            return result.toString().trim();
        }
        return null;
    }

    private static void loadMultiWordAreaNames() {
        String filename = FIN_MULTI_WORD_AREA_NAME_PROPERTIES;
        try {
            InputStream in = FIN_AddressTerm.class.getResourceAsStream(filename);
            BufferedReader stream = new BufferedReader(new InputStreamReader(in));
            multiWordAreaNames = new ArrayList();
            String s = null;
            while ((s = stream.readLine()) != null) {
                s = FIN_AddressTerm.removeDiacritics(s);
                multiWordAreaNames.add(s.toUpperCase());
            }
        }
        catch (FileNotFoundException fx) {
            System.err.println("Could not find " + filename);
            System.exit(1);
        }
        catch (IOException iox) {
            System.err.println("Could not read " + filename);
            System.exit(1);
        }
    }

    public static boolean isMultiWordAreaName(String word) {
        if (word == null) {
            return false;
        }
        return multiWordAreaNames.contains(FIN_AddressTerm.removeDiacritics(word.toUpperCase()));
    }

    public static String getExtendedChar(char ch) {
        Character exChar = new Character(Character.toUpperCase(ch));
        if (extenedcharMap == null) {
            return null;
        }
        String value = null;
        if (extenedcharMap.get(exChar) != null) {
            value = extenedcharMap.get(exChar).toString();
        }
        if (value != null) {
            return value;
        }
        return null;
    }

    public static String replaceExtendedChars(String word) {
        if (word == null) {
            return null;
        }
        Set set = extenedcharMap.keySet();
        String key = null;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            key = iter.next().toString().toUpperCase();
            if (word.toUpperCase().indexOf(key) == -1) continue;
            word = word.toUpperCase().replaceAll(key, extenedcharMap.get(key).toString().toUpperCase());
        }
        return word;
    }

    static {
        extenedcharMap = null;
        try {
            FIN_AddressTerm.loadDiacritics();
            FIN_AddressTerm.loadMultiWordAreaNames();
            properties = new Properties();
            properties.load(FIN_AddressTerm.class.getResourceAsStream("FIN_AddressTerm.properties"));
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
                    FIN_AddressTerm.loadPunctuations(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COUNTRY_CODES_KEY)) {
                    FIN_AddressTerm.loadCountryCodes(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COMMON_TERMS_KEY)) {
                    FIN_AddressTerm.loadCommonTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_START)) {
                    FIN_AddressTerm.loadHnrStartTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_CAN_CONTAIN)) {
                    FIN_AddressTerm.loadHnrContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(STREET_NOT_CONTAIN)) {
                    FIN_AddressTerm.loadStreetNotContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(EXTENDED_CHARS)) {
                    FIN_AddressTerm.loadExtendedChars(key, properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(DIRECTIONALS)) {
                    FIN_AddressTerm.loadDirectionals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(PRE_NUM_STREET_WORD)) {
                    FIN_AddressTerm.loadPreNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(POST_NUM_STREET_WORD)) {
                    FIN_AddressTerm.loadPostNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ORDINAL_CHARS)) {
                    FIN_AddressTerm.loadOrdinalChars(properties.getProperty(key));
                    continue;
                }
                if (!key.startsWith(COMPANY_SUFFIXES)) continue;
                FIN_AddressTerm.loadCompanySuffixes(properties.getProperty(key));
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for FIN_Parser.");
        }
    }
}

