/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import com.mapinfo.mapmarker.EMEA.parser.EMEA_PreParseHandler;
import com.mapinfo.mapmarker.FIN.FIN_AddressUtils;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;

public class FIN_PreParseHandler
extends EMEA_PreParseHandler {
    public static final String INPUT_HOUSE_NUMBER = "input_house_number";
    public static final String UNPARSED_INPUT_STREET = "unparsed_input_street";
    private static final int REGEX = 0;
    private static final int REPLACEMENT = 1;
    private static final String[] TAB_RULE = new String[]{"\t", " "};
    private static final String[] APOSTROPHE_RULE = new String[]{"[\"`]", "'"};
    private static final String[] PARENTHESIS_RULE = new String[]{"[/( /)]", " "};

    @Override
    public Address preParse(Address ura, IHandler handler) {
        Address parsedAddr = super.preParse(ura, handler);
        if (!FIN_AddressUtils.isEmpty(parsedAddr.getAreaName4())) {
            parsedAddr.setAreaName4(null);
        }
        return parsedAddr;
    }

    @Override
    protected String formatData(String val, int type) {
        if (val.trim().length() == 0) {
            return null;
        }
        val = this.applyRules(val);
        switch (type) {
            case 0: {
                return val.toUpperCase();
            }
            case 1: {
                return val.toLowerCase();
            }
        }
        return val;
    }

    private String applyRules(String str) {
        str = this.normaliseString(str, APOSTROPHE_RULE);
        str = this.normaliseString(str, PARENTHESIS_RULE);
        str = this.normaliseString(str, TAB_RULE);
        return str.trim();
    }

    private String normaliseString(String raw, String[] rule) {
        String normalisedString = null;
        if (raw != null) {
            normalisedString = raw.replaceAll(rule[0], rule[1]);
        }
        return normalisedString;
    }
}

