/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_Handler;
import com.mapinfo.mapmarker.FRA.FRA_TerritoryGeocoderWrapper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_DataManager;
import com.mapinfo.mapmarker.FRA.singleline.FRASingleLineParser;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.CoreGeocoder;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;

public class FRAGeocodableAddressFactory
extends GeocodableAddressFactory {
    private String m_Territory;

    public FRAGeocodableAddressFactory() {
    }

    public FRAGeocodableAddressFactory(String territory) {
        this.m_Territory = territory;
    }

    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        FRAGeocodingFactory factory = new FRAGeocodingFactory();
        IGeocoder aGeocoder = SingleLineGeocoder.getGeocoder((IGeocoderFactory)factory, (ISingleLineParser)new FRASingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
        if (this.m_Territory != null) {
            aGeocoder = new FRA_TerritoryGeocoderWrapper(aGeocoder, this.m_Territory);
        }
        return aGeocoder;
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            FRA_DataManager data = new FRA_DataManager();
            data.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    private static class FRAGeocodingFactory
    implements IGeocoderFactory {
        private FRAGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            return new CoreGeocoder(FRA_Handler.buildHandler(address));
        }
    }
}

