/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.address.CoreAddressGeocoder;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class FRA_AddressGeocoder
implements IAddressGeocoder {
    private final CoreAddressGeocoder m_coreAddresseGeocoder = new CoreAddressGeocoder();

    public GeocodeResult geocode(IConstraints preferences, ResourceBundle bundle) throws MMInternalFatalException, MapMarkerInternalException {
        IHandler handler;
        GeocodeResult geocodeResult;
        int debugLevel;
        block12: {
            debugLevel = DebugLevel.getDebugLevel((int)1);
            geocodeResult = new GeocodeResult();
            handler = preferences.getHandler();
            try {
                Address pa = handler.getParsedAddress();
                if (handler.isParsedIntersection()) {
                    ((ICoreAddressGeocoder)handler).getStreetGeocoder().geocodeIntersection(preferences, debugLevel, geocodeResult);
                    break block12;
                }
                if (handler.getParsedAddress() != null) {
                    if (StringUtilities.isEmpty((String)pa.getMainAddress()) && !StringUtilities.isEmpty((String)pa.getPlaceName())) {
                        preferences.setCustomObject((Object)"search.placename.only", (Object)true);
                    }
                    ((ICoreAddressGeocoder)handler).getStreetGeocoder().geocodeSingleAddress(preferences, debugLevel, geocodeResult);
                    break block12;
                }
                if (debugLevel >= 1) {
                    MMJLog.getLog().debug(bundle.getString("err_Parser_no_parse"));
                }
                throw new MMGeneralGeocoderException(2304);
            }
            catch (MapMarkerInternalException e) {
                geocodeResult = new GeocodeResult();
                if (debugLevel < 1) break block12;
                MMJLog.getLog().debug("Exception thrown on geocode", (Throwable)e);
            }
        }
        if (geocodeResult.getNumberCloseCandidates() == 0) {
            List savedMatchedCandidates = handler.getMatchResults();
            GeocodeResult fallbackResult = this.m_coreAddresseGeocoder.handleFallback(preferences);
            if (fallbackResult == null) {
                handler.setGeocodeResult(geocodeResult);
                handler.setMatchResults(savedMatchedCandidates);
            } else {
                geocodeResult.copy(fallbackResult);
            }
        }
        if (debugLevel >= 1) {
            MMJLog.getLog().debug(geocodeResult.toString());
        }
        if (geocodeResult.getNumberCloseCandidates() > 1) {
            List sortedMatchResults = null;
            sortedMatchResults = geocodeResult.getIntersectionStatus() ? ((ICoreAddressGeocoder)handler).getMatcher().filterIntersectionCloseMatches(handler.getParsedAddressArray(), handler.getMatchResults()) : (((ICoreAddressGeocoder)handler).getGeoFallbackOccured() ? ((ICoreAddressGeocoder)handler).getGeographicCentroidFilter().filterGeographicCloseMatches(handler) : (((ICoreAddressGeocoder)handler).getPostalFallbackOccured() ? ((ICoreAddressGeocoder)handler).getPostalCentroidFilter().filterPostalCloseMatches(handler) : ((ICoreAddressGeocoder)handler).getMatcher().filterCloseMatches(handler.getParsedAddressArray(), handler.getMatchResults())));
            this.countCandidates(sortedMatchResults, geocodeResult);
            this.countCloseMatches(sortedMatchResults, geocodeResult);
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(sortedMatchResults);
            if (debugLevel >= 1) {
                MMJLog.getLog().debug(geocodeResult.toString());
            }
        }
        return geocodeResult;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }
}

