/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;

public class FRA_AddressUtils {
    private static final double CLOSE_MATCH_SCORE = 1.0;

    private FRA_AddressUtils() {
    }

    public static String getFormattedStreetAddress(Address addr, boolean bAppendAddressNumber) {
        String postDir;
        String postAddr;
        String newMainAddress;
        StringBuffer buf = new StringBuffer(40);
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((newMainAddress = addr.getMainAddress()) != null) {
            buf.append(newMainAddress);
        }
        if ((postAddr = addr.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr);
        }
        if ((postDir = addr.getPostDirectional()) != null) {
            buf.append(postDir);
        }
        if (bAppendAddressNumber && addr.getAddressNumber() != null) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != ' ') {
                buf.append(' ');
            }
            buf.append(addr.getAddressNumber());
        }
        return buf.toString().trim();
    }

    public static boolean isPrefixAndSuffixCloseMatch(Address input, InternalCandidateAddress addr) {
        boolean postMatch;
        boolean isCloseMatch = true;
        boolean preMatch = FRA_AddressUtils.isEmpty(input.getPreAddress()) || addr.getPreAddressScore() == 1.0;
        boolean bl = postMatch = FRA_AddressUtils.isEmpty(input.getPostAddress()) || addr.getPostAddressScore() == 1.0;
        if (!preMatch || !postMatch) {
            isCloseMatch = false;
        }
        return isCloseMatch;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

