/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_AddressGeocoder;
import com.mapinfo.mapmarker.FRA.FRA_IntersectionHelper;
import com.mapinfo.mapmarker.FRA.FRA_LocalConstraintsHelper;
import com.mapinfo.mapmarker.FRA.FRA_MatcherConstants;
import com.mapinfo.mapmarker.FRA.FRA_MatcherHandler;
import com.mapinfo.mapmarker.FRA.FRA_ParsedInputAddressHelper;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.FRA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.FRA.browse.FRA_BrowseGeocoder;
import com.mapinfo.mapmarker.FRA.browse.FRA_BrowseHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_DataManager;
import com.mapinfo.mapmarker.FRA.filters.AdditionalParserFieldsFilterRule;
import com.mapinfo.mapmarker.FRA.filters.BetterCandidateFilterRule;
import com.mapinfo.mapmarker.FRA.filters.BetterProperNameMatchFilterRule;
import com.mapinfo.mapmarker.FRA.filters.BetterTownMatchFilterRule;
import com.mapinfo.mapmarker.FRA.filters.DirectionalFilterRule;
import com.mapinfo.mapmarker.FRA.filters.FRA_FinalDemoteDuplicateRecordsFilterRule;
import com.mapinfo.mapmarker.FRA.filters.FRA_GeoAreaName4ScoreFilter;
import com.mapinfo.mapmarker.FRA.filters.HouseNumberFilterRule;
import com.mapinfo.mapmarker.FRA.filters.InputCompoundNumberFilterRule;
import com.mapinfo.mapmarker.FRA.filters.PlaceNameFilterRule;
import com.mapinfo.mapmarker.FRA.filters.RemoveEquidistantHouseNumberFilterRule;
import com.mapinfo.mapmarker.FRA.filters.StreetTypeFilterRule;
import com.mapinfo.mapmarker.FRA.filters.TighterRangeFilterRule;
import com.mapinfo.mapmarker.FRA.matcher.FRA_MatchConstraintsConverter;
import com.mapinfo.mapmarker.FRA.parser.FRA_ParseRuleHandler;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.IParsedInputAddressHelper;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.filters.DictionaryUserPriorityCloseMatchFilter;
import com.mapinfo.mapmarker.common.filters.GeoAreaName4Filter;
import com.mapinfo.mapmarker.common.filters.GeoBetterCandidateFilter;
import com.mapinfo.mapmarker.common.filters.GeoDictionaryUserPriorityRule;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.common.filters.NoInputHousePreferSegmentOverPointHouseFilter;
import com.mapinfo.mapmarker.common.filters.PostalDictionaryUserPriorityRule;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.FatalHandlerException;
import com.mapinfo.mapmarker.core.HandlerValidator;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IIntersectionHelper;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.matcher.CoreMatcher;
import com.mapinfo.mapmarker.core.matcher.ICoreMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatchConstraintsConverter;
import com.mapinfo.mapmarker.core.matcher.IMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.core.parser.ICoreParser;
import com.mapinfo.mapmarker.core.parser.IParseRuleHandler;
import com.mapinfo.mapmarker.utils.MMJLog;

public class FRA_Handler
extends CoreHandler {
    private FRA_Handler() {
    }

    private static void testit() throws GeocodableAddressCreationException {
        AddressImpl addr = new AddressImpl();
        addr.setCountry("FRA");
        IHandler handler = FRA_Handler.buildHandler((Address)addr);
        try {
            HandlerValidator.validateHandler((IHandler)handler, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (FatalHandlerException ex) {
            throw new GeocodableAddressCreationException(2500, (Throwable)ex);
        }
    }

    public static IHandler buildHandler(Address address) throws GeocodableAddressCreationException {
        FRA_Handler handler;
        try {
            handler = new FRA_Handler();
            handler.setInputAddress(address);
            handler.setDataManager((IDataManager)new FRA_DataManager());
            handler.setMatcherConstants(new FRA_MatcherConstants());
            ICloseMatchFilterRule[] xsectRules = null;
            ICloseMatchFilterRule[] candRules = new ICloseMatchFilterRule[]{new BetterCandidateFilterRule(), new InputCompoundNumberFilterRule(), new TighterRangeFilterRule(), new NoInputHousePreferSegmentOverPointHouseFilter(), new DirectionalFilterRule(), new HouseNumberFilterRule(), new StreetTypeFilterRule(), new AdditionalParserFieldsFilterRule(), new BetterProperNameMatchFilterRule(), new PlaceNameFilterRule(), new BetterTownMatchFilterRule(), new RemoveEquidistantHouseNumberFilterRule(), new DictionaryUserPriorityCloseMatchFilter(), new FRA_FinalDemoteDuplicateRecordsFilterRule()};
            ((CoreHandler)handler).setMatcher((IMatcher)new CoreMatcher(candRules, xsectRules));
            ((CoreHandler)handler).setGeographicCentroidFilterRules(new ICloseMatchFilterRule[]{new GeoBetterCandidateFilter(), new FRA_GeoAreaName4ScoreFilter(), new GeoAreaName4Filter(), new GeoDictionaryUserPriorityRule()});
            ((CoreHandler)handler).setPostalFilterRules(new ICloseMatchFilterRule[]{new PostalDictionaryUserPriorityRule()});
            handler.setLocalConstraintsHelper(new FRA_LocalConstraintsHelper());
            ((ICoreMatcher)handler).setMatcherHandler((IMatcherHandler)new FRA_MatcherHandler());
            handler.setMatchConstraintsConverter((IMatchConstraintsConverter)new FRA_MatchConstraintsConverter());
            ((ICoreStreetGeocoder)handler).setScoringHelper((IScoringHelper)new FRA_ScoringHelper());
            handler.setParsedInputAddressHelper((IParsedInputAddressHelper)new FRA_ParsedInputAddressHelper());
            ((ICoreStreetGeocoder)handler).setStreetSingleAddressGeocoder((IStreetSingleAddressGeocoder)new FRA_StreetSingleAddressGeocoder((IHandler)handler));
            handler.setAddressGeocoder(new FRA_AddressGeocoder());
            handler.setBrowseGeocoder(new FRA_BrowseGeocoder());
            handler.setBrowseHelper(new FRA_BrowseHelper());
            ((CoreHandler)handler).setIntersectionHelper((IIntersectionHelper)new FRA_IntersectionHelper());
            FRA_ParseRuleHandler parse = new FRA_ParseRuleHandler();
            ((ICoreParser)handler).setRuleHandler((IParseRuleHandler)parse);
            parse.addParsingRules((IHandler)handler);
            handler.setGeocodePostalSupported(true);
            handler.setGeocodeGeographicSupported(true);
            handler.setGeocodeSupported(true);
            handler.setBrowseSupported(true);
            handler.setStandardizeSupported(true);
        }
        catch (MMJEDataManagerInitializationException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException && t.getCause() instanceof FatalDataAccessException) {
                FatalDataAccessException dex = (FatalDataAccessException)t.getCause();
                throw new GeocodableAddressCreationException(dex.getErrorCode(), (Throwable)dex);
            }
            throw new GeocodableAddressCreationException(2306, (Throwable)e);
        }
        return handler;
    }

    static {
        try {
            FRA_Handler.testit();
        }
        catch (GeocodableAddressCreationException ex) {
            MMJLog.getLog().error("Unable to create FRA_Handler", (Throwable)ex);
        }
    }
}

